/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import de.justsoftware.authorization.config.SecurityConfig;
import de.justsoftware.authorization.id.ItemIdDeserializer;
import de.justsoftware.authorization.id.ItemIdSerializer;
import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.JustAuthenticationProvider;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.JustUserDetailService;
import de.justsoftware.authorization.oauth2.MobileClientRefreshTokenAuthenticationConverter;
import de.justsoftware.authorization.oauth2.MobileClientRefreshTokenAuthenticationProvider;
import de.justsoftware.authorization.oauth2.MobileOauth2RefreshTokenGenerator;
import de.justsoftware.authorization.oauth2.client.ExposedRegisteredClientRepository;
import de.justsoftware.authorization.token.RememberMeTokenRepository;
import java.time.Duration;
import java.util.UUID;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.RememberMeConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.jackson2.SecurityJackson2Modules;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.NimbusJwtEncoder;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configuration.OAuth2AuthorizationServerConfiguration;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2ClientAuthenticationConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OidcConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OidcLogoutEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.jackson2.OAuth2AuthorizationServerJackson2Module;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.security.oauth2.server.authorization.token.DelegatingOAuth2TokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.JwtGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2AccessTokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2RefreshTokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@DependsOn(value={"liquibase"})
@RefreshScope
@Configuration
@EnableWebSecurity
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 +2\u00020\u0001:\u0003+,-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017JJ\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\b\u0010\u0017\u001a\u00020\u0018H\u0017J,\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u001a\u001a\u00020\u00162\b\b\u0001\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u001bH\u0017J \u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0017J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0017J\b\u0010\u001e\u001a\u00020\u001fH\u0017JL\u0010\u000b\u001a\u00020\f2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010\u00162\b\b\u0001\u0010!\u001a\u00020\u00162\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\"\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lde/justsoftware/authorization/config/SecurityConfig;", "", "authProvider", "Lde/justsoftware/authorization/oauth2/JustAuthenticationProvider;", "(Lde/justsoftware/authorization/oauth2/JustAuthenticationProvider;)V", "authManager", "Lorg/springframework/security/authentication/AuthenticationManager;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "authorizationServerSecurityFilterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "registeredClientRepository", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;", "justTokenGenerator", "Lorg/springframework/security/oauth2/server/authorization/token/OAuth2TokenGenerator;", "Lorg/springframework/security/oauth2/core/OAuth2Token;", "jwkSource", "Lcom/nimbusds/jose/jwk/source/JWKSource;", "Lcom/nimbusds/jose/proc/SecurityContext;", "rememberMeServices", "Lorg/springframework/security/web/authentication/rememberme/PersistentTokenBasedRememberMeServices;", "systemDomainPrefix", "", "authorizationServerSettings", "Lorg/springframework/security/oauth2/server/authorization/settings/AuthorizationServerSettings;", "defaultSecurityFilterChain", "internalBasePath", "Lorg/springframework/security/web/authentication/RememberMeServices;", "jwtDecoder", "Lorg/springframework/security/oauth2/jwt/JwtDecoder;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "clientId", "clientSecret", "mobileLoginAccessTokenValidityInSeconds", "", "mobileLoginRefreshTokenValidityInSeconds", "dataSource", "Ljavax/sql/DataSource;", "rememberMeTokenRepository", "Lde/justsoftware/authorization/token/RememberMeTokenRepository;", "userDetailService", "Lde/justsoftware/authorization/oauth2/JustUserDetailService;", "Companion", "InvalidateSessionAfterAuthorizationSuccessResponseHandler", "LogoutSuccessHandler", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nSecurityConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecurityConfig.kt\nde/justsoftware/authorization/config/SecurityConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,416:1\n1#2:417\n*E\n"})
public class SecurityConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JustAuthenticationProvider authProvider;
    private static final int KEY_SIZE = 2048;
    private static final int THIRTY_DAYS_IN_SECONDS = 2592000;
    @NotNull
    private static final String SESSION_COOKIE_NAME = "JSESSIONID";

    public SecurityConfig(@NotNull JustAuthenticationProvider authProvider) {
        Intrinsics.checkNotNullParameter((Object)authProvider, (String)"authProvider");
        this.authProvider = authProvider;
    }

    @Bean
    @NotNull
    public AuthenticationManager authManager(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        AuthenticationManagerBuilder authenticationManagerBuilder = (AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class);
        authenticationManagerBuilder.authenticationProvider((AuthenticationProvider)this.authProvider);
        Object object = authenticationManagerBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (AuthenticationManager)object;
    }

    @Bean
    @Order(value=1)
    @NotNull
    public SecurityFilterChain authorizationServerSecurityFilterChain(@NotNull HttpSecurity http, @NotNull RegisteredClientRepository registeredClientRepository2, @NotNull OAuth2TokenGenerator<? extends OAuth2Token> justTokenGenerator, @NotNull JWKSource<SecurityContext> jwkSource, @NotNull PersistentTokenBasedRememberMeServices rememberMeServices, @Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)registeredClientRepository2, (String)"registeredClientRepository");
        Intrinsics.checkNotNullParameter(justTokenGenerator, (String)"justTokenGenerator");
        Intrinsics.checkNotNullParameter(jwkSource, (String)"jwkSource");
        Intrinsics.checkNotNullParameter((Object)rememberMeServices, (String)"rememberMeServices");
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        http.setSharedObject(JWKSource.class, jwkSource);
        OAuth2AuthorizationServerConfiguration.applyDefaultSecurity((HttpSecurity)http);
        ((OAuth2AuthorizationServerConfigurer)http.getConfigurer(OAuth2AuthorizationServerConfigurer.class)).oidc(arg_0 -> SecurityConfig.authorizationServerSecurityFilterChain$lambda$1(rememberMeServices, systemDomainPrefix, arg_0)).clientAuthentication(arg_0 -> SecurityConfig.authorizationServerSecurityFilterChain$lambda$2(registeredClientRepository2, arg_0)).authorizationEndpoint(SecurityConfig::authorizationServerSecurityFilterChain$lambda$3).tokenGenerator(justTokenGenerator);
        http.exceptionHandling(SecurityConfig::authorizationServerSecurityFilterChain$lambda$4).oauth2ResourceServer(SecurityConfig::authorizationServerSecurityFilterChain$lambda$5).sessionManagement(SecurityConfig::authorizationServerSecurityFilterChain$lambda$6);
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    @Bean
    @Order(value=2)
    @NotNull
    public SecurityFilterChain defaultSecurityFilterChain(@NotNull HttpSecurity http, @Value(value="${internal.base-path}") @NotNull String internalBasePath, @Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix, @NotNull RememberMeServices rememberMeServices) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)internalBasePath, (String)"internalBasePath");
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        Intrinsics.checkNotNullParameter((Object)rememberMeServices, (String)"rememberMeServices");
        http.authorizeHttpRequests(arg_0 -> SecurityConfig.defaultSecurityFilterChain$lambda$7(internalBasePath, arg_0)).formLogin(arg_0 -> SecurityConfig.defaultSecurityFilterChain$lambda$8(systemDomainPrefix, arg_0)).csrf(Customizer.withDefaults()).sessionManagement(SecurityConfig::defaultSecurityFilterChain$lambda$9).rememberMe(arg_0 -> SecurityConfig.defaultSecurityFilterChain$lambda$10(rememberMeServices, arg_0));
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    @Bean
    @NotNull
    public PersistentTokenBasedRememberMeServices rememberMeServices(@NotNull RememberMeTokenRepository rememberMeTokenRepository, @NotNull JustUserDetailService userDetailService) {
        Intrinsics.checkNotNullParameter((Object)rememberMeTokenRepository, (String)"rememberMeTokenRepository");
        Intrinsics.checkNotNullParameter((Object)userDetailService, (String)"userDetailService");
        PersistentTokenBasedRememberMeServices service = new PersistentTokenBasedRememberMeServices("just", (UserDetailsService)userDetailService, (PersistentTokenRepository)rememberMeTokenRepository);
        service.setCookieName("remember");
        service.setParameter("remember");
        return service;
    }

    @RefreshScope
    @Bean
    @NotNull
    public OAuth2TokenGenerator<? extends OAuth2Token> justTokenGenerator(@NotNull JWKSource<SecurityContext> jwkSource) {
        Intrinsics.checkNotNullParameter(jwkSource, (String)"jwkSource");
        JwtGenerator jwtGenerator = new JwtGenerator((JwtEncoder)new NimbusJwtEncoder(jwkSource));
        OAuth2TokenCustomizer customizer = SecurityConfig::justTokenGenerator$lambda$12;
        jwtGenerator.setJwtCustomizer(customizer);
        OAuth2AccessTokenGenerator accessTokenGenerator = new OAuth2AccessTokenGenerator();
        OAuth2RefreshTokenGenerator refreshTokenGenerator = new OAuth2RefreshTokenGenerator();
        MobileOauth2RefreshTokenGenerator mobileRefreshTokenGenerator = new MobileOauth2RefreshTokenGenerator();
        OAuth2TokenGenerator[] oAuth2TokenGeneratorArray = new OAuth2TokenGenerator[]{jwtGenerator, accessTokenGenerator, refreshTokenGenerator, mobileRefreshTokenGenerator};
        return (OAuth2TokenGenerator)new DelegatingOAuth2TokenGenerator(oAuth2TokenGeneratorArray);
    }

    @Bean
    @NotNull
    public RegisteredClientRepository registeredClientRepository(@Value(value="${just.toro.oauth.clientId}") @Nullable String clientId, @Value(value="${just.toro.oauth.clientSecret}") @NotNull String clientSecret, @Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix, @Value(value="${just.login.mobile.access_token_validity_seconds:28800}") long mobileLoginAccessTokenValidityInSeconds, @Value(value="${just.login.mobile.refresh_token_validity_seconds:15778800}") long mobileLoginRefreshTokenValidityInSeconds, @NotNull DataSource dataSource, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        RegisteredClient loginClient = RegisteredClient.withId((String)UUID.randomUUID().toString()).clientId("just-auth-login").clientSecret("{noop}" + clientSecret).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).authorizationGrantType(AuthorizationGrantType.REFRESH_TOKEN).redirectUri(systemDomainPrefix + "/login/oauth2/code/just-auth-login").postLogoutRedirectUri(systemDomainPrefix + "/just/loggedOut").scope("openid").scope("profile").tokenSettings(TokenSettings.builder().accessTokenFormat(OAuth2TokenFormat.SELF_CONTAINED).build()).clientSettings(ClientSettings.builder().requireAuthorizationConsent(true).build()).build();
        RegisteredClient mobileLoginClient = RegisteredClient.withId((String)UUID.randomUUID().toString()).clientId("just-auth-mobile-login").clientAuthenticationMethod(ClientAuthenticationMethod.NONE).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).authorizationGrantType(AuthorizationGrantType.REFRESH_TOKEN).redirectUri("de.justsoftware.mobile.social://oauth2redirect/").redirectUri("de.justsoftware.mobile.justsocial://oauth2redirect").redirectUri("de.justsoftware.mobile.justsocial.debug://oauth2redirect").scope("openid").scope("profile").tokenSettings(TokenSettings.builder().accessTokenTimeToLive(Duration.ofSeconds(mobileLoginAccessTokenValidityInSeconds)).refreshTokenTimeToLive(Duration.ofSeconds(mobileLoginRefreshTokenValidityInSeconds)).reuseRefreshTokens(false).build()).clientSettings(ClientSettings.builder().requireAuthorizationConsent(false).requireProofKey(true).build()).build();
        ExposedRegisteredClientRepository repository = new ExposedRegisteredClientRepository(objectMapper);
        Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)dataSource, null, null, null, (int)14, null);
        ThreadLocalTransactionManagerKt.transaction$default(null, (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        return (RegisteredClientRepository)repository;
    }

    @Bean
    @NotNull
    public ObjectMapper objectMapper() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Module[] moduleArray = new Module[]{ItemIdSerializer.INSTANCE, ItemIdDeserializer.INSTANCE};
        JsonMapper objectMapper = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)ExtensionsKt.jacksonMapperBuilder().addModule((Module)new OAuth2AuthorizationServerJackson2Module())).addModules((Iterable)SecurityJackson2Modules.getModules((ClassLoader)classLoader))).addModules(moduleArray)).build();
        Intrinsics.checkNotNull((Object)objectMapper);
        return (ObjectMapper)objectMapper;
    }

    @RefreshScope
    @Bean
    @NotNull
    public JwtDecoder jwtDecoder(@NotNull JWKSource<SecurityContext> jwkSource) {
        Intrinsics.checkNotNullParameter(jwkSource, (String)"jwkSource");
        JwtDecoder jwtDecoder = OAuth2AuthorizationServerConfiguration.jwtDecoder(jwkSource);
        Intrinsics.checkNotNullExpressionValue((Object)jwtDecoder, (String)"jwtDecoder(...)");
        return jwtDecoder;
    }

    @Bean
    @NotNull
    public AuthorizationServerSettings authorizationServerSettings() {
        AuthorizationServerSettings authorizationServerSettings = AuthorizationServerSettings.builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)authorizationServerSettings, (String)"build(...)");
        return authorizationServerSettings;
    }

    private static final void authorizationServerSecurityFilterChain$lambda$1$lambda$0(PersistentTokenBasedRememberMeServices $rememberMeServices, String $systemDomainPrefix, OidcLogoutEndpointConfigurer l) {
        Intrinsics.checkNotNullParameter((Object)$rememberMeServices, (String)"$rememberMeServices");
        Intrinsics.checkNotNullParameter((Object)$systemDomainPrefix, (String)"$systemDomainPrefix");
        l.logoutResponseHandler((AuthenticationSuccessHandler)new LogoutSuccessHandler($rememberMeServices, $systemDomainPrefix));
    }

    private static final void authorizationServerSecurityFilterChain$lambda$1(PersistentTokenBasedRememberMeServices $rememberMeServices, String $systemDomainPrefix, OidcConfigurer oidc) {
        Intrinsics.checkNotNullParameter((Object)$rememberMeServices, (String)"$rememberMeServices");
        Intrinsics.checkNotNullParameter((Object)$systemDomainPrefix, (String)"$systemDomainPrefix");
        oidc.logoutEndpoint(arg_0 -> SecurityConfig.authorizationServerSecurityFilterChain$lambda$1$lambda$0($rememberMeServices, $systemDomainPrefix, arg_0));
    }

    private static final void authorizationServerSecurityFilterChain$lambda$2(RegisteredClientRepository $registeredClientRepository, OAuth2ClientAuthenticationConfigurer clientAuthentication) {
        Intrinsics.checkNotNullParameter((Object)$registeredClientRepository, (String)"$registeredClientRepository");
        clientAuthentication.authenticationConverter((AuthenticationConverter)new MobileClientRefreshTokenAuthenticationConverter()).authenticationProvider((AuthenticationProvider)new MobileClientRefreshTokenAuthenticationProvider($registeredClientRepository));
    }

    private static final void authorizationServerSecurityFilterChain$lambda$3(OAuth2AuthorizationEndpointConfigurer it) {
        it.authorizationResponseHandler((AuthenticationSuccessHandler)new InvalidateSessionAfterAuthorizationSuccessResponseHandler());
    }

    private static final void authorizationServerSecurityFilterChain$lambda$4(ExceptionHandlingConfigurer exceptions) {
        Intrinsics.checkNotNullParameter((Object)exceptions, (String)"exceptions");
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.TEXT_HTML};
        exceptions.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint("/login"), (RequestMatcher)new MediaTypeRequestMatcher(mediaTypeArray));
    }

    private static final void authorizationServerSecurityFilterChain$lambda$5(OAuth2ResourceServerConfigurer resourceServer) {
        Intrinsics.checkNotNullParameter((Object)resourceServer, (String)"resourceServer");
        resourceServer.jwt(Customizer.withDefaults());
    }

    private static final void authorizationServerSecurityFilterChain$lambda$6(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.NEVER);
    }

    private static final void defaultSecurityFilterChain$lambda$7(String $internalBasePath, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        Intrinsics.checkNotNullParameter((Object)$internalBasePath, (String)"$internalBasePath");
        String[] stringArray = new String[]{"/oauth2/token/**"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).permitAll();
        stringArray = new String[]{$internalBasePath + "/**"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.anyRequest()).authenticated();
    }

    private static final void defaultSecurityFilterChain$lambda$8(String $systemDomainPrefix, FormLoginConfigurer formLogin) {
        Intrinsics.checkNotNullParameter((Object)$systemDomainPrefix, (String)"$systemDomainPrefix");
        ((FormLoginConfigurer)formLogin.loginPage("/login").defaultSuccessUrl($systemDomainPrefix)).permitAll();
    }

    private static final void defaultSecurityFilterChain$lambda$9(SessionManagementConfigurer session) {
        session.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED);
    }

    private static final void defaultSecurityFilterChain$lambda$10(RememberMeServices $rememberMeServices, RememberMeConfigurer remember) {
        Intrinsics.checkNotNullParameter((Object)$rememberMeServices, (String)"$rememberMeServices");
        remember.rememberMeServices($rememberMeServices).tokenValiditySeconds(2592000).useSecureCookie(true).authenticationSuccessHandler((AuthenticationSuccessHandler)new SavedRequestAwareAuthenticationSuccessHandler());
    }

    private static final void justTokenGenerator$lambda$12(JwtEncodingContext it) {
        Object principal = ((AbstractAuthenticationToken)it.getPrincipal()).getPrincipal();
        if (!(principal instanceof JustUser)) {
            boolean bl = false;
            String string = "Principal can only be JustUser not " + Reflection.getOrCreateKotlinClass(principal.getClass());
            throw new IllegalArgumentException(string.toString());
        }
        it.getClaims().claim(TenantId.Companion.getJsonKey(), (Object)((JustUser)principal).getTenantId().toTypedString());
        it.getClaims().claim(ProfileId.Companion.getJsonKey(), (Object)((JustUser)principal).getProfileId().toTypedString());
    }
}

