/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.config;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import de.justsoftware.authorization.ZookeeperConfigService;
import de.justsoftware.authorization.config.SecurityConfig;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@RefreshScope
@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B9\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0012J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0017R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/authorization/config/JwkConfigProperties;", "Lorg/springframework/beans/factory/InitializingBean;", "publicKeyString", "", "privateKeyString", "id", "Ljava/util/UUID;", "configService", "Lde/justsoftware/authorization/ZookeeperConfigService;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/UUID;Lde/justsoftware/authorization/ZookeeperConfigService;Lorg/springframework/context/ApplicationEventPublisher;)V", "getConfigService", "()Lde/justsoftware/authorization/ZookeeperConfigService;", "getEventPublisher", "()Lorg/springframework/context/ApplicationEventPublisher;", "getId", "()Ljava/util/UUID;", "getPrivateKeyString", "()Ljava/lang/String;", "getPublicKeyString", "afterPropertiesSet", "", "isValid", "", "jwkSource", "Lcom/nimbusds/jose/jwk/source/JWKSource;", "Lcom/nimbusds/jose/proc/SecurityContext;", "just-authorization-server"})
public class JwkConfigProperties
implements InitializingBean {
    @Nullable
    private final String publicKeyString;
    @Nullable
    private final String privateKeyString;
    @Nullable
    private final UUID id;
    @NotNull
    private final ZookeeperConfigService configService;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;

    public JwkConfigProperties(@Value(value="${just.auth.jwk.publicKey:}") @Nullable String publicKeyString, @Value(value="${just.auth.jwk.privateKey:}") @Nullable String privateKeyString, @Value(value="${just.auth.jwk.id:}") @Nullable UUID id, @NotNull ZookeeperConfigService configService, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.publicKeyString = publicKeyString;
        this.privateKeyString = privateKeyString;
        this.id = id;
        this.configService = configService;
        this.eventPublisher = eventPublisher;
    }

    @Nullable
    public String getPublicKeyString() {
        return this.publicKeyString;
    }

    @Nullable
    public String getPrivateKeyString() {
        return this.privateKeyString;
    }

    @Nullable
    public UUID getId() {
        return this.id;
    }

    @NotNull
    public ZookeeperConfigService getConfigService() {
        return this.configService;
    }

    @NotNull
    public ApplicationEventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    private boolean isValid() {
        CharSequence charSequence = this.getPublicKeyString();
        return !(charSequence == null || charSequence.length() == 0) && !((charSequence = (CharSequence)this.getPrivateKeyString()) == null || charSequence.length() == 0) && this.getId() != null;
    }

    public void afterPropertiesSet() {
        if (!this.isValid()) {
            KeyPair generatedRsaKey = SecurityConfig.Companion.generateRsaKey();
            PrivateKey privateKey = generatedRsaKey.getPrivate();
            PublicKey publicKey = generatedRsaKey.getPublic();
            UUID keyId = UUID.randomUUID();
            Base64.Encoder encoder = Base64.getEncoder();
            this.getConfigService().store("/just/config/just/auth/jwk/publicKey", encoder.encodeToString(publicKey.getEncoded()));
            this.getConfigService().store("/just/config/just/auth/jwk/privateKey", encoder.encodeToString(privateKey.getEncoded()));
            this.getConfigService().store("/just/config/just/auth/jwk/id", keyId.toString());
            this.getEventPublisher().publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)"RefreshEvent", "Refreshing scope"));
        }
    }

    @RefreshScope
    @Bean
    @NotNull
    public JWKSource<SecurityContext> jwkSource() {
        PrivateKey privateKey = null;
        PublicKey publicKey = null;
        Base64.Decoder decoder = Base64.getDecoder();
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey privateKey2 = kf.generatePrivate(new PKCS8EncodedKeySpec(decoder.decode(this.getPrivateKeyString())));
        Intrinsics.checkNotNullExpressionValue((Object)privateKey2, (String)"generatePrivate(...)");
        privateKey = privateKey2;
        PublicKey publicKey2 = kf.generatePublic(new X509EncodedKeySpec(decoder.decode(this.getPublicKeyString())));
        Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"generatePublic(...)");
        publicKey = publicKey2;
        UUID uUID = this.getId();
        Intrinsics.checkNotNull((Object)uUID);
        UUID keyId = uUID;
        RSAKey rsaKey = new RSAKey.Builder((RSAPublicKey)publicKey).privateKey(privateKey).keyID(keyId.toString()).build();
        return (JWKSource)new ImmutableJWKSet(new JWKSet((JWK)rsaKey));
    }
}

