/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.utils.Utils;

public abstract class Type {
    public static final Type INT8 = new Type(){

        @Override
        public void write(ByteBuffer buffer, Object o) {
            buffer.put((Byte)o);
        }

        @Override
        public Object read(ByteBuffer buffer) {
            return buffer.get();
        }

        @Override
        public int sizeOf(Object o) {
            return 1;
        }

        public String toString() {
            return "INT8";
        }

        @Override
        public Byte validate(Object item) {
            if (item instanceof Byte) {
                return (Byte)item;
            }
            throw new SchemaException(item + " is not a Byte.");
        }
    };
    public static final Type INT16 = new Type(){

        @Override
        public void write(ByteBuffer buffer, Object o) {
            buffer.putShort((Short)o);
        }

        @Override
        public Object read(ByteBuffer buffer) {
            return buffer.getShort();
        }

        @Override
        public int sizeOf(Object o) {
            return 2;
        }

        public String toString() {
            return "INT16";
        }

        @Override
        public Short validate(Object item) {
            if (item instanceof Short) {
                return (Short)item;
            }
            throw new SchemaException(item + " is not a Short.");
        }
    };
    public static final Type INT32 = new Type(){

        @Override
        public void write(ByteBuffer buffer, Object o) {
            buffer.putInt((Integer)o);
        }

        @Override
        public Object read(ByteBuffer buffer) {
            return buffer.getInt();
        }

        @Override
        public int sizeOf(Object o) {
            return 4;
        }

        public String toString() {
            return "INT32";
        }

        @Override
        public Integer validate(Object item) {
            if (item instanceof Integer) {
                return (Integer)item;
            }
            throw new SchemaException(item + " is not an Integer.");
        }
    };
    public static final Type INT64 = new Type(){

        @Override
        public void write(ByteBuffer buffer, Object o) {
            buffer.putLong((Long)o);
        }

        @Override
        public Object read(ByteBuffer buffer) {
            return buffer.getLong();
        }

        @Override
        public int sizeOf(Object o) {
            return 8;
        }

        public String toString() {
            return "INT64";
        }

        @Override
        public Long validate(Object item) {
            if (item instanceof Long) {
                return (Long)item;
            }
            throw new SchemaException(item + " is not a Long.");
        }
    };
    public static final Type STRING = new Type(){

        @Override
        public void write(ByteBuffer buffer, Object o) {
            byte[] bytes = Utils.utf8((String)o);
            if (bytes.length > Short.MAX_VALUE) {
                throw new SchemaException("String is longer than the maximum string length.");
            }
            buffer.putShort((short)bytes.length);
            buffer.put(bytes);
        }

        @Override
        public Object read(ByteBuffer buffer) {
            short length = buffer.getShort();
            byte[] bytes = new byte[length];
            buffer.get(bytes);
            return Utils.utf8(bytes);
        }

        @Override
        public int sizeOf(Object o) {
            return 2 + Utils.utf8Length((String)o);
        }

        public String toString() {
            return "STRING";
        }

        @Override
        public String validate(Object item) {
            if (item instanceof String) {
                return (String)item;
            }
            throw new SchemaException(item + " is not a String.");
        }
    };
    public static final Type BYTES = new Type(){

        @Override
        public void write(ByteBuffer buffer, Object o) {
            ByteBuffer arg = (ByteBuffer)o;
            int pos = arg.position();
            buffer.putInt(arg.remaining());
            buffer.put(arg);
            arg.position(pos);
        }

        @Override
        public Object read(ByteBuffer buffer) {
            int size2 = buffer.getInt();
            ByteBuffer val = buffer.slice();
            val.limit(size2);
            buffer.position(buffer.position() + size2);
            return val;
        }

        @Override
        public int sizeOf(Object o) {
            ByteBuffer buffer = (ByteBuffer)o;
            return 4 + buffer.remaining();
        }

        public String toString() {
            return "BYTES";
        }

        @Override
        public ByteBuffer validate(Object item) {
            if (item instanceof ByteBuffer) {
                return (ByteBuffer)item;
            }
            throw new SchemaException(item + " is not a java.nio.ByteBuffer.");
        }
    };
    public static final Type NULLABLE_BYTES = new Type(){

        @Override
        public boolean isNullable() {
            return true;
        }

        @Override
        public void write(ByteBuffer buffer, Object o) {
            if (o == null) {
                buffer.putInt(-1);
                return;
            }
            ByteBuffer arg = (ByteBuffer)o;
            int pos = arg.position();
            buffer.putInt(arg.remaining());
            buffer.put(arg);
            arg.position(pos);
        }

        @Override
        public Object read(ByteBuffer buffer) {
            int size2 = buffer.getInt();
            if (size2 < 0) {
                return null;
            }
            ByteBuffer val = buffer.slice();
            val.limit(size2);
            buffer.position(buffer.position() + size2);
            return val;
        }

        @Override
        public int sizeOf(Object o) {
            if (o == null) {
                return 4;
            }
            ByteBuffer buffer = (ByteBuffer)o;
            return 4 + buffer.remaining();
        }

        public String toString() {
            return "NULLABLE_BYTES";
        }

        @Override
        public ByteBuffer validate(Object item) {
            if (item == null) {
                return null;
            }
            if (item instanceof ByteBuffer) {
                return (ByteBuffer)item;
            }
            throw new SchemaException(item + " is not a java.nio.ByteBuffer.");
        }
    };

    public abstract void write(ByteBuffer var1, Object var2);

    public abstract Object read(ByteBuffer var1);

    public abstract Object validate(Object var1);

    public abstract int sizeOf(Object var1);

    public boolean isNullable() {
        return false;
    }
}

