/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.harisekhon;

import com.linkedin.harisekhon.QuitException;
import com.linkedin.harisekhon.Timeout;
import com.linkedin.harisekhon.Utils;
import jline.TerminalFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CLI {
    private boolean debug = false;
    private int verbose = 0;
    private int verbose_default = 0;
    private int timeout = 0;
    private int timeout_default = 10;
    private int timeout_max = 86400;
    protected String usage_header = "Hari Sekhon - https://github.com/harisekhon\n\n";
    protected String usage_msg = "<prog> <options>";
    protected CommandLine cmd;
    protected Options options = new Options();

    public CLI() {
        this.options.addOption("t", "timeout", true, String.format("Timeout in secs (default: %s)", this.timeout_default));
        this.options.addOption("v", "verbose", false, "Verbose mode (-v, -vv, -vvv)");
        this.options.addOption("D", "debug", false, "Debug mode");
        this.options.addOption("h", "help", false, "Print usage help and exit");
    }

    public final void addHostOption(String name, String default_host, String default_port) {
        String name2 = "";
        if (name != null) {
            name2 = name + " ";
        }
        this.options.addOption("H", "host", true, "Host ($HOST)");
        this.options.addOption("P", "port", true, "Port ($PORT)");
    }

    public final void addHostOption() {
        this.addHostOption(null, null, null);
    }

    public final void addUserOption(String name, String default_user, String default_password) {
        if (name != null) {
            String name2 = name + " ";
        } else {
            String name2 = "";
        }
        this.options.addOption("u", "user", true, "Username");
        this.options.addOption("p", "password", true, "Password");
    }

    public final void addUserOption() {
        this.addUserOption(null, null, null);
    }

    public void setup() {
    }

    public final void main2(String[] args) {
        Utils.log.trace("running CLI.main2()");
        this.setup();
        try {
            this.addOptions();
        }
        catch (IllegalArgumentException e) {
            this.usage(e);
        }
        try {
            this.parseArgs2(args);
        }
        catch (Exception e) {
            if (Utils.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            this.usage(e.getMessage());
        }
        Utils.log.info(String.format("verbose level: %s", this.verbose));
        Utils.validateInt(this.timeout, "timeout", 0, this.timeout_max);
        Utils.log.info(String.format("setting timeout to %s secs", this.timeout));
        Thread t = new Thread(new Timeout(this.timeout));
        t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (e instanceof QuitException) {
                    Utils.println(((QuitException)e).status + ": " + ((QuitException)e).message);
                    System.exit(Utils.getStatusCode("UNKNOWN"));
                } else if (e.getMessage() != null) {
                    Utils.println(e.getMessage());
                    System.exit(Utils.getStatusCode("UNKNOWN"));
                }
            }
        });
        t.start();
        try {
            Utils.log.trace("running CLI.processArgs()");
            this.processArgs();
            Utils.log.trace("running CLI.run()");
            this.run();
            Utils.log.trace("running CLI.end()");
            this.end();
            Utils.log.trace("stopping timeout thread");
            t.stop();
        }
        catch (IllegalArgumentException e) {
            Utils.log.trace("caught exception in CLI.main2()");
            if (Utils.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            this.usage(e.getMessage());
        }
    }

    public void run() {
    }

    public void end() {
    }

    public final void usage(String msg, String status) {
        int terminalWidth;
        String msg2 = "";
        if (msg != null) {
            msg2 = msg + "\n";
        }
        if (status == null) {
            status = "UNKNOWN";
        }
        if ((terminalWidth = TerminalFactory.get().getWidth()) < 80) {
            terminalWidth = 80;
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(terminalWidth, msg2 + "\n\n" + this.usage_header + "\n", this.usage_msg + "\n\n", this.options, "");
        System.exit(Utils.getStatusCode(status));
    }

    public final void usage(String msg) {
        this.usage(msg, null);
    }

    public final void usage(Exception e) {
        this.usage(e.getMessage(), null);
    }

    public final void usage() {
        this.usage(null, null);
    }

    public void noArgs() {
        if (this.cmd.getArgList().size() > 0) {
            this.usage("invalid non-switch arguments supplied on command line");
        }
    }

    public void addOptions() {
    }

    public int getVerbose() {
        return this.verbose;
    }

    public void setVerbose(int v) {
        this.verbose = v;
    }

    public int getVerboseDefault() {
        return this.verbose_default;
    }

    public void setVerboseDefault(int v) {
        this.verbose_default = v;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int secs) {
        Utils.validateInt(secs, "timeout", 0, this.timeout_max);
        this.timeout = secs;
    }

    public int getTimeoutDefault() {
        return this.timeout_default;
    }

    public void setTimeoutDefault(int secs) {
        if (secs > this.timeout_max) {
            throw new IllegalArgumentException("set default timeout > timeout max");
        }
        this.timeout_default = secs;
    }

    public int getTimeoutMax() {
        return this.timeout_max;
    }

    public void setTimeoutMax(int secs) {
        this.timeout_max = secs;
    }

    public String getOpt(String opt2) {
        if (this.cmd.hasOption(opt2)) {
            return this.cmd.getOptionValue(opt2);
        }
        return null;
    }

    public void timeoutHandler(Exception e) {
        Utils.quit("UNKNOWN", String.format("self timeout out after %s second%s", this.timeout, Utils.plural(this.timeout)));
    }

    private void parseArgs2(String[] args) {
        Utils.log.trace("parseArgs2()");
        GnuParser parser = new GnuParser();
        try {
            this.cmd = parser.parse(this.options, args);
            if (this.cmd.hasOption("h")) {
                this.usage();
            }
            if (this.cmd.hasOption("D")) {
                this.debug = true;
            }
            if (this.cmd.hasOption("v")) {
                ++this.verbose;
            }
            this.timeout = this.timeout_default;
            if (this.cmd.hasOption("t")) {
                this.timeout = Integer.valueOf(this.cmd.getOptionValue("t", String.valueOf(this.timeout)));
            }
        }
        catch (ParseException e) {
            if (this.debug) {
                e.printStackTrace();
            }
            Utils.log.error(e + "\n");
            this.usage();
        }
        String env_verbose = System.getenv("VERBOSE");
        if (env_verbose != null && !env_verbose.trim().isEmpty()) {
            try {
                int v = Integer.valueOf(env_verbose.trim());
                if (v > this.verbose) {
                    Utils.log.trace(String.format("environment variable $VERBOSE = %d, increasing verbosity to %d", v, v));
                    this.verbose = v;
                }
            }
            catch (NumberFormatException e) {
                Utils.log.warn(String.format("$VERBOSE environment variable is not an integer ('%s')", env_verbose));
            }
        }
        this.parseArgs();
    }

    public void parseArgs() {
    }

    public void processArgs() {
    }
}

