/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.application;

import com.google.common.base.Strings;
import de.justsoftware.authentication.configuration.JwtKeyConfiguration;
import de.justsoftware.authentication.configuration.MetadataConfiguration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.RedisHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
@ParametersAreNonnullByDefault
public class HealthConfiguration {
    @Nonnull
    private static final Boolean isPresent(@Nullable String value) {
        return !Strings.isNullOrEmpty((String)value);
    }

    @Nonnull
    private static final Boolean isPresent(@Nullable byte[] value) {
        return value != null && value.length > 0;
    }

    @Nonnull
    @Bean(value={"redisHealthIndicator"})
    public HealthIndicator redisHealthIndicator(@Qualifier(value="redisTomcatSessionClient") RedisConnectionFactory connectionFactory) {
        return new RedisHealthIndicator(connectionFactory);
    }

    @Nonnull
    @Bean(value={"configurationHealthIndicator"})
    public HealthIndicator configurationHealthIndicator(JwtKeyConfiguration jwtKeyConfiguration, MetadataConfiguration metadataConfiguration) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Nonnull
    @Bean(value={"javaHealthIndicator"})
    public HealthIndicator javaHealthIndicator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

