/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.persistence;

import de.justsoftware.people.persistence.model.DbProfile;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H&J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH'J\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0001\u0010\u000b\u001a\u00020\fH'J\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u000fH'\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/people/persistence/ProfileRepository;", "Lorg/springframework/data/jpa/repository/JpaRepository;", "Lde/justsoftware/people/persistence/model/DbProfile;", "", "findAllByDeletedIsFalseAndIdIn", "", "profileIds", "", "findAllIdsByDeletedIsFalse", "Ljava/util/stream/Stream;", "findAllIdsByDeletedIsFalseAndTenantId", "tenantId", "Ljava/util/UUID;", "findProfilesByBirthday", "month", "", "dayOfMonth", "people-api"})
public interface ProfileRepository
extends JpaRepository<DbProfile, Long> {
    @NotNull
    public List<DbProfile> findAllByDeletedIsFalseAndIdIn(@NotNull Iterable<Long> var1);

    @Query(value="SELECT p.id FROM DbProfile p")
    @NotNull
    public Stream<Long> findAllIdsByDeletedIsFalse();

    @Query(value="SELECT p.id FROM DbProfile p WHERE p.tenantId = :tenantId")
    @NotNull
    public Stream<Long> findAllIdsByDeletedIsFalseAndTenantId(@Param(value="tenantId") @NotNull UUID var1);

    @Query(value="\n        SELECT p \n        FROM DbProfile p\n        RIGHT JOIN DbConfig c ON\n            c.tenantId = p.tenantId\n        WHERE\n            c.isBirthdayListEnabled = TRUE\n            AND p.active = TRUE\n            AND p.deleted = FALSE\n            AND p.birthdayVisibility != 'NONE'\n            AND EXTRACT(MONTH FROM p.birthday) = :month\n            AND EXTRACT(DAY FROM p.birthday) = :dayOfMonth\n        ")
    @NotNull
    public List<DbProfile> findProfilesByBirthday(@Param(value="month") int var1, @Param(value="dayOfMonth") int var2);
}

