/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config;

import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.config.SwaggerConfig;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.security.OAuthFlow;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springdoc.core.SpringDocUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@SecurityScheme(type=SecuritySchemeType.OAUTH2, name="oauth2", flows=@OAuthFlows(authorizationCode=@OAuthFlow(authorizationUrl="/toro/oauth/authorize", tokenUrl="/toro/oauth/token", scopes={@OAuthScope(name="api", description="Access to all your data.")})))
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017\u00a8\u0006\u0006"}, d2={"Lde/justsoftware/people/config/SwaggerConfig;", "", "()V", "chatAPIDocumentation", "Lio/swagger/v3/oas/models/OpenAPI;", "Companion", "people-api"})
public class SwaggerConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Bean
    @NotNull
    public OpenAPI chatAPIDocumentation() {
        OpenAPI openAPI = new OpenAPI().security(CollectionsKt.listOf((Object)new SecurityRequirement().addList("oauth2"))).info(new Info().title("Just People - Public REST API"));
        Intrinsics.checkNotNullExpressionValue((Object)openAPI, (String)"info(...)");
        return openAPI;
    }

    static {
        Class[] classArray = new Class[]{AuthorizationContext.class};
        SpringDocUtils.getConfig().addRequestWrapperToIgnore(classArray);
    }
}

