/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.search.solr;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.people.business.profile.ProfileAttributeConfigService;
import de.justsoftware.people.business.search.model.FacetFilter;
import de.justsoftware.people.business.search.model.SearchFilter;
import de.justsoftware.people.business.search.model.SearchId;
import de.justsoftware.people.business.search.solr.ProfileDynamicAttributeIndexer;
import de.justsoftware.people.business.search.solr.SolrIntegration;
import de.justsoftware.people.business.search.solr.SolrQueryHelper;
import de.justsoftware.people.business.search.solr.model.ProfileSearchIndexModel;
import de.justsoftware.people.business.search.solr.model.ProfileSearchReadModel;
import de.justsoftware.people.business.search.solr.model.SearchIndexModel;
import de.justsoftware.people.business.search.solr.model.SearchModel;
import de.justsoftware.people.business.search.solr.model.UserGroupSearchIndexModel;
import de.justsoftware.people.business.search.solr.model.UserGroupSearchModel;
import de.justsoftware.people.exceptions.RepositoryException;
import de.justsoftware.people.model.PagedResult;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.model.UserGroupId;
import de.justsoftware.permission.client.model.Role;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 :2\u00020\u0001:\u0001:B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J`\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J>\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J>\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J<\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0016\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0012H\u0016J\b\u0010'\u001a\u00020$H\u0016J \u0010(\u001a\u0004\u0018\u00010\t2\u0006\u0010)\u001a\u00020*2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020*0\u0012H\u0016J\u0016\u0010-\u001a\u00020$2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0016JJ\u00101\u001a\b\u0012\u0004\u0012\u00020\u001c0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u00102\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0016\u00103\u001a\u00020$2\f\u00104\u001a\b\u0012\u0004\u0012\u0002050\u000fH\u0012J\u0016\u00106\u001a\u00020$2\f\u00104\u001a\b\u0012\u0004\u0012\u0002050\u000fH\u0012J\f\u00107\u001a\u000205*\u000208H\u0012J\f\u00107\u001a\u000205*\u000200H\u0012J\f\u00107\u001a\u000205*\u000209H\u0012J\u0018\u00107\u001a\b\u0012\u0004\u0012\u0002050\u000f*\b\u0012\u0004\u0012\u0002000/H\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lde/justsoftware/people/business/search/solr/SolrIntegration;", "", "solrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "profileAttributeConfigService", "Lde/justsoftware/people/business/profile/ProfileAttributeConfigService;", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/people/business/profile/ProfileAttributeConfigService;)V", "allProfiles", "Lde/justsoftware/people/model/PagedResult;", "Lde/justsoftware/people/business/search/solr/model/ProfileSearchReadModel;", "tenantId", "Lde/justsoftware/people/model/TenantId;", "searchString", "", "searchFilter", "", "Lde/justsoftware/people/business/search/model/SearchFilter;", "searchRoles", "", "Lde/justsoftware/permission/client/model/Role;", "facetFilter", "Lde/justsoftware/people/business/search/model/FacetFilter;", "groupId", "Lde/justsoftware/people/model/UserGroupId;", "offset", "", "limit", "allProfilesAndUserGroups", "Lde/justsoftware/people/business/search/solr/model/SearchModel;", "allUserGroups", "Lde/justsoftware/people/business/search/solr/model/UserGroupSearchModel;", "nameFilter", "birthdayList", "currentDate", "Ljava/time/LocalDate;", "delete", "", "searchIds", "Lde/justsoftware/people/business/search/model/SearchId;", "deleteAllUserGroups", "findProfile", "profileId", "Lde/justsoftware/people/model/ProfileId;", "getProfiles", "profilesIds", "index", "searchIndexModels", "", "Lde/justsoftware/people/business/search/solr/model/SearchIndexModel;", "searchInNames", "types", "sendToSolr", "documents", "Lorg/apache/solr/common/SolrInputDocument;", "sendToSolrSingly", "toSolrInputDocument", "Lde/justsoftware/people/business/search/solr/model/ProfileSearchIndexModel;", "Lde/justsoftware/people/business/search/solr/model/UserGroupSearchIndexModel;", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nSolrIntegration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolrIntegration.kt\nde/justsoftware/people/business/search/solr/SolrIntegration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,630:1\n1549#2:631\n1620#2,3:632\n1549#2:635\n1620#2,3:636\n1603#2,9:639\n1855#2:648\n1856#2:650\n1612#2:651\n1603#2,9:652\n1855#2:661\n1856#2:663\n1612#2:664\n1549#2:665\n1620#2,3:666\n1549#2:669\n1620#2,3:670\n1549#2:673\n1620#2,3:674\n1549#2:677\n1620#2,3:678\n1855#2,2:681\n1549#2:683\n1620#2,3:684\n1549#2:687\n1620#2,3:688\n1#3:649\n1#3:662\n215#4,2:691\n*S KotlinDebug\n*F\n+ 1 SolrIntegration.kt\nde/justsoftware/people/business/search/solr/SolrIntegration\n*L\n131#1:631\n131#1:632,3\n171#1:635\n171#1:636,3\n218#1:639,9\n218#1:648\n218#1:650\n218#1:651\n259#1:652,9\n259#1:661\n259#1:663\n259#1:664\n303#1:665\n303#1:666,3\n322#1:669\n322#1:670,3\n345#1:673\n345#1:674,3\n368#1:677\n368#1:678,3\n408#1:681,2\n426#1:683\n426#1:684,3\n458#1:687\n458#1:688,3\n218#1:649\n259#1:662\n464#1:691,2\n*E\n"})
public class SolrIntegration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SolrClient solrClient;
    @NotNull
    private final ProfileAttributeConfigService profileAttributeConfigService;
    private static final Logger LOG = LoggerFactory.getLogger(SolrIntegration.class);
    public static final int DEFAULT_FACET_LIMIT = 100;
    @NotNull
    private static final String DEFAULT_QUERY = "*:*";
    @NotNull
    private static final String QUERY_FOR_TYPE = "type:";
    @NotNull
    private static final String OR = "OR";

    public SolrIntegration(@NotNull SolrClient solrClient, @NotNull ProfileAttributeConfigService profileAttributeConfigService) {
        Intrinsics.checkNotNullParameter((Object)solrClient, (String)"solrClient");
        Intrinsics.checkNotNullParameter((Object)profileAttributeConfigService, (String)"profileAttributeConfigService");
        this.solrClient = solrClient;
        this.profileAttributeConfigService = profileAttributeConfigService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PagedResult<ProfileSearchReadModel> allProfiles(@Nullable TenantId tenantId, @NotNull String searchString, @NotNull List<? extends SearchFilter> searchFilter, @NotNull Set<Role> searchRoles, @Nullable FacetFilter facetFilter, @Nullable UserGroupId groupId, int offset, int limit) {
        PagedResult pagedResult;
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter(searchFilter, (String)"searchFilter");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            SolrQuery query = Companion.access$createSolrQuery((Companion)Companion, (String)searchString, (int)offset, (int)limit, null);
            String[] stringArray = new String[]{"type:PROFILE"};
            query.addFilterQuery(stringArray);
            List facetableFields = this.profileAttributeConfigService.facetableFields();
            searchFilter.forEach(arg_0 -> SolrIntegration.allProfiles$lambda$0(query, arg_0));
            Companion.access$addFacetFields((Companion)Companion, (SolrQuery)query, (List)facetableFields, (ProfileAttributeConfigService)this.profileAttributeConfigService);
            if (facetFilter != null) {
                String string = facetFilter.getSearchField().getId();
                String string2 = facetFilter.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                SolrQueryHelper.INSTANCE.setFacetContains(query, string, string2);
            }
            UserGroupId userGroupId = groupId;
            if (userGroupId != null) {
                UserGroupId it = userGroupId;
                boolean bl = false;
                object = new String[]{"userGroupIds:" + it};
                query.addFilterQuery(object);
            }
            Companion.access$addTenantIdFilter((Companion)Companion, (SolrQuery)query, (TenantId)tenantId);
            Companion.access$addVisibleForRolesFilter((Companion)Companion, (SolrQuery)query, searchRoles);
            QueryResponse response = this.solrClient.query((SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList results = response.getResults();
            Intrinsics.checkNotNull((Object)results);
            object = (Iterable)results;
            Companion companion = Companion;
            boolean $i$f$map = false;
            void var17_20 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                SolrDocument solrDocument = (SolrDocument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.access$profileFromDocument((Companion)companion, (SolrDocument)p0));
            }
            List profiles = (List)destination$iv$iv;
            long l = results.getStart();
            long l2 = results.getNumFound();
            Intrinsics.checkNotNull((Object)response);
            pagedResult = new PagedResult(l, l2, profiles, Companion.access$extractFacetResults((Companion)Companion, (QueryResponse)response, (List)facetableFields));
        }
        catch (IOException e) {
            throw new RepositoryException("Could not load profiles from Solr", (Throwable)e);
        }
        catch (SolrServerException e) {
            throw new RepositoryException("Could not load profiles from Solr", (Throwable)e);
        }
        return pagedResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PagedResult<ProfileSearchReadModel> birthdayList(@NotNull TenantId tenantId, @NotNull LocalDate currentDate, @NotNull Set<Role> searchRoles, int offset, int limit) {
        PagedResult pagedResult;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            SolrQuery query = new SolrQuery("*:*");
            query.setStart(Integer.valueOf(offset)).setRows(Integer.valueOf(limit));
            query.addSort("lt(add(product(birthMonth, 100), birthDay), " + (currentDate.getMonthValue() * 100 + currentDate.getDayOfMonth()) + ")", SolrQuery.ORDER.asc);
            query.addSort("birthMonth", SolrQuery.ORDER.asc);
            query.addSort("birthDay", SolrQuery.ORDER.asc);
            query.addSort("firstName", SolrQuery.ORDER.asc);
            query.addSort("lastName", SolrQuery.ORDER.asc);
            query.addSort("id", SolrQuery.ORDER.asc);
            String[] stringArray = new String[]{"type:PROFILE"};
            query.addFilterQuery(stringArray);
            stringArray = new String[]{"birthDay:[* TO *]"};
            query.addFilterQuery(stringArray);
            stringArray = new String[]{"birthMonth:[* TO *]"};
            query.addFilterQuery(stringArray);
            Companion.access$addTenantIdFilter((Companion)Companion, (SolrQuery)query, (TenantId)tenantId);
            Companion.access$addVisibleForRolesFilter((Companion)Companion, (SolrQuery)query, searchRoles);
            QueryResponse response = this.solrClient.query((SolrParams)query, SolrRequest.METHOD.POST);
            SolrDocumentList results = response.getResults();
            Intrinsics.checkNotNull((Object)results);
            Iterable iterable = (Iterable)results;
            Companion companion = Companion;
            boolean $i$f$map = false;
            void var13_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                SolrDocument solrDocument = (SolrDocument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.access$profileFromDocument((Companion)companion, (SolrDocument)p0));
            }
            List profiles = (List)destination$iv$iv;
            pagedResult = new PagedResult(results.getStart(), results.getNumFound(), profiles);
        }
        catch (IOException e) {
            throw new RepositoryException("Could not load birthday list from Solr", (Throwable)e);
        }
        catch (SolrServerException e) {
            throw new RepositoryException("Could not load birthday list from Solr", (Throwable)e);
        }
        return pagedResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PagedResult<SearchModel> allProfilesAndUserGroups(@Nullable TenantId tenantId, @NotNull String searchString, @NotNull Set<Role> searchRoles, int offset, int limit) {
        PagedResult pagedResult;
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        try {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            if (searchRoles.isEmpty()) {
                return new PagedResult((long)offset, 0L, CollectionsKt.emptyList());
            }
            SolrQuery solrQuery = Companion.access$createSolrQuery((Companion)Companion, (String)searchString, (int)offset, (int)limit, null);
            Companion.access$addTenantIdFilter((Companion)Companion, (SolrQuery)solrQuery, (TenantId)tenantId);
            Companion.access$addVisibleForRolesFilter((Companion)Companion, (SolrQuery)solrQuery, searchRoles);
            QueryResponse response = this.solrClient.query((SolrParams)solrQuery);
            SolrDocumentList results = response.getResults();
            Intrinsics.checkNotNull((Object)results);
            Iterable iterable = (Iterable)results;
            Companion companion = Companion;
            boolean $i$f$mapNotNull = false;
            void var13_14 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SearchModel it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                SolrDocument p0 = (SolrDocument)element$iv$iv;
                boolean bl2 = false;
                if (Companion.access$searchModelFromDocument((Companion)companion, (SolrDocument)p0) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List profilesAndUserGroups = (List)destination$iv$iv;
            pagedResult = new PagedResult(results.getStart(), results.getNumFound(), profilesAndUserGroups);
        }
        catch (IOException e) {
            throw new RepositoryException("Could not load profiles and user groups from Solr", (Throwable)e);
        }
        catch (SolrServerException e) {
            throw new RepositoryException("Could not load profiles and user groups from Solr", (Throwable)e);
        }
        return pagedResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PagedResult<SearchModel> searchInNames(@NotNull TenantId tenantId, @NotNull String searchString, @NotNull Set<Role> searchRoles, @NotNull Set<String> types, int offset, int limit) {
        PagedResult pagedResult;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        try {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            if (searchRoles.isEmpty()) {
                return new PagedResult((long)offset, 0L, CollectionsKt.emptyList());
            }
            String queryFields = SolrQueryHelper.INSTANCE.queryFieldWithBoost("name", 2.0f) + " namePhonetic";
            SolrQuery solrQuery = Companion.access$createSolrQuery((Companion)Companion, (String)searchString, (int)offset, (int)limit, (String)queryFields);
            Companion.access$addTypesFilter((Companion)Companion, (SolrQuery)solrQuery, types);
            Companion.access$addTenantIdFilter((Companion)Companion, (SolrQuery)solrQuery, (TenantId)tenantId);
            Companion.access$addVisibleForRolesFilter((Companion)Companion, (SolrQuery)solrQuery, searchRoles);
            Companion.access$addExcludeAllTenantUsersGroupFilter((Companion)Companion, (SolrQuery)solrQuery);
            QueryResponse response = this.solrClient.query((SolrParams)solrQuery);
            SolrDocumentList results = response.getResults();
            Intrinsics.checkNotNull((Object)results);
            Iterable iterable = (Iterable)results;
            Companion companion = Companion;
            boolean $i$f$mapNotNull = false;
            void var15_16 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SearchModel it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                SolrDocument p0 = (SolrDocument)element$iv$iv;
                boolean bl2 = false;
                if (Companion.access$searchModelFromDocument((Companion)companion, (SolrDocument)p0) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List profilesAndUserGroups = (List)destination$iv$iv;
            pagedResult = new PagedResult(results.getStart(), results.getNumFound(), profilesAndUserGroups);
        }
        catch (IOException e) {
            throw new RepositoryException("Could not load profiles and user groups from Solr", (Throwable)e);
        }
        catch (SolrServerException e) {
            throw new RepositoryException("Could not load profiles and user groups from Solr", (Throwable)e);
        }
        return pagedResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PagedResult<UserGroupSearchModel> allUserGroups(@Nullable TenantId tenantId, @NotNull String nameFilter, @NotNull Set<Role> searchRoles, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)nameFilter, (String)"nameFilter");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        if (searchRoles.isEmpty()) {
            long l = offset;
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
            return new PagedResult(l, 0L, (List)immutableList);
        }
        SolrQuery solrQuery = Companion.access$createSolrQuery((Companion)Companion, (String)nameFilter, (int)offset, (int)limit, null);
        String[] stringArray = new String[]{"type:USER_GROUP"};
        solrQuery.addFilterQuery(stringArray);
        Companion.access$addTenantIdFilter((Companion)Companion, (SolrQuery)solrQuery, (TenantId)tenantId);
        Companion.access$addVisibleForRolesFilter((Companion)Companion, (SolrQuery)solrQuery, searchRoles);
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            QueryResponse response = this.solrClient.query((SolrParams)solrQuery);
            SolrDocumentList results = response.getResults();
            Intrinsics.checkNotNull((Object)results);
            Iterable iterable = (Iterable)results;
            Companion companion = Companion;
            boolean $i$f$map = false;
            void var13_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                SolrDocument solrDocument = (SolrDocument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.access$userGroupFromDocument((Companion)companion, (SolrDocument)p0));
            }
            List userGroups = (List)destination$iv$iv;
            long l = results.getStart();
            long l2 = results.getNumFound();
            ImmutableList immutableList = ImmutableList.copyOf((Collection)userGroups);
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            stringArray = new PagedResult(l, l2, (List)immutableList);
        }
        catch (IOException e) {
            throw new RepositoryException("Could not load user groups from Solr", (Throwable)e);
        }
        catch (SolrServerException e) {
            throw new RepositoryException("Could not load user groups from Solr", (Throwable)e);
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProfileSearchReadModel findProfile(@NotNull ProfileId profileId, @NotNull Set<Role> searchRoles) {
        ProfileSearchReadModel profileSearchReadModel;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            SolrQuery query = new SolrQuery("id:" + profileId.asString());
            Companion.access$addVisibleForRolesFilter((Companion)Companion, (SolrQuery)query, searchRoles);
            QueryResponse response = this.solrClient.query((SolrParams)query);
            SolrDocumentList solrDocumentList = response.getResults();
            Intrinsics.checkNotNullExpressionValue((Object)solrDocumentList, (String)"getResults(...)");
            Iterable iterable = (Iterable)solrDocumentList;
            Companion companion = Companion;
            boolean $i$f$map = false;
            void var8_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                SolrDocument solrDocument = (SolrDocument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.access$profileFromDocument((Companion)companion, (SolrDocument)p0));
            }
            profileSearchReadModel = (ProfileSearchReadModel)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        }
        catch (IOException e) {
            throw new RepositoryException("Could not load profile from Solr", (Throwable)e);
        }
        catch (SolrServerException e) {
            throw new RepositoryException("Could not load profile from Solr", (Throwable)e);
        }
        return profileSearchReadModel;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PagedResult<ProfileSearchReadModel> getProfiles(@NotNull Set<ProfileId> profilesIds) {
        PagedResult pagedResult;
        Intrinsics.checkNotNullParameter(profilesIds, (String)"profilesIds");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (profilesIds.isEmpty()) {
                ImmutableList immutableList = ImmutableList.of();
                Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
                return new PagedResult(0L, 0L, (List)immutableList);
            }
            SolrQuery query = new SolrQuery("*:*");
            String[] stringArray = new String[]{"id:(" + Joiner.on((String)" OR ").join((Iterable)profilesIds) + ")"};
            query.addFilterQuery(stringArray);
            query.setRows(Integer.valueOf(profilesIds.size()));
            query.setSort("name_sort", SolrQuery.ORDER.asc);
            QueryResponse response = this.solrClient.query((SolrParams)query);
            SolrDocumentList results = response.getResults();
            Intrinsics.checkNotNull((Object)results);
            Iterable iterable = (Iterable)results;
            Companion companion = Companion;
            boolean $i$f$map = false;
            void var9_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                SolrDocument solrDocument = (SolrDocument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.access$profileFromDocument((Companion)companion, (SolrDocument)p0));
            }
            List profiles = (List)destination$iv$iv;
            long l = results.getStart();
            long l2 = results.getNumFound();
            ImmutableList immutableList = ImmutableList.copyOf((Collection)profiles);
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            pagedResult = new PagedResult(l, l2, (List)immutableList);
        }
        catch (IOException e) {
            throw new RepositoryException("Could not load profiles from Solr", (Throwable)e);
        }
        catch (SolrServerException e) {
            throw new RepositoryException("Could not load profiles from Solr", (Throwable)e);
        }
        return pagedResult;
    }

    public void index(@NotNull Iterable<? extends SearchIndexModel> searchIndexModels) {
        Intrinsics.checkNotNullParameter(searchIndexModels, (String)"searchIndexModels");
        this.sendToSolr(this.toSolrInputDocument(searchIndexModels));
    }

    /*
     * WARNING - void declaration
     */
    public void delete(@NotNull Set<? extends SearchId> searchIds) {
        Intrinsics.checkNotNullParameter(searchIds, (String)"searchIds");
        if (searchIds.isEmpty()) {
            return;
        }
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = searchIds;
            SolrClient solrClient = this.solrClient;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                SearchId searchId = (SearchId)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.toCanonicalId());
            }
            solrClient.deleteById((List)destination$iv$iv);
        }
        catch (IOException e) {
            throw new RepositoryException("Could not delete documents from Solr", (Throwable)e);
        }
        catch (SolrServerException e) {
            throw new RepositoryException("Could not delete documents from Solr", (Throwable)e);
        }
        Companion.access$commitIgnoreErrors((Companion)Companion, (SolrClient)this.solrClient);
    }

    public void deleteAllUserGroups() {
        try {
            this.solrClient.deleteByQuery("type:USER_GROUP");
        }
        catch (IOException e) {
            throw new RepositoryException("Could not delete user groups", (Throwable)e);
        }
        catch (SolrServerException e) {
            throw new RepositoryException("Could not delete user groups", (Throwable)e);
        }
        Companion.access$commitIgnoreErrors((Companion)Companion, (SolrClient)this.solrClient);
    }

    private void sendToSolr(List<? extends SolrInputDocument> documents) throws IOException {
        if (documents.isEmpty()) {
            return;
        }
        try {
            this.solrClient.add((Collection)documents);
        }
        catch (SolrServerException collectionTry) {
            this.sendToSolrSingly(documents);
        }
        catch (SolrException collectionTry) {
            this.sendToSolrSingly(documents);
        }
        Companion.access$commitIgnoreErrors((Companion)Companion, (SolrClient)this.solrClient);
    }

    private void sendToSolrSingly(List<? extends SolrInputDocument> documents) throws IOException {
        Iterable $this$forEach$iv = documents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SolrInputDocument document = (SolrInputDocument)element$iv;
            boolean bl = false;
            try {
                this.solrClient.add(document);
            }
            catch (SolrServerException singleTry) {
                LOG.warn("Failed to update solr document " + document.get((Object)"id") + " in Solr", (Throwable)singleTry);
            }
            catch (SolrException singleTry) {
                LOG.warn("Failed to update solr document " + document.get((Object)"id") + " in Solr", (Throwable)singleTry);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<SolrInputDocument> toSolrInputDocument(Iterable<? extends SearchIndexModel> $this$toSolrInputDocument) {
        void $this$mapTo$iv$iv;
        Iterable<? extends SearchIndexModel> $this$map$iv = $this$toSolrInputDocument;
        boolean $i$f$map = false;
        Iterable<? extends SearchIndexModel> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SearchIndexModel searchIndexModel = (SearchIndexModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toSolrInputDocument((SearchIndexModel)it));
        }
        return (List)destination$iv$iv;
    }

    private SolrInputDocument toSolrInputDocument(SearchIndexModel $this$toSolrInputDocument) {
        SolrInputDocument solrInputDocument;
        SearchIndexModel searchIndexModel = $this$toSolrInputDocument;
        if (searchIndexModel instanceof ProfileSearchIndexModel) {
            solrInputDocument = this.toSolrInputDocument((ProfileSearchIndexModel)$this$toSolrInputDocument);
        } else if (searchIndexModel instanceof UserGroupSearchIndexModel) {
            solrInputDocument = this.toSolrInputDocument((UserGroupSearchIndexModel)$this$toSolrInputDocument);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return solrInputDocument;
    }

    private SolrInputDocument toSolrInputDocument(UserGroupSearchIndexModel $this$toSolrInputDocument) {
        SolrInputDocument solrInputDocument;
        SolrInputDocument $this$toSolrInputDocument_u24lambda_u2411 = solrInputDocument = new SolrInputDocument();
        boolean bl = false;
        $this$toSolrInputDocument_u24lambda_u2411.setField("id", (Object)$this$toSolrInputDocument.getId().asString());
        $this$toSolrInputDocument_u24lambda_u2411.setField("userGroupName", (Object)$this$toSolrInputDocument.getName());
        $this$toSolrInputDocument_u24lambda_u2411.setField("type", (Object)"USER_GROUP");
        $this$toSolrInputDocument_u24lambda_u2411.setField("tenantIds", (Object)CollectionsKt.listOf((Object)$this$toSolrInputDocument.getTenantId().asString()));
        $this$toSolrInputDocument_u24lambda_u2411.setField("name_sort", (Object)$this$toSolrInputDocument.getName());
        $this$toSolrInputDocument_u24lambda_u2411.setField("visible_for_roles", (Object)$this$toSolrInputDocument.getVisibleForRoles());
        $this$toSolrInputDocument_u24lambda_u2411.setField("userGroupAllTenantUsers", (Object)$this$toSolrInputDocument.isAllTenantUsers());
        $this$toSolrInputDocument_u24lambda_u2411.setField("userGroupImported", (Object)$this$toSolrInputDocument.isImported());
        return solrInputDocument;
    }

    /*
     * WARNING - void declaration
     */
    private SolrInputDocument toSolrInputDocument(ProfileSearchIndexModel $this$toSolrInputDocument) {
        void $this$forEach$iv;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        Map $this$map$iv;
        SolrInputDocument solrInputDocument;
        SolrInputDocument $this$toSolrInputDocument_u24lambda_u2414 = solrInputDocument = new SolrInputDocument();
        boolean bl = false;
        ProfileDynamicAttributeIndexer dynamicAttributeIndexer = new ProfileDynamicAttributeIndexer(ImmutableMap.copyOf((Map)this.profileAttributeConfigService.getConfiguration()));
        $this$toSolrInputDocument_u24lambda_u2414.setField("id", (Object)$this$toSolrInputDocument.getId().toString());
        $this$toSolrInputDocument_u24lambda_u2414.setField("firstName", (Object)$this$toSolrInputDocument.getFirstName());
        $this$toSolrInputDocument_u24lambda_u2414.setField("lastName", (Object)$this$toSolrInputDocument.getLastName());
        $this$toSolrInputDocument_u24lambda_u2414.setField("title", (Object)$this$toSolrInputDocument.getTitle());
        $this$toSolrInputDocument_u24lambda_u2414.setField("additionalTitle", (Object)$this$toSolrInputDocument.getAdditionalTitle());
        $this$toSolrInputDocument_u24lambda_u2414.setField("profileHash", (Object)$this$toSolrInputDocument.getProfileHash());
        $this$toSolrInputDocument_u24lambda_u2414.setField("imageUrl", (Object)$this$toSolrInputDocument.getImageUrl());
        $this$toSolrInputDocument_u24lambda_u2414.setField("birthDay", (Object)$this$toSolrInputDocument.getBirthDay());
        $this$toSolrInputDocument_u24lambda_u2414.setField("birthMonth", (Object)$this$toSolrInputDocument.getBirthMonth());
        $this$toSolrInputDocument_u24lambda_u2414.setField("blocked", (Object)$this$toSolrInputDocument.getBlocked());
        $this$toSolrInputDocument_u24lambda_u2414.setField("active", (Object)$this$toSolrInputDocument.getActive());
        Iterable iterable = $this$toSolrInputDocument.getUserGroupIds();
        String string = "userGroupIds";
        SolrInputDocument solrInputDocument2 = $this$toSolrInputDocument_u24lambda_u2414;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void obj;
            UserGroupId userGroupId = (UserGroupId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(obj.toString());
        }
        collection = (List)destination$iv$iv;
        solrInputDocument2.setField(string, (Object)collection);
        $this$toSolrInputDocument_u24lambda_u2414.setField("type", (Object)"PROFILE");
        $this$toSolrInputDocument_u24lambda_u2414.setField("name_sort", (Object)($this$toSolrInputDocument.getLastName() + " " + $this$toSolrInputDocument.getFirstName()));
        $this$toSolrInputDocument_u24lambda_u2414.setField("tenantIds", (Object)($this$toSolrInputDocument.getTenantId() == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)$this$toSolrInputDocument.getTenantId().asString())));
        $this$toSolrInputDocument_u24lambda_u2414.setField("visible_for_roles", (Object)$this$toSolrInputDocument.getVisibleForRoles());
        ImmutableMap immutableMap = dynamicAttributeIndexer.convertForSolrIndex($this$toSolrInputDocument.getFields()).asMap();
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"asMap(...)");
        $this$map$iv = (Map)immutableMap;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl3 = false;
            String name = (String)entry.getKey();
            Collection value = (Collection)entry.getValue();
            $this$toSolrInputDocument_u24lambda_u2414.addField(name, (Object)value);
        }
        return solrInputDocument;
    }

    private static final void allProfiles$lambda$0(SolrQuery $query, SearchFilter filter) {
        Intrinsics.checkNotNullParameter((Object)$query, (String)"$query");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        String string = filter.getSearchField().getFilter();
        ImmutableList immutableList = filter.getValues();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getValues(...)");
        String[] stringArray = new String[]{filter.getSearchField().getTag()};
        SolrQueryHelper.INSTANCE.addFilterQuery($query, string, (Iterable)immutableList, stringArray);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }
}

