/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.util;

import de.justsoftware.notificationservice.model.MobilePushNotification;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.crypto.hpke.HPKE;
import org.bouncycastle.crypto.hpke.HPKEContextWithEncapsulation;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.util.encoders.Base64;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ResourceBundleMessageSource;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\"\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "encryptContent", "Lde/justsoftware/notificationservice/model/MobilePushNotification$EncryptedContent;", "title", "", "body", "publicKey", "profileId", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "encrypt", "Lde/justsoftware/notificationservice/model/MobilePushNotification;", "resourceBundle", "Lorg/springframework/context/support/ResourceBundleMessageSource;", "locale", "Ljava/util/Locale;", "notification-service"})
public final class MobilePushEncryptionKt {
    private static final Logger LOG = LoggerFactory.getLogger((String)"de.justsoftware.notificationservice.util.MobilePushEncryption");

    @NotNull
    public static final MobilePushNotification encrypt(@NotNull MobilePushNotification $this$encrypt, @NotNull String publicKey, @NotNull ResourceBundleMessageSource resourceBundle, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)$this$encrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)resourceBundle, (String)"resourceBundle");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        MobilePushNotification.EncryptedContent encryptedContent = MobilePushEncryptionKt.encryptContent((String)$this$encrypt.getTitle(), (String)$this$encrypt.getBody(), (String)publicKey, (ProfileId)$this$encrypt.getProfileId());
        String string = resourceBundle.getMessage("mobile.push.defaultTitle", null, locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        String string2 = resourceBundle.getMessage("mobile.push.defaultBody", null, locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMessage(...)");
        return MobilePushNotification.copy$default((MobilePushNotification)$this$encrypt, null, null, null, null, (String)string, (String)string2, (MobilePushNotification.EncryptedContent)encryptedContent, (int)0, (int)0, null, null, (int)1935, null);
    }

    private static final MobilePushNotification.EncryptedContent encryptContent(String title, String body, String publicKey, ProfileId profileId) {
        try {
            byte[] publicKeyRaw = Base64.decode((String)publicKey);
            X25519PublicKeyParameters publicKeyParam = new X25519PublicKeyParameters(publicKeyRaw);
            String string = profileId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] info = byArray;
            HPKE hpke = new HPKE(0, 32, 1, 3);
            HPKEContextWithEncapsulation context = hpke.setupBaseS((AsymmetricKeyParameter)publicKeyParam, info);
            byte[] byArray2 = new byte[]{};
            String string3 = title;
            byte[] byArray3 = string3.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
            byte[] titleEncrypted = context.seal(byArray2, byArray3);
            byte[] byArray4 = new byte[]{};
            String string4 = body;
            byte[] byArray5 = string4.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"getBytes(...)");
            byte[] bodyEncrypted = context.seal(byArray4, byArray5);
            String string5 = Base64.toBase64String((byte[])titleEncrypted);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toBase64String(...)");
            String string6 = Base64.toBase64String((byte[])bodyEncrypted);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toBase64String(...)");
            String string7 = Base64.toBase64String((byte[])context.getEncapsulation());
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toBase64String(...)");
            return new MobilePushNotification.EncryptedContent(string5, string6, string7);
        }
        catch (RuntimeException e) {
            LOG.error("Error encrypting mobile push message", (Throwable)e);
            return null;
        }
    }
}

