/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.writer;

import java.util.function.Consumer;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.writer.UnwritableMetadataException;
import org.apache.kafka.server.common.MetadataVersion;

public final class ImageWriterOptions {
    private final MetadataVersion metadataVersion;
    private final Consumer<UnwritableMetadataException> lossHandler;

    private ImageWriterOptions(MetadataVersion metadataVersion, Consumer<UnwritableMetadataException> lossHandler) {
        this.metadataVersion = metadataVersion;
        this.lossHandler = lossHandler;
    }

    public MetadataVersion metadataVersion() {
        return this.metadataVersion;
    }

    public void handleLoss(String loss) {
        this.lossHandler.accept(new UnwritableMetadataException(this.metadataVersion, loss));
    }

    public static class Builder {
        private MetadataVersion metadataVersion;
        private Consumer<UnwritableMetadataException> lossHandler = e -> {
            throw e;
        };

        public Builder() {
            this.metadataVersion = MetadataVersion.latest();
        }

        public Builder(MetadataImage image) {
            this.metadataVersion = image.features().metadataVersion();
        }

        public Builder setMetadataVersion(MetadataVersion metadataVersion) {
            if (metadataVersion.isLessThan(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION)) {
                this.setRawMetadataVersion(MetadataVersion.MINIMUM_KRAFT_VERSION);
            } else {
                this.setRawMetadataVersion(metadataVersion);
            }
            return this;
        }

        public Builder setRawMetadataVersion(MetadataVersion metadataVersion) {
            this.metadataVersion = metadataVersion;
            return this;
        }

        public MetadataVersion metadataVersion() {
            return this.metadataVersion;
        }

        public Builder setLossHandler(Consumer<UnwritableMetadataException> lossHandler) {
            this.lossHandler = lossHandler;
            return this;
        }

        public ImageWriterOptions build() {
            return new ImageWriterOptions(this.metadataVersion, this.lossHandler);
        }
    }
}

