/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.search.update;

import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleCreatedEvent;
import de.justsoftware.wikiservice.model.ArticleUpdatedEvent;
import de.justsoftware.wikiservice.model.ChapterModifiedEvent;
import de.justsoftware.wikiservice.model.WikiModifiedEvent;
import de.justsoftware.wikiservice.model.WikiPermissionModifiedEvent;
import de.justsoftware.wikiservice.search.update.UpdateSearchIndexProducer;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB+\b\u0007\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0017J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0017J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0013H\u0017J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0015H\u0017J\u0016\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0019H\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/justsoftware/wikiservice/search/update/UpdateSearchIndexProducer;", "", "kafkaProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "solrIndexQueue", "Lde/justsoftware/search/shared/SolrIndexQueue;", "(Lde/justsoftware/kafka/client/KafkaCleaningProducer;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/search/shared/SolrIndexQueue;)V", "handleArticleCreated", "", "evt", "Lde/justsoftware/wikiservice/model/ArticleCreatedEvent;", "handleArticleUpdated", "Lde/justsoftware/wikiservice/model/ArticleUpdatedEvent;", "handleChapterModified", "Lde/justsoftware/wikiservice/model/ChapterModifiedEvent;", "handleWikiModified", "Lde/justsoftware/wikiservice/model/WikiModifiedEvent;", "handleWikiPermissionModified", "Lde/justsoftware/wikiservice/model/WikiPermissionModifiedEvent;", "reindex", "ids", "", "Lde/justsoftware/wikiservice/model/AbstractId;", "send", "id", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nUpdateSearchIndexProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateSearchIndexProducer.kt\nde/justsoftware/wikiservice/search/update/UpdateSearchIndexProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1855#2,2:83\n1855#2,2:85\n*S KotlinDebug\n*F\n+ 1 UpdateSearchIndexProducer.kt\nde/justsoftware/wikiservice/search/update/UpdateSearchIndexProducer\n*L\n56#1:83,2\n63#1:85,2\n*E\n"})
public class UpdateSearchIndexProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KafkaCleaningProducer<String, String> kafkaProducer;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final SolrIndexQueue solrIndexQueue;
    @NotNull
    public static final String TOPIC = "just.wiki-service.search.updateIndex";

    @Autowired
    public UpdateSearchIndexProducer(@NotNull KafkaCleaningProducer<String, String> kafkaProducer, @NotNull AncestorService ancestorService, @NotNull SolrIndexQueue solrIndexQueue) {
        Intrinsics.checkNotNullParameter(kafkaProducer, (String)"kafkaProducer");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)solrIndexQueue, (String)"solrIndexQueue");
        this.kafkaProducer = kafkaProducer;
        this.ancestorService = ancestorService;
        this.solrIndexQueue = solrIndexQueue;
    }

    @Async
    @EventListener
    public void handleWikiModified(@NotNull WikiModifiedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send((AbstractId)evt.getId());
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)IdUtilsKt.toSearchableId((AbstractId)((AbstractId)evt.getId()))));
    }

    @Async
    @EventListener
    public void handleArticleCreated(@NotNull ArticleCreatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send((AbstractId)evt.getId());
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)IdUtilsKt.toSearchableId((AbstractId)((AbstractId)evt.getId()))));
    }

    @Async
    @EventListener
    public void handleArticleUpdated(@NotNull ArticleUpdatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send((AbstractId)evt.getId());
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)IdUtilsKt.toSearchableId((AbstractId)((AbstractId)evt.getId()))));
    }

    @Async
    @EventListener
    public void handleChapterModified(@NotNull ChapterModifiedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send((AbstractId)evt.getId());
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)IdUtilsKt.toSearchableId((AbstractId)((AbstractId)evt.getId()))));
    }

    @Async
    @EventListener
    public void handleWikiPermissionModified(@NotNull WikiPermissionModifiedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Iterable $this$forEach$iv = SetsKt.plus((Set)this.ancestorService.getDescendants(evt.getId()), (Object)evt.getId());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractId it = (AbstractId)element$iv;
            boolean bl = false;
            this.send(it);
        }
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)IdUtilsKt.toSearchableId((AbstractId)((AbstractId)evt.getId()))));
    }

    public void reindex(@NotNull Set<? extends AbstractId> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractId it = (AbstractId)element$iv;
            boolean bl = false;
            this.send(it);
        }
    }

    private void send(AbstractId id) {
        this.kafkaProducer.send(new ProducerRecord(TOPIC, (Object)id.toString(), (Object)id.toString()));
    }
}

