/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.search;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.model.ArticleDto;
import de.justsoftware.wikiservice.business.model.ChapterDto;
import de.justsoftware.wikiservice.business.model.WikiDto;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.SolrArticleExport;
import de.justsoftware.wikiservice.search.SolrService;
import de.justsoftware.wikiservice.search.update.UpdateSearchIndexProducer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.SolrParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 K2\u00020\u0001:\u0001KB[\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0001\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0001\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0012J\u0016\u0010,\u001a\u00020(2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020+0*H\u0012J\u001e\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0012J\u001e\u00104\u001a\u00020+2\u0006\u00105\u001a\u0002062\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0012J\u001e\u00107\u001a\u00020+2\u0006\u00108\u001a\u0002092\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0012J\u0016\u0010:\u001a\u00020(2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00180*H\u0012J\u0016\u0010<\u001a\u00020(2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00180*H\u0012J6\u0010=\u001a\b\u0012\u0004\u0012\u00020>0*2\u0006\u0010?\u001a\u00020@2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010B2\b\b\u0002\u0010C\u001a\u00020\u00132\b\b\u0002\u0010D\u001a\u00020\u0013H\u0016J\u0016\u0010E\u001a\u00020(2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020F0*H\u0016J\b\u0010G\u001a\u00020(H\u0016J\b\u0010H\u001a\u00020(H\u0016J\b\u0010I\u001a\u00020(H\u0016J\b\u0010J\u001a\u00020(H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0092D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0092D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u00020\u001b8\u0010X\u0091\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\n \"*\u0004\u0018\u00010!0!X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010#\u001a\u00020\u001b8\u0010X\u0091\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b$\u0010\u001d\u001a\u0004\b%\u0010\u001fR\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0018X\u0092D\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lde/justsoftware/wikiservice/search/SolrService;", "", "solrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "updateSearchIndexProducer", "Lde/justsoftware/wikiservice/search/update/UpdateSearchIndexProducer;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "useSoftCommit", "", "commitWithinInMs", "", "solrIndexQueue", "Lde/justsoftware/search/shared/SolrIndexQueue;", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/permission/client/rest/PermissionRequestConnector;Lde/justsoftware/wikiservice/search/update/UpdateSearchIndexProducer;Lio/micrometer/core/instrument/MeterRegistry;ZILde/justsoftware/search/shared/SolrIndexQueue;)V", "articleType", "", "chapterType", "failedIndexedDocumentCount", "Ljava/util/concurrent/atomic/AtomicLong;", "getFailedIndexedDocumentCount$wiki_service$annotations", "()V", "getFailedIndexedDocumentCount$wiki_service", "()Ljava/util/concurrent/atomic/AtomicLong;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "successfulIndexedDocumentCount", "getSuccessfulIndexedDocumentCount$wiki_service$annotations", "getSuccessfulIndexedDocumentCount$wiki_service", "wikiType", "addSolrDocuments", "", "inputDocuments", "", "Lorg/apache/solr/common/SolrInputDocument;", "addSolrDocumentsSingly", "solrDocuments", "createArticleSolrDocument", "article", "Lde/justsoftware/wikiservice/business/model/ArticleDto;", "visibleForRoles", "", "Lde/justsoftware/permission/client/model/Role;", "createChapterSolrDocument", "chapter", "Lde/justsoftware/wikiservice/business/model/ChapterDto;", "createWikiSolrDocument", "wiki", "Lde/justsoftware/wikiservice/business/model/WikiDto;", "deleteSolrDocuments", "ids", "deleteSolrDocumentsSingly", "exportArticles", "Lde/justsoftware/wikiservice/persistence/model/SolrArticleExport;", "userId", "Lde/justsoftware/wikiservice/model/ProfileId;", "modifiedAfter", "Ljava/time/Instant;", "offset", "limit", "index", "Lde/justsoftware/wikiservice/model/AbstractId;", "reindexAll", "reindexArticles", "reindexChapters", "reindexWikis", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nSolrService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolrService.kt\nde/justsoftware/wikiservice/search/SolrService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LoggerUtils.kt\nde/justsoftware/wikiservice/util/LoggerUtilsKt\n*L\n1#1,300:1\n1549#2:301\n1620#2,3:302\n1549#2:305\n1620#2,3:306\n1549#2:309\n1620#2,3:310\n1855#2,2:313\n1855#2,2:315\n800#2,11:317\n800#2,11:328\n800#2,11:339\n1549#2:350\n1620#2,3:351\n1549#2:354\n1620#2,3:355\n1549#2:358\n1620#2,3:359\n1549#2:362\n1620#2,3:363\n1549#2:366\n1620#2,3:367\n1549#2:370\n1620#2,3:371\n1549#2:374\n1620#2,3:375\n8#3:378\n7#3,3:379\n*S KotlinDebug\n*F\n+ 1 SolrService.kt\nde/justsoftware/wikiservice/search/SolrService\n*L\n146#1:301\n146#1:302,3\n159#1:305\n159#1:306,3\n174#1:309\n174#1:310,3\n202#1:313,2\n243#1:315,2\n261#1:317,11\n262#1:328,11\n263#1:339,11\n273#1:350\n273#1:351,3\n273#1:354\n273#1:355,3\n276#1:358\n276#1:359,3\n279#1:362\n279#1:363,3\n282#1:366\n282#1:367,3\n284#1:370\n284#1:371,3\n286#1:374\n286#1:375,3\n297#1:378\n297#1:379,3\n*E\n"})
public class SolrService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SolrClient solrClient;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;
    @NotNull
    private final UpdateSearchIndexProducer updateSearchIndexProducer;
    private final boolean useSoftCommit;
    private final int commitWithinInMs;
    @NotNull
    private final SolrIndexQueue solrIndexQueue;
    private final Logger logger;
    @NotNull
    private final String wikiType;
    @NotNull
    private final String chapterType;
    @NotNull
    private final String articleType;
    @NotNull
    private final AtomicLong successfulIndexedDocumentCount;
    @NotNull
    private final AtomicLong failedIndexedDocumentCount;
    @NotNull
    private static final Logger LOG;

    @Autowired
    public SolrService(@NotNull SolrClient solrClient, @NotNull WikiService wikiService, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull PermissionRequestConnector permissionRequestConnector, @NotNull UpdateSearchIndexProducer updateSearchIndexProducer, @NotNull MeterRegistry meterRegistry, @Value(value="${just.search.useSoftCommit:true}") boolean useSoftCommit, @Value(value="${just.search.commitWithinInMs:1000}") int commitWithinInMs, @NotNull SolrIndexQueue solrIndexQueue) {
        Intrinsics.checkNotNullParameter((Object)solrClient, (String)"solrClient");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        Intrinsics.checkNotNullParameter((Object)updateSearchIndexProducer, (String)"updateSearchIndexProducer");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        Intrinsics.checkNotNullParameter((Object)solrIndexQueue, (String)"solrIndexQueue");
        this.solrClient = solrClient;
        this.wikiService = wikiService;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.permissionRequestConnector = permissionRequestConnector;
        this.updateSearchIndexProducer = updateSearchIndexProducer;
        this.useSoftCommit = useSoftCommit;
        this.commitWithinInMs = commitWithinInMs;
        this.solrIndexQueue = solrIndexQueue;
        this.logger = LoggerFactory.getLogger(SolrService.class);
        this.wikiType = "WIKI_WIKI";
        this.chapterType = "WIKI_CHAPTER";
        this.articleType = "WIKI_ARTICLE";
        this.successfulIndexedDocumentCount = new AtomicLong(0L);
        this.failedIndexedDocumentCount = new AtomicLong(0L);
        Gauge.builder((String)"wiki.search.index.successfulIndexedDocuments", () -> SolrService._init_$lambda$0(this)).description("Count of successfully indexed documents").baseUnit("Document").register(meterRegistry);
        Gauge.builder((String)"wiki.search.index.failedIndexedDocuments", () -> SolrService._init_$lambda$1(this)).description("Count of failed indexed documents").baseUnit("Document").register(meterRegistry);
    }

    @NotNull
    public AtomicLong getSuccessfulIndexedDocumentCount$wiki_service() {
        return this.successfulIndexedDocumentCount;
    }

    @VisibleForTesting
    public static /* synthetic */ void getSuccessfulIndexedDocumentCount$wiki_service$annotations() {
    }

    @NotNull
    public AtomicLong getFailedIndexedDocumentCount$wiki_service() {
        return this.failedIndexedDocumentCount;
    }

    @VisibleForTesting
    public static /* synthetic */ void getFailedIndexedDocumentCount$wiki_service$annotations() {
    }

    public void reindexAll() {
        this.solrClient.deleteByQuery("just_app_id:WIKI");
        this.reindexWikis();
        this.reindexChapters();
        this.reindexArticles();
    }

    public void reindexWikis() {
        this.solrClient.deleteByQuery("type:" + this.wikiType);
        this.updateSearchIndexProducer.reindex(this.wikiService.readAllIds());
        SolrIndexQueue.reindex$default((SolrIndexQueue)this.solrIndexQueue, (Set)SetsKt.setOf((Object)SearchType.WIKI_WIKI), null, (int)2, null);
    }

    public void reindexChapters() {
        this.solrClient.deleteByQuery("type:" + this.chapterType);
        this.updateSearchIndexProducer.reindex(this.chapterService.readAllIds());
        SolrIndexQueue.reindex$default((SolrIndexQueue)this.solrIndexQueue, (Set)SetsKt.setOf((Object)SearchType.WIKI_CHAPTER), null, (int)2, null);
    }

    public void reindexArticles() {
        this.solrClient.deleteByQuery("type:" + this.articleType);
        this.updateSearchIndexProducer.reindex(this.articleService.readAllIds());
        SolrIndexQueue.reindex$default((SolrIndexQueue)this.solrIndexQueue, (Set)SetsKt.setOf((Object)SearchType.WIKI_ARTICLE), null, (int)2, null);
    }

    @NotNull
    public List<SolrArticleExport> exportArticles(@NotNull ProfileId userId, @Nullable Instant modifiedAfter, int offset, int limit) {
        QueryResponse queryResponse;
        SolrQuery solrQuery;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        SolrQuery $this$exportArticles_u24lambda_u242 = solrQuery = new SolrQuery();
        boolean bl = false;
        String[] stringArray = new String[]{"modify_date ASC"};
        $this$exportArticles_u24lambda_u242.add("sort", stringArray);
        stringArray = new String[]{String.valueOf(offset)};
        $this$exportArticles_u24lambda_u242.set("start", stringArray);
        stringArray = new String[]{String.valueOf(limit)};
        $this$exportArticles_u24lambda_u242.set("rows", stringArray);
        stringArray = new String[]{"id name modify_date content parent_ids"};
        $this$exportArticles_u24lambda_u242.set("fl", stringArray);
        stringArray = new String[]{"type:WIKI_ARTICLE"};
        $this$exportArticles_u24lambda_u242.addFilterQuery(stringArray);
        if (modifiedAfter != null) {
            stringArray = new String[]{"modify_date:{" + modifiedAfter + " TO *]"};
            $this$exportArticles_u24lambda_u242.addFilterQuery(stringArray);
        }
        ImmutableSet immutableSet = this.permissionRequestConnector.searchRoles(userId.toRole());
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"searchRoles(...)");
        String searchRoles = CollectionsKt.joinToString$default((Iterable)((Iterable)immutableSet), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        String[] stringArray2 = new String[]{searchRoles};
        $this$exportArticles_u24lambda_u242.add("justRoles", stringArray2);
        stringArray2 = new String[]{"{!edismax q.op=OR qf=visible_for_roles mm=1 v=$justRoles}"};
        $this$exportArticles_u24lambda_u242.addFilterQuery(stringArray2);
        $this$exportArticles_u24lambda_u242.setRequestHandler("jucoSearch");
        SolrQuery query = solrQuery;
        try {
            queryResponse = this.solrClient.query((SolrParams)query, SolrRequest.METHOD.POST);
        }
        catch (Exception e) {
            LOG.error("Error occurred while executing query " + query, (Throwable)e);
            throw e;
        }
        QueryResponse response = queryResponse;
        List list = response.getBeans(SolrArticleExport.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBeans(...)");
        return list;
    }

    public static /* synthetic */ List exportArticles$default(SolrService solrService, ProfileId profileId, Instant instant, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exportArticles");
        }
        if ((n3 & 2) != 0) {
            instant = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 1000;
        }
        return solrService.exportArticles(profileId, instant, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private SolrInputDocument createWikiSolrDocument(WikiDto wiki, Set<Role> visibleForRoles) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SolrInputDocument solrInputDocument;
        SolrInputDocument $this$createWikiSolrDocument_u24lambda_u244 = solrInputDocument = new SolrInputDocument();
        boolean bl = false;
        $this$createWikiSolrDocument_u24lambda_u244.setField("id", (Object)wiki.getId().toString());
        $this$createWikiSolrDocument_u24lambda_u244.setField("name", (Object)wiki.getTitle());
        $this$createWikiSolrDocument_u24lambda_u244.setField("name_sort", (Object)wiki.getTitle());
        $this$createWikiSolrDocument_u24lambda_u244.setField("description", (Object)wiki.getDescription());
        $this$createWikiSolrDocument_u24lambda_u244.setField("type", (Object)this.wikiType);
        $this$createWikiSolrDocument_u24lambda_u244.setField("modify_date", (Object)new Date(wiki.getUpdatedAt().toInstant().toEpochMilli()));
        $this$createWikiSolrDocument_u24lambda_u244.setField("publication_date", (Object)new Date(wiki.getCreatedAt().toInstant().toEpochMilli()));
        $this$createWikiSolrDocument_u24lambda_u244.setField("just_app_id", (Object)"WIKI");
        Iterable iterable = visibleForRoles;
        String string = "visible_for_roles";
        SolrInputDocument solrInputDocument2 = $this$createWikiSolrDocument_u24lambda_u244;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Role role = (Role)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toString());
        }
        collection = (List)destination$iv$iv;
        solrInputDocument2.setField(string, (Object)collection);
        return solrInputDocument;
    }

    /*
     * WARNING - void declaration
     */
    private SolrInputDocument createChapterSolrDocument(ChapterDto chapter, Set<Role> visibleForRoles) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SolrInputDocument solrInputDocument;
        SolrInputDocument $this$createChapterSolrDocument_u24lambda_u246 = solrInputDocument = new SolrInputDocument();
        boolean bl = false;
        $this$createChapterSolrDocument_u24lambda_u246.setField("id", (Object)chapter.getId().toString());
        $this$createChapterSolrDocument_u24lambda_u246.setField("name", (Object)chapter.getTitle());
        $this$createChapterSolrDocument_u24lambda_u246.setField("name_sort", (Object)chapter.getTitle());
        $this$createChapterSolrDocument_u24lambda_u246.setField("type", (Object)this.chapterType);
        $this$createChapterSolrDocument_u24lambda_u246.setField("modify_date", (Object)new Date(chapter.getUpdatedAt().toInstant().toEpochMilli()));
        $this$createChapterSolrDocument_u24lambda_u246.setField("publication_date", (Object)new Date(chapter.getCreatedAt().toInstant().toEpochMilli()));
        $this$createChapterSolrDocument_u24lambda_u246.setField("just_app_id", (Object)"WIKI");
        Iterable iterable = visibleForRoles;
        String string = "visible_for_roles";
        SolrInputDocument solrInputDocument2 = $this$createChapterSolrDocument_u24lambda_u246;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Role role = (Role)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toString());
        }
        collection = (List)destination$iv$iv;
        solrInputDocument2.setField(string, (Object)collection);
        $this$createChapterSolrDocument_u24lambda_u246.setField("parent_ids", (Object)CollectionsKt.listOf((Object)chapter.getWikiId().toString()));
        return solrInputDocument;
    }

    /*
     * WARNING - void declaration
     */
    private SolrInputDocument createArticleSolrDocument(ArticleDto article, Set<Role> visibleForRoles) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SolrInputDocument solrInputDocument;
        SolrInputDocument $this$createArticleSolrDocument_u24lambda_u248 = solrInputDocument = new SolrInputDocument();
        boolean bl = false;
        $this$createArticleSolrDocument_u24lambda_u248.setField("id", (Object)article.getId().toString());
        $this$createArticleSolrDocument_u24lambda_u248.setField("name", (Object)article.getTitle());
        $this$createArticleSolrDocument_u24lambda_u248.setField("name_sort", (Object)article.getTitle());
        $this$createArticleSolrDocument_u24lambda_u248.setField("content", (Object)article.getTextContent());
        $this$createArticleSolrDocument_u24lambda_u248.setField("type", (Object)this.articleType);
        $this$createArticleSolrDocument_u24lambda_u248.setField("modify_date", (Object)new Date(article.getUpdatedAt().toInstant().toEpochMilli()));
        $this$createArticleSolrDocument_u24lambda_u248.setField("publication_date", (Object)new Date(article.getCreatedAt().toInstant().toEpochMilli()));
        $this$createArticleSolrDocument_u24lambda_u248.setField("just_app_id", (Object)"WIKI");
        Iterable iterable = visibleForRoles;
        String string = "visible_for_roles";
        SolrInputDocument solrInputDocument2 = $this$createArticleSolrDocument_u24lambda_u248;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Role role = (Role)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toString());
        }
        collection = (List)destination$iv$iv;
        solrInputDocument2.setField(string, (Object)collection);
        $this$createArticleSolrDocument_u24lambda_u248.setField("parent_ids", (Object)CollectionsKt.listOf((Object)article.getWikiId().toString()));
        return solrInputDocument;
    }

    private void addSolrDocuments(List<? extends SolrInputDocument> inputDocuments) {
        if (inputDocuments.isEmpty()) {
            return;
        }
        try {
            if (this.useSoftCommit) {
                this.solrClient.add((Collection)inputDocuments, this.commitWithinInMs);
            } else {
                this.solrClient.add((Collection)inputDocuments);
            }
            this.getSuccessfulIndexedDocumentCount$wiki_service().addAndGet(inputDocuments.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            this.logger.warn("Batch adding of " + inputDocuments.size() + " documents failed. Try to add documents singly.", (Throwable)e);
            this.addSolrDocumentsSingly(inputDocuments);
        }
    }

    private void addSolrDocumentsSingly(List<? extends SolrInputDocument> solrDocuments) {
        Iterable $this$forEach$iv = solrDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SolrInputDocument it = (SolrInputDocument)element$iv;
            boolean bl = false;
            try {
                if (this.useSoftCommit) {
                    this.solrClient.add(it, this.commitWithinInMs);
                } else {
                    this.solrClient.add(it);
                }
                this.getSuccessfulIndexedDocumentCount$wiki_service().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                SolrInputField solrInputField = (SolrInputField)it.get((Object)"id");
                Object id = solrInputField != null ? solrInputField.getValue() : null;
                this.logger.error("Failed to index solr document for " + id, (Throwable)e);
                this.getFailedIndexedDocumentCount$wiki_service().incrementAndGet();
            }
        }
    }

    private void deleteSolrDocuments(List<String> ids) {
        if (ids.isEmpty()) {
            return;
        }
        try {
            if (this.useSoftCommit) {
                this.solrClient.deleteById(ids, this.commitWithinInMs);
            } else {
                this.solrClient.deleteById(ids);
            }
            this.getSuccessfulIndexedDocumentCount$wiki_service().addAndGet(ids.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            this.logger.warn("Batch deletion of " + ids.size() + " documents failed. Try to delete documents singly.", (Throwable)e);
            this.deleteSolrDocumentsSingly(ids);
        }
    }

    private void deleteSolrDocumentsSingly(List<String> ids) {
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            try {
                if (this.useSoftCommit) {
                    this.solrClient.deleteById(it, this.commitWithinInMs);
                } else {
                    this.solrClient.deleteById(it);
                }
                this.getSuccessfulIndexedDocumentCount$wiki_service().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                this.logger.error("Failed to delete solr document " + it, (Throwable)e);
                this.getFailedIndexedDocumentCount$wiki_service().incrementAndGet();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void index(@NotNull List<? extends AbstractId> ids) {
        Iterable $this$mapTo$iv$iv;
        Object it;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        Object it2;
        Collection<WikiId> collection;
        Iterable $this$mapTo$iv$iv3;
        Iterable $this$map$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        Object element$iv$iv3;
        void $this$filterIsInstanceTo$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv3;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable $this$filterIsInstance$iv = ids;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv3) {
            if (!(element$iv$iv2 instanceof WikiId)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Set wikiIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filterIsInstance$iv2 = ids;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv3 : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv3 instanceof ChapterId)) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        Set chapterIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$filterIsInstance$iv3 = ids;
        boolean $i$f$filterIsInstance3 = false;
        destination$iv$iv2 = $this$filterIsInstance$iv3;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo3 = false;
        for (Object element$iv$iv4 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv4 instanceof ArticleId)) continue;
            destination$iv$iv3.add(element$iv$iv4);
        }
        Set articleIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        if (wikiIds.isEmpty() && chapterIds.isEmpty() && articleIds.isEmpty()) {
            return;
        }
        Map articles = this.articleService.readByIds(articleIds);
        Map chapters = this.chapterService.readByIds(chapterIds);
        destination$iv$iv3 = articles.values();
        Collection<SolrInputDocument> collection2 = wikiIds;
        Object object = this.wikiService;
        boolean $i$f$map = false;
        element$iv$iv3 = $this$map$iv2;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            ArticleDto articleDto = (ArticleDto)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(it2.getWikiId());
        }
        collection = (List)destination$iv$iv4;
        $this$map$iv2 = chapters.values();
        collection2 = SetsKt.plus((Set)collection2, (Iterable)collection);
        $i$f$map = false;
        $this$mapTo$iv$iv3 = $this$map$iv2;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            it2 = (ChapterDto)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(it2.getWikiId());
        }
        collection = (List)destination$iv$iv4;
        Map wikis = object.readByIds(SetsKt.plus((Set)collection2, (Iterable)collection));
        $this$mapTo$iv$iv3 = wikis.values();
        object = this.permissionRequestConnector;
        boolean $i$f$map2 = false;
        void $i$f$mapTo2 = $this$map$iv;
        Iterable destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            WikiDto wikiDto = (WikiDto)item$iv$iv;
            collection2 = destination$iv$iv5;
            boolean bl = false;
            collection2.add((SolrInputDocument)it.getId().toString());
        }
        ImmutableSetMultimap immutableSetMultimap = object.visibility((Iterable)((List)destination$iv$iv5));
        Intrinsics.checkNotNullExpressionValue((Object)immutableSetMultimap, (String)"visibility(...)");
        ImmutableSetMultimap permissions = immutableSetMultimap;
        $this$map$iv = SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.minus((Set)wikiIds, (Iterable)wikis.keySet()), (Iterable)SetsKt.minus((Set)chapterIds, (Iterable)chapters.keySet())), (Iterable)SetsKt.minus((Set)articleIds, (Iterable)articles.keySet()));
        $i$f$map2 = false;
        $this$mapTo$iv$iv2 = $this$map$iv;
        destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo3 = false;
        it2 = $this$mapTo$iv$iv2.iterator();
        while (it2.hasNext()) {
            Object item$iv$iv;
            it = item$iv$iv = it2.next();
            object = destination$iv$iv5;
            boolean bl = false;
            object.add(((AbstractId)it).toString());
        }
        List idsToDeleted = (List)destination$iv$iv5;
        this.deleteSolrDocuments(idsToDeleted);
        Iterable $this$map$iv3 = wikis.values();
        boolean $i$f$map3 = false;
        destination$iv$iv5 = $this$map$iv3;
        Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            WikiDto bl = (WikiDto)item$iv$iv;
            object = destination$iv$iv6;
            boolean bl2 = false;
            ImmutableSet immutableSet = permissions.get((Object)it3.getId().toString());
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"get(...)");
            object.add(this.createWikiSolrDocument((WikiDto)it3, (Set)immutableSet));
        }
        $this$map$iv3 = chapters.values();
        object = (List)destination$iv$iv6;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv3;
        destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChapterDto it3 = (ChapterDto)item$iv$iv;
            collection2 = destination$iv$iv6;
            boolean bl = false;
            ImmutableSet immutableSet = permissions.get((Object)it3.getWikiId().toString());
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"get(...)");
            collection2.add(this.createChapterSolrDocument(it3, (Set)immutableSet));
        }
        $this$map$iv3 = articles.values();
        object = CollectionsKt.plus((Collection)object, (Iterable)((List)destination$iv$iv6));
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv3;
        destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ArticleDto it4 = (ArticleDto)item$iv$iv;
            collection2 = destination$iv$iv6;
            boolean bl = false;
            ImmutableSet immutableSet = permissions.get((Object)it4.getWikiId().toString());
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"get(...)");
            collection2.add(this.createArticleSolrDocument(it4, (Set)immutableSet));
        }
        List documents = CollectionsKt.plus((Collection)object, (Iterable)((List)destination$iv$iv6));
        this.addSolrDocuments(documents);
        if (!this.useSoftCommit) {
            this.solrClient.commit();
        }
    }

    private static final Number _init_$lambda$0(SolrService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getSuccessfulIndexedDocumentCount$wiki_service().get();
    }

    private static final Number _init_$lambda$1(SolrService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getFailedIndexedDocumentCount$wiki_service().get();
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

