/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.persistence;

import de.justsoftware.wikiservice.business.model.ArticleWithTitleDto;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.DeletionFlagRepository;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J*\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00052\u000e\b\u0001\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005H'J\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0016J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H'J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0017J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f2\u0006\u0010\u0015\u001a\u00020\u0010H\u0017J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0010H\u0017J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H'J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0017J(\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fH\u0016J \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\b\b\u0001\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 H'J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0007H&J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0007H&J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H'J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020&0\u0005H'J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020&0\u0005H'J(\u0010*\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fH\u0016J\"\u0010+\u001a\u00020\u000e2\u000e\b\u0001\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020&0\u00052\b\b\u0001\u0010\u0015\u001a\u00020\u0010H'J\u001c\u0010,\u001a\u00020\u000e2\b\b\u0001\u0010\u0017\u001a\u00020\u00072\b\b\u0001\u0010\u0015\u001a\u00020\u0010H'J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030.H'J0\u0010/\u001a\u00020\u000e2\b\b\u0001\u00100\u001a\u00020&2\b\b\u0001\u00101\u001a\u0002022\b\b\u0001\u00103\u001a\u0002042\b\b\u0001\u00105\u001a\u00020\u0003H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u00066\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "Lde/justsoftware/wikiservice/persistence/DeletionFlagRepository;", "Lde/justsoftware/wikiservice/persistence/model/Article;", "Lde/justsoftware/wikiservice/model/ArticleId;", "countByWikiIdIn", "", "Lkotlin/Pair;", "Lde/justsoftware/wikiservice/model/WikiId;", "", "wikiIds", "countByWikiIds", "", "", "deleteAllByDeletionIdIn", "", "deletionIds", "Lde/justsoftware/wikiservice/model/DeletionId;", "deleteAllByDeletionIds", "deleteAllByParentIds", "parentIds", "Lde/justsoftware/wikiservice/model/ParentId;", "deletionId", "deleteAllByWikiId", "wikiId", "findAllByDeletionIdIn", "findAllByDeletionIds", "findAllByParentIds", "findAllBySubscriber", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/wikiservice/business/model/ArticleWithTitleDto;", "subscriberId", "pageable", "Lorg/springframework/data/domain/Pageable;", "findAllByWikiId", "findAllByWikiIdAndDeletionIdIsNull", "findByDeletionIdIsNullAndIdIn", "ids", "findByDeletionIdIsNullAndParentIdIn", "Ljava/util/UUID;", "findByIds", "articleIds", "findByParentIdIn", "findByParentIds", "markArticlesByParentIdAsDeleted", "markArticlesByWikiIdAsDeleted", "streamAllIds", "Ljava/util/stream/Stream;", "updateParentIdAndPosition", "parentId", "parentType", "Lde/justsoftware/wikiservice/model/IdType;", "relativePosition", "", "id", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nArticleRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArticleRepository.kt\nde/justsoftware/wikiservice/persistence/ArticleRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,209:1\n1360#2:210\n1446#2,5:211\n1549#2:216\n1620#2,3:217\n1360#2:220\n1446#2,5:221\n1477#2:226\n1502#2,3:227\n1505#2,3:237\n1549#2:240\n1620#2,3:241\n1360#2:244\n1446#2,5:245\n1477#2:250\n1502#2,3:251\n1505#2,3:261\n1549#2:264\n1620#2,3:265\n1549#2:268\n1620#2,3:269\n1549#2:272\n1620#2,3:273\n1360#2:276\n1446#2,5:277\n1360#2:282\n1446#2,5:283\n1855#2,2:288\n372#3,7:230\n372#3,7:254\n*S KotlinDebug\n*F\n+ 1 ArticleRepository.kt\nde/justsoftware/wikiservice/persistence/ArticleRepository\n*L\n56#1:210\n56#1:211,5\n70#1:216\n70#1:217,3\n72#1:220\n72#1:221,5\n73#1:226\n73#1:227,3\n73#1:237,3\n81#1:240\n81#1:241,3\n83#1:244\n83#1:245,5\n84#1:250\n84#1:251,3\n84#1:261,3\n110#1:264\n110#1:265,3\n112#1:268\n112#1:269,3\n115#1:272\n115#1:273,3\n136#1:276\n136#1:277,5\n174#1:282\n174#1:283,5\n182#1:288,2\n73#1:230,7\n84#1:254,7\n*E\n"})
public interface ArticleRepository
extends DeletionFlagRepository<Article, ArticleId> {
    @NotNull
    public Set<Article> findAllByWikiId(@NotNull WikiId var1);

    @NotNull
    public Set<Article> findAllByWikiIdAndDeletionIdIsNull(@NotNull WikiId var1);

    @Query(value="SELECT new de.justsoftware.wikiservice.business.model.ArticleWithTitleDto(a.id, a.wikiId, a.parentId, a.parentType, av.title) FROM Article a INNER JOIN Subscription s ON (a.id.id = s.itemId AND s.itemType = 'WIKI_ARTICLE') INNER JOIN ArticleVersion av ON (a.id = av.articleId) WHERE av.createdAt IN  (SELECT max(al.createdAt) FROM ArticleVersion al WHERE al.articleId = av.articleId) AND s.isSubscribed = true AND s.subscriber = :subscriber AND a.deletionId is null")
    @NotNull
    public Page<ArticleWithTitleDto> findAllBySubscriber(@Param(value="subscriber") long var1, @NotNull Pageable var3);

    @Deprecated(message="Do not use this function directly. Use {@link #findByIds(Set)} instead.")
    @NotNull
    public List<Article> findByDeletionIdIsNullAndIdIn(@NotNull List<ArticleId> var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<Article> findByIds(@NotNull Set<ArticleId> articleIds) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)articleIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findByDeletionIdIsNullAndIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Deprecated(message="Use {@link #findByParentIds(Set)} instead.")
    @NotNull
    public List<Article> findByDeletionIdIsNullAndParentIdIn(@NotNull List<UUID> var1);

    @Deprecated(message="Use {@link #findAllByParentIds(Set)} instead.")
    @NotNull
    public List<Article> findByParentIdIn(@NotNull List<UUID> var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<ParentId, List<Article>> findByParentIds(@NotNull Set<? extends ParentId> parentIds) {
        void $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Article it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Iterable $this$map$iv = parentIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParentId parentId = (ParentId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.findByDeletionIdIsNullAndParentIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Article)element$iv$iv;
            boolean bl = false;
            ParentId key$iv$iv = IdUtilsKt.parentIdOf((UUID)it.getParentId(), (IdType)it.getParentType());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<ParentId, List<Article>> findAllByParentIds(@NotNull Set<? extends ParentId> parentIds) {
        void $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Article it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Iterable $this$map$iv = parentIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParentId parentId = (ParentId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.findByParentIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Article)element$iv$iv;
            boolean bl = false;
            ParentId key$iv$iv = IdUtilsKt.parentIdOf((UUID)it.getParentId(), (IdType)it.getParentType());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    @Deprecated(message="Do not use this function directly. Use {@link #deleteAllByParentIds(Set, DeletionId)} instead.")
    @Modifying
    @Query(value="\n            UPDATE Article a\n            SET a.deletionId = :deletionId\n            WHERE a.deletionId is null\n            AND a.parentId IN :parentIds\n        ")
    public void markArticlesByParentIdAsDeleted(@Param(value="parentIds") @NotNull List<UUID> var1, @Param(value="deletionId") @NotNull DeletionId var2);

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    default public Set<ArticleId> deleteAllByParentIds(@NotNull Set<? extends ParentId> parentIds, @NotNull DeletionId deletionId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List it;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Iterable $this$map$iv2 = parentIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            ParentId parentId = (ParentId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        $this$map$iv2 = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            this.markArticlesByParentIdAsDeleted(it, deletionId);
            collection.add(Unit.INSTANCE);
        }
        List it2 = (List)destination$iv$iv;
        boolean bl = false;
        destination$iv$iv = this.findAllByDeletionIds(SetsKt.setOf((Object)deletionId));
        boolean $i$f$map2 = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            Article article = (Article)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(it3.getId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
    }

    @Deprecated(message="Do not use this function directly. Use {@link #countByWikiIds(Set)} instead.")
    @Query(value="\n       SELECT new kotlin.Pair(a.wikiId, count(a))\n       FROM Article a\n       WHERE a.wikiId in :wikiIds\n       AND a.deletionId is null\n       GROUP BY wikiId\n    ")
    @NotNull
    public List<Pair<WikiId, Long>> countByWikiIdIn(@Param(value="wikiIds") @NotNull List<WikiId> var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<WikiId, Long> countByWikiIds(@NotNull Set<WikiId> wikiIds) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)wikiIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.countByWikiIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Deprecated(message="Do not use this function directly. Use {@link #deleteAllByWikiId(WikiId, DeletionId)} instead.")
    @Modifying
    @Query(value="\n            UPDATE Article a\n            SET a.deletionId = :deletionId\n            WHERE a.deletionId is null\n            AND a.wikiId = :wikiId\n        ")
    public void markArticlesByWikiIdAsDeleted(@Param(value="wikiId") @NotNull WikiId var1, @Param(value="deletionId") @NotNull DeletionId var2);

    @Transactional
    @NotNull
    default public Set<Article> deleteAllByWikiId(@NotNull WikiId wikiId, @NotNull DeletionId deletionId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        this.markArticlesByWikiIdAsDeleted(wikiId, deletionId);
        Unit $this$deleteAllByWikiId_u24lambda_u2411 = Unit.INSTANCE;
        boolean bl = false;
        return this.findAllByDeletionIds(SetsKt.setOf((Object)deletionId));
    }

    @Deprecated(message="Do not use this function directly. Use {@link #deleteAllByDeletionIds(Set)} instead.")
    @NotNull
    public Set<Article> findAllByDeletionIdIn(@NotNull List<DeletionId> var1);

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    default public Set<Article> findAllByDeletionIds(@NotNull Set<DeletionId> deletionIds) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(deletionIds, (String)"deletionIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)deletionIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findAllByDeletionIdIn(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Transactional
    default public void deleteAllByDeletionIds(@NotNull Set<DeletionId> deletionIds) {
        Intrinsics.checkNotNullParameter(deletionIds, (String)"deletionIds");
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)deletionIds, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.deleteAllByDeletionIdIn(it);
        }
    }

    @Deprecated(message="Do not use this function directly. Use {@link #deleteAllByDeletionIds(Set)} instead.")
    public void deleteAllByDeletionIdIn(@NotNull List<DeletionId> var1);

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="\n            UPDATE Article a\n            SET a.parentId = :parentId,\n                a.parentType = :parentType,\n                a.relativePosition = :relativePosition\n            WHERE a.id = :id\n        ")
    public void updateParentIdAndPosition(@Param(value="parentId") @NotNull UUID var1, @Param(value="parentType") @NotNull IdType var2, @Param(value="relativePosition") int var3, @Param(value="id") @NotNull ArticleId var4);

    @Query(value="SELECT a.id FROM Article a")
    @NotNull
    public Stream<ArticleId> streamAllIds();
}

