/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.config.security;

import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.wikiservice.config.security.oAuth.JustOpaqueTokenIntrospector;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\b\u001a\u00020\u00042\b\b\u0001\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\u00042\b\b\u0001\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/wikiservice/config/security/WebSecurityConfiguration;", "", "()V", "internalApi", "", "configureSecurity", "Lorg/springframework/security/web/SecurityFilterChain;", "toroBaseUrl", "checkTokenEndpoint", "clientId", "clientSecret", "maxAccessTokenCacheSize", "", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "wiki-service"})
public class WebSecurityConfiguration {
    @NotNull
    private final String internalApi;

    public WebSecurityConfiguration() {
        this.internalApi = "/internal/**";
    }

    @Bean
    @NotNull
    public SecurityFilterChain configureSecurity(@Value(value="${just.wiki.toro.internal.baseUrl}") @NotNull String toroBaseUrl, @Value(value="${just.wiki.oauth2.resource.check_token_endpoint}") @NotNull String checkTokenEndpoint, @Value(value="${just.wiki.oauth2.resource.client_id}") @NotNull String clientId, @Value(value="${just.wiki.oauth2.resource.client_secret}") @NotNull String clientSecret, @Value(value="${just.wiki.oauth2.resource.accessTokenCache.maxSize: 1000}") long maxAccessTokenCacheSize, @NotNull HttpSecurity http, @NotNull JwtVerifier jwtVerifier) {
        Intrinsics.checkNotNullParameter((Object)toroBaseUrl, (String)"toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)checkTokenEndpoint, (String)"checkTokenEndpoint");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        JwtAuthenticationProcessingFilter jwt = new JwtAuthenticationProcessingFilter(jwtVerifier);
        jwt.applyIgnoreFilterMatcher(arg_0 -> WebSecurityConfiguration.configureSecurity$lambda$0(this, arg_0));
        http.sessionManagement(WebSecurityConfiguration::configureSecurity$lambda$1).exceptionHandling(Customizer.withDefaults()).csrf(WebSecurityConfiguration::configureSecurity$lambda$2).headers(WebSecurityConfiguration::configureSecurity$lambda$3).anonymous(Customizer.withDefaults()).authorizeHttpRequests(arg_0 -> WebSecurityConfiguration.configureSecurity$lambda$4(this, arg_0)).oauth2ResourceServer(arg_0 -> WebSecurityConfiguration.configureSecurity$lambda$6(toroBaseUrl, checkTokenEndpoint, clientId, clientSecret, maxAccessTokenCacheSize, arg_0)).addFilterAfter((Filter)jwt, AbstractPreAuthenticatedProcessingFilter.class);
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    private static final boolean configureSecurity$lambda$0(WebSecurityConfiguration this$0, HttpServletRequest it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new AntPathRequestMatcher(this$0.internalApi).matches(it);
    }

    private static final void configureSecurity$lambda$1(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private static final void configureSecurity$lambda$2(CsrfConfigurer it) {
        it.disable();
    }

    private static final void configureSecurity$lambda$3(HeadersConfigurer it) {
        it.cacheControl(Customizer.withDefaults());
    }

    private static final void configureSecurity$lambda$4(WebSecurityConfiguration this$0, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RequestMatcher[] requestMatcherArray = new RequestMatcher[]{new AntPathRequestMatcher(this$0.internalApi)};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(requestMatcherArray)).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.anyRequest()).fullyAuthenticated();
    }

    private static final void configureSecurity$lambda$6$lambda$5(String $toroBaseUrl, String $checkTokenEndpoint, String $clientId, String $clientSecret, long $maxAccessTokenCacheSize, OAuth2ResourceServerConfigurer.OpaqueTokenConfigurer opaqueTokenCustomizer) {
        Intrinsics.checkNotNullParameter((Object)$toroBaseUrl, (String)"$toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)$checkTokenEndpoint, (String)"$checkTokenEndpoint");
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        Intrinsics.checkNotNullParameter((Object)$clientSecret, (String)"$clientSecret");
        JustOpaqueTokenIntrospector justTokenIntrospector = new JustOpaqueTokenIntrospector($toroBaseUrl + $checkTokenEndpoint, $clientId, $clientSecret, $maxAccessTokenCacheSize);
        opaqueTokenCustomizer.introspector((OpaqueTokenIntrospector)justTokenIntrospector);
    }

    private static final void configureSecurity$lambda$6(String $toroBaseUrl, String $checkTokenEndpoint, String $clientId, String $clientSecret, long $maxAccessTokenCacheSize, OAuth2ResourceServerConfigurer resourceServerCustomizer) {
        Intrinsics.checkNotNullParameter((Object)$toroBaseUrl, (String)"$toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)$checkTokenEndpoint, (String)"$checkTokenEndpoint");
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        Intrinsics.checkNotNullParameter((Object)$clientSecret, (String)"$clientSecret");
        resourceServerCustomizer.opaqueToken(arg_0 -> WebSecurityConfiguration.configureSecurity$lambda$6$lambda$5($toroBaseUrl, $checkTokenEndpoint, $clientId, $clientSecret, $maxAccessTokenCacheSize, arg_0));
    }
}

