/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.config.AuthContextResolver;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/wikiservice/config/WikiWebConfiguration;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "toroBaseUrl", "", "authService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Ljava/lang/String;Lde/justsoftware/wikiservice/authorization/AuthorizationService;Lde/justsoftware/wikiservice/business/WikiService;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "addArgumentResolvers", "", "argumentResolvers", "", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "wiki-service"})
public class WikiWebConfiguration
implements WebMvcConfigurer {
    @NotNull
    private final String toroBaseUrl;
    @NotNull
    private final AuthorizationService authService;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final ObjectMapper objectMapper;

    public WikiWebConfiguration(@Value(value="${just.wiki.toro.internal.baseurl}") @NotNull String toroBaseUrl, @NotNull AuthorizationService authService, @NotNull WikiService wikiService, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)toroBaseUrl, (String)"toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)authService, (String)"authService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.toroBaseUrl = toroBaseUrl;
        this.authService = authService;
        this.wikiService = wikiService;
        this.objectMapper = objectMapper;
    }

    public void addArgumentResolvers(@NotNull List<HandlerMethodArgumentResolver> argumentResolvers) {
        Intrinsics.checkNotNullParameter(argumentResolvers, (String)"argumentResolvers");
        argumentResolvers.add((HandlerMethodArgumentResolver)new AuthContextResolver(this.toroBaseUrl, this.authService, this.wikiService, this.objectMapper, null, 16, null));
    }
}

