/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.config.WikiConfigProperties;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.DeletionRepository;
import de.justsoftware.wikiservice.persistence.model.Deletion;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@RefreshScope
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0017J\b\u0010\u001a\u001a\u00020\u0016H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/wikiservice/business/DeletionService;", "", "deletionRepository", "Lde/justsoftware/wikiservice/persistence/DeletionRepository;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "wikiConfigProperties", "Lde/justsoftware/wikiservice/config/WikiConfigProperties;", "(Lde/justsoftware/wikiservice/persistence/DeletionRepository;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/config/WikiConfigProperties;)V", "create", "Lde/justsoftware/wikiservice/model/DeletionId;", "deletionItemId", "Lde/justsoftware/wikiservice/model/ItemId;", "deletedBy", "Lde/justsoftware/wikiservice/model/ProfileId;", "deletedAt", "Ljava/time/Instant;", "deleteWikisInTenant", "", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "createdBefore", "removeOldDeletions", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nDeletionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeletionService.kt\nde/justsoftware/wikiservice/business/DeletionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1549#2:72\n1620#2,3:73\n766#2:76\n857#2,2:77\n1549#2:79\n1620#2,3:80\n1855#2,2:83\n*S KotlinDebug\n*F\n+ 1 DeletionService.kt\nde/justsoftware/wikiservice/business/DeletionService\n*L\n34#1:72\n34#1:73,3\n63#1:76\n63#1:77,2\n64#1:79\n64#1:80,3\n65#1:83,2\n*E\n"})
public class DeletionService {
    @NotNull
    private final DeletionRepository deletionRepository;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final WikiConfigProperties wikiConfigProperties;

    @Autowired
    public DeletionService(@NotNull DeletionRepository deletionRepository, @NotNull ArticleService articleService, @NotNull ChapterService chapterService, @NotNull WikiService wikiService, @NotNull WikiConfigProperties wikiConfigProperties) {
        Intrinsics.checkNotNullParameter((Object)deletionRepository, (String)"deletionRepository");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)wikiConfigProperties, (String)"wikiConfigProperties");
        this.deletionRepository = deletionRepository;
        this.articleService = articleService;
        this.chapterService = chapterService;
        this.wikiService = wikiService;
        this.wikiConfigProperties = wikiConfigProperties;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Scheduled(fixedRate=60L, initialDelay=1L, timeUnit=TimeUnit.MINUTES)
    public void removeOldDeletions() {
        void $this$mapTo$iv$iv;
        Long l = this.wikiConfigProperties.getCleanupAfter();
        if (l == null) {
            return;
        }
        long maxAgeInDays = l;
        Instant deletedBefore = Instant.now().minus(maxAgeInDays, ChronoUnit.DAYS);
        Intrinsics.checkNotNull((Object)deletedBefore);
        Set cleanableDeletions = this.deletionRepository.findAllByDeletedAtBefore(deletedBefore);
        Iterable $this$map$iv = cleanableDeletions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Deletion deletion = (Deletion)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set deletionIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.articleService.removeDeletedArticles(deletionIds);
        this.chapterService.removeDeletedChapters(deletionIds);
        this.wikiService.removeDeletedWikis(cleanableDeletions);
        this.deletionRepository.deleteAll((Iterable)cleanableDeletions);
    }

    @NotNull
    public DeletionId create(@NotNull ItemId deletionItemId, @NotNull ProfileId deletedBy, @NotNull Instant deletedAt) {
        Intrinsics.checkNotNullParameter((Object)deletionItemId, (String)"deletionItemId");
        Intrinsics.checkNotNullParameter((Object)deletedBy, (String)"deletedBy");
        Intrinsics.checkNotNullParameter((Object)deletedAt, (String)"deletedAt");
        return ((Deletion)this.deletionRepository.saveAndFlush((Object)new Deletion(new DeletionId(), deletionItemId, deletedAt, deletedBy))).getId();
    }

    public static /* synthetic */ DeletionId create$default(DeletionService deletionService, ItemId itemId, ProfileId profileId, Instant instant, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 4) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        return deletionService.create(itemId, profileId, instant);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteWikisInTenant(@NotNull TenantId tenantId, @NotNull Instant createdBefore) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Wiki it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)createdBefore, (String)"createdBefore");
        ProfileId deletedBy = new ProfileId(-1L);
        Instant deletedAt = Instant.now();
        Iterable iterable = this.wikiService.findWikisByTenant(tenantId);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Wiki)element$iv$iv;
            boolean bl = false;
            Instant instant = it.getCreatedAt();
            if (instant == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            if (!instant.isBefore(createdBefore)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Wiki)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WikiId it2 = (WikiId)element$iv;
            boolean bl = false;
            ItemId itemId = (ItemId)it2;
            Intrinsics.checkNotNull((Object)deletedAt);
            DeletionId deletionId = this.create(itemId, deletedBy, deletedAt);
            this.wikiService.delete(it2, deletionId);
        }
    }
}

