/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ArticleService$readByParentIds$lambda$14$;
import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.exceptions.ArticleVersionNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.EmptyArticleTitleException;
import de.justsoftware.wikiservice.business.model.ArticleDto;
import de.justsoftware.wikiservice.business.model.ArticleVersionDto;
import de.justsoftware.wikiservice.business.model.ArticleWithTitleDto;
import de.justsoftware.wikiservice.drive.DriveService;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.MigrationStatus;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.ArticleHeadingMigrationRepository;
import de.justsoftware.wikiservice.persistence.ArticleHeadingRepository;
import de.justsoftware.wikiservice.persistence.ArticleRepository;
import de.justsoftware.wikiservice.persistence.ArticleVersionRepository;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.ArticleHeading;
import de.justsoftware.wikiservice.persistence.model.ArticleHeadingMigrationStatus;
import de.justsoftware.wikiservice.persistence.model.ArticleVersion;
import de.justsoftware.wikiservice.prosemirror.ArticleHeadingInfo;
import de.justsoftware.wikiservice.prosemirror.ProseMirrorContentParserKt;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import de.justsoftware.wikiservice.util.TransactionUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 ]2\u00020\u0001:\u0001]Bi\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0001\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\"\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\"H\u0016JJ\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020 2\b\u0010/\u001a\u0004\u0018\u00010-H\u0017J \u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020-H\u0017J\u001e\u00107\u001a\u0002012\f\u00108\u001a\b\u0012\u0004\u0012\u00020&0\"2\u0006\u00104\u001a\u000205H\u0017J\u0018\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020-H\u0017J\u0018\u0010<\u001a\u0002012\u0006\u0010=\u001a\u00020\u001f2\u0006\u00104\u001a\u000205H\u0017J\u0010\u0010>\u001a\u00020?2\u0006\u00102\u001a\u000203H\u0012J\u001d\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020A2\u0006\u0010C\u001a\u00020?H\u0011\u00a2\u0006\u0002\bDJ\b\u0010E\u001a\u000201H\u0017J\u0010\u0010F\u001a\u00020$2\u0006\u00102\u001a\u000203H\u0017J\u000e\u0010G\u001a\b\u0012\u0004\u0012\u0002030\"H\u0016J\u0010\u0010H\u001a\u00020$2\u0006\u0010I\u001a\u00020JH\u0017J\"\u0010K\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020$0\u001e2\f\u0010L\u001a\b\u0012\u0004\u0012\u0002030\"H\u0016J(\u0010M\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0N0\u001e2\f\u00108\u001a\b\u0012\u0004\u0012\u00020&0\"H\u0016J&\u0010O\u001a\b\u0012\u0004\u0012\u00020P0N2\u0006\u0010Q\u001a\u00020-2\u0006\u0010R\u001a\u00020 2\u0006\u0010S\u001a\u00020 H\u0017J(\u0010T\u001a\u0014\u0012\u0004\u0012\u000203\u0012\n\u0012\b\u0012\u0004\u0012\u00020U0N0\u001e2\f\u0010L\u001a\b\u0012\u0004\u0012\u0002030\"H\u0017J\u0016\u0010V\u001a\u0002012\f\u0010W\u001a\b\u0012\u0004\u0012\u0002050\"H\u0017J\u000e\u0010X\u001a\b\u0012\u0004\u0012\u0002030YH\u0016JJ\u0010Z\u001a\u00020$2\u0006\u00102\u001a\u0002032\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010)2\b\u0010+\u001a\u0004\u0018\u00010)2\u0006\u0010;\u001a\u00020-2\b\u0010/\u001a\u0004\u0018\u00010-2\b\b\u0002\u0010[\u001a\u00020\u001cH\u0017J\u0018\u0010\\\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020-H\u0017R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00198\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lde/justsoftware/wikiservice/business/ArticleService;", "", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "articleRepository", "Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "articleHeadingRepository", "Lde/justsoftware/wikiservice/persistence/ArticleHeadingRepository;", "headingMigrationRepository", "Lde/justsoftware/wikiservice/persistence/ArticleHeadingMigrationRepository;", "articleVersionRepository", "Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "driveService", "Lde/justsoftware/wikiservice/drive/DriveService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "clock", "Ljava/time/Clock;", "maxEditingTokenDuration", "", "entityManager", "Ljakarta/persistence/EntityManager;", "(Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/persistence/ArticleRepository;Lde/justsoftware/wikiservice/persistence/ArticleHeadingRepository;Lde/justsoftware/wikiservice/persistence/ArticleHeadingMigrationRepository;Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;Lde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/wikiservice/drive/DriveService;Lde/justsoftware/wikiservice/business/AncestorService;Ljava/time/Clock;JLjakarta/persistence/EntityManager;)V", "articlesHeadersFullyMigrated", "", "countByWikiIds", "", "Lde/justsoftware/wikiservice/model/WikiId;", "", "wikiIds", "", "create", "Lde/justsoftware/wikiservice/business/model/ArticleDto;", "parentId", "Lde/justsoftware/wikiservice/model/ParentId;", "wiki", "title", "", "content", "textContent", "creator", "Lde/justsoftware/wikiservice/model/ProfileId;", "position", "contactPerson", "delete", "", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "deletionId", "Lde/justsoftware/wikiservice/model/DeletionId;", "deletedBy", "deleteByParentIds", "parentIds", "deleteEditingToken", "articleDto", "updater", "deleteWikiArticles", "wikiId", "getLatestArticleVersion", "Lde/justsoftware/wikiservice/persistence/model/ArticleVersion;", "migrateArticleHeaders", "Lde/justsoftware/wikiservice/persistence/model/ArticleHeadingMigrationStatus;", "toMigrate", "articleVersion", "migrateArticleHeaders$wiki_service", "migrateArticlesHeaders", "read", "readAllIds", "readArticleByVersionId", "versionId", "Lde/justsoftware/wikiservice/model/ArticleVersionId;", "readByIds", "articleIds", "readByParentIds", "", "readBySubscriber", "Lde/justsoftware/wikiservice/business/model/ArticleWithTitleDto;", "subscriber", "page", "limit", "readVersions", "Lde/justsoftware/wikiservice/business/model/ArticleVersionDto;", "removeDeletedArticles", "deletionIds", "streamAllIds", "Ljava/util/stream/Stream;", "update", "articleWasMoved", "updateEditingToken", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nArticleService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArticleService.kt\nde/justsoftware/wikiservice/business/ArticleService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,526:1\n1549#2:527\n1620#2,3:528\n1271#2,2:531\n1285#2,4:533\n1549#2:537\n1620#2,3:538\n1549#2:541\n1620#2,3:542\n1194#2,2:545\n1222#2,4:547\n1549#2:551\n1620#2,3:552\n1271#2,2:555\n1285#2,2:557\n1549#2:559\n1620#2,3:560\n1288#2:563\n1603#2,9:564\n1855#2:573\n1856#2:575\n1612#2:576\n1271#2,2:577\n1285#2,4:579\n1549#2:584\n1620#2,3:585\n1855#2,2:588\n1855#2,2:590\n1549#2:592\n1620#2,3:593\n1549#2:596\n1620#2,3:597\n1549#2:600\n1620#2,3:601\n1#3:574\n1#3:583\n*S KotlinDebug\n*F\n+ 1 ArticleService.kt\nde/justsoftware/wikiservice/business/ArticleService\n*L\n110#1:527\n110#1:528,3\n174#1:531,2\n174#1:533,4\n190#1:537\n190#1:538,3\n194#1:541\n194#1:542,3\n201#1:545,2\n201#1:547,4\n209#1:551\n209#1:552,3\n212#1:555,2\n212#1:557,2\n215#1:559\n215#1:560,3\n212#1:563\n226#1:564,9\n226#1:573\n226#1:575\n226#1:576\n232#1:577,2\n232#1:579,4\n307#1:584\n307#1:585,3\n356#1:588,2\n371#1:590,2\n432#1:592\n432#1:593,3\n463#1:596\n463#1:597,3\n504#1:600\n504#1:601,3\n226#1:574\n*E\n"})
public class ArticleService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final ArticleRepository articleRepository;
    @NotNull
    private final ArticleHeadingRepository articleHeadingRepository;
    @NotNull
    private final ArticleHeadingMigrationRepository headingMigrationRepository;
    @NotNull
    private final ArticleVersionRepository articleVersionRepository;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final DriveService driveService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final Clock clock;
    private final long maxEditingTokenDuration;
    @PersistenceContext
    @NotNull
    private final EntityManager entityManager;
    private static final Logger LOG = LoggerFactory.getLogger(ArticleService.class);
    private static boolean articlesHeadersMigrationFinished;

    @Autowired
    public ArticleService(@NotNull PermissionService permissionService, @NotNull ArticleRepository articleRepository, @NotNull ArticleHeadingRepository articleHeadingRepository, @NotNull ArticleHeadingMigrationRepository headingMigrationRepository, @NotNull ArticleVersionRepository articleVersionRepository, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull DriveService driveService, @NotNull AncestorService ancestorService, @NotNull Clock clock, @Value(value="${service.maxArticleEditingTokenDurationSec:28800}") long maxEditingTokenDuration, @NotNull EntityManager entityManager) {
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)articleRepository, (String)"articleRepository");
        Intrinsics.checkNotNullParameter((Object)articleHeadingRepository, (String)"articleHeadingRepository");
        Intrinsics.checkNotNullParameter((Object)headingMigrationRepository, (String)"headingMigrationRepository");
        Intrinsics.checkNotNullParameter((Object)articleVersionRepository, (String)"articleVersionRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)driveService, (String)"driveService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        this.permissionService = permissionService;
        this.articleRepository = articleRepository;
        this.articleHeadingRepository = articleHeadingRepository;
        this.headingMigrationRepository = headingMigrationRepository;
        this.articleVersionRepository = articleVersionRepository;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
        this.driveService = driveService;
        this.ancestorService = ancestorService;
        this.clock = clock;
        this.maxEditingTokenDuration = maxEditingTokenDuration;
        this.entityManager = entityManager;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public ArticleDto create(@NotNull ParentId parentId, @NotNull WikiId wiki, @NotNull String title, @NotNull String content, @NotNull String textContent, @NotNull ProfileId creator, int position, @Nullable ProfileId contactPerson) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)wiki, (String)"wiki");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)textContent, (String)"textContent");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        if (StringsKt.isBlank((CharSequence)title)) {
            throw new EmptyArticleTitleException();
        }
        ProseMirrorContentParserKt.verifyAllHeadingsHaveUniqueIds((String)content);
        Article it = (Article)this.articleRepository.save((Object)new Article(new ArticleId(), wiki, parentId, null, null, null, Integer.valueOf(position), contactPerson, 56, null));
        boolean bl = false;
        ArticleId articleId = it.getId();
        ArticleVersionId articleVersionId = new ArticleVersionId();
        String string = StringUtils.normalizeSpace((String)title);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalizeSpace(...)");
        ArticleVersion version = (ArticleVersion)this.articleVersionRepository.save((Object)new ArticleVersion(articleVersionId, articleId, string, content, textContent, creator));
        Iterable iterable = ProseMirrorContentParserKt.getHeadings((String)content);
        boolean $i$f$map = false;
        String string2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void heading;
            ArticleHeadingInfo articleHeadingInfo = (ArticleHeadingInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new ArticleHeading(heading.getId(), articleId, heading.getText(), heading.getSortOrder()));
        }
        List headings = (List)destination$iv$iv;
        this.articleHeadingRepository.saveAll((Iterable)headings);
        Set tempDriveMediaIds = ProseMirrorContentParserKt.driveMediaIdsFromPMContent((String)content);
        if (!((Collection)tempDriveMediaIds).isEmpty()) {
            this.driveService.persistFiles(tempDriveMediaIds, articleId, creator);
        }
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        this.permissionService.addPermissionItemForNewArticle(articleId, wiki);
        Instant updatedAt = version.getUpdatedAt();
        if (updatedAt == null) {
            string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        this.ancestorService.updateEditedStatusForAncestors(parentId, updatedAt, version.getModifiedBy());
        Intrinsics.checkNotNull((Object)it);
        Intrinsics.checkNotNull((Object)version);
        return ArticleDto.Companion.toDto(it, version, this.clock, this.maxEditingTokenDuration);
    }

    private ArticleVersion getLatestArticleVersion(ArticleId articleId) {
        ArticleVersion articleVersion = (ArticleVersion)this.articleVersionRepository.findLatestArticleVersionsByArticleIds(SetsKt.setOf((Object)articleId)).get(articleId);
        if (articleVersion == null) {
            throw new ArticleVersionNotFoundException(null, 1, null);
        }
        return articleVersion;
    }

    @Transactional(readOnly=true)
    @NotNull
    public List<ArticleWithTitleDto> readBySubscriber(@NotNull ProfileId subscriber, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        long l = subscriber.getId();
        String[] stringArray = new String[]{"id"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List<ArticleWithTitleDto> list = this.articleRepository.findAllBySubscriber(l, (Pageable)pageRequest).get().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    @Transactional
    @NotNull
    public ArticleDto read(@NotNull ArticleId articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Article it = (Article)this.articleRepository.getReferenceById((Object)articleId);
        boolean bl = false;
        ArticleVersion articleVersion = this.getLatestArticleVersion(it.getId());
        Intrinsics.checkNotNull((Object)it);
        return ArticleDto.Companion.toDto(it, articleVersion, this.clock, this.maxEditingTokenDuration);
    }

    @Transactional
    @NotNull
    public ArticleDto readArticleByVersionId(@NotNull ArticleVersionId versionId) {
        Intrinsics.checkNotNullParameter((Object)versionId, (String)"versionId");
        ArticleVersion it = (ArticleVersion)this.articleVersionRepository.findById((Object)versionId).orElseThrow(() -> ArticleService.readArticleByVersionId$lambda$3(versionId));
        boolean bl = false;
        Object object = this.articleRepository.getReferenceById((Object)it.getArticleId());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getReferenceById(...)");
        Article article = (Article)object;
        Intrinsics.checkNotNull((Object)it);
        return ArticleDto.Companion.toDto(article, it, this.clock, this.maxEditingTokenDuration);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Map<ArticleId, List<ArticleVersionDto>> readVersions(@NotNull Set<ArticleId> articleIds) {
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Iterable $this$associateWith$iv = articleIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void article;
            ArticleId articleId = (ArticleId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            List<ArticleVersionDto> list = this.articleVersionRepository.findByArticleIdOrderByCreatedAtDesc((ArticleId)article).map(arg_0 -> ArticleService.readVersions$lambda$6$lambda$5((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).toList();
            map.put(t, list);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ArticleId, ArticleDto> readByIds(@NotNull Set<ArticleId> articleIds) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Article article;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        List articles = this.articleRepository.findByIds(articleIds);
        boolean bl = false;
        Iterable iterable = articles;
        Object object = this.articleVersionRepository;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Article article2 = (Article)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(article.getId());
        }
        Map latestVersions = object.findLatestArticleVersionsByArticleIds(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        $this$map$iv = articles;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            article = (Article)item$iv$iv;
            object = destination$iv$iv;
            boolean bl3 = false;
            ArticleVersion articleVersion = (ArticleVersion)latestVersions.get(it.getId());
            if (articleVersion == null) {
                throw new ArticleVersionNotFoundException(null, 1, null);
            }
            object.add(ArticleDto.Companion.toDto((Article)it, articleVersion, this.clock, this.maxEditingTokenDuration));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ArticleDto bl3 = (ArticleDto)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl4 = false;
            object.put(it.getId(), element$iv$iv);
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<ArticleDto>> readByParentIds(@NotNull Set<? extends ParentId> parentIds) {
        ParentId it;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Map parentArticles = this.articleRepository.findByParentIds(parentIds);
        Iterable iterable = CollectionsKt.flatten((Iterable)parentArticles.values());
        Object object = this.articleVersionRepository;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Article article = (Article)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Map articleVersions = object.findLatestArticleVersionsByArticleIds(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Iterable $this$associateWith$iv = parentIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void parentId;
            it = (ParentId)element$iv$iv;
            collection = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Object object2 = parentArticles.getOrDefault(parentId, CollectionsKt.emptyList());
            boolean $i$f$map2 = false;
            void var15_17 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                Article article = (Article)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                ArticleVersion articleVersion = (ArticleVersion)articleVersions.get(it2.getId());
                if (articleVersion == null) {
                    throw new ArticleVersionNotFoundException(null, 1, null);
                }
                collection2.add(ArticleDto.Companion.toDto((Article)it2, articleVersion, this.clock, this.maxEditingTokenDuration));
            }
            object2 = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE);
            List list = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv2), (Comparator)((Comparator)new readByParentIds$lambda$14$$inlined$compareBy$1((Comparator)object2)));
            object.put(collection, list);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ArticleId> readAllIds() {
        void $this$mapNotNullTo$iv$iv;
        List list = this.articleRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAll(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ArticleId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Article it = (Article)element$iv$iv;
            boolean bl2 = false;
            if (it.getId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public Stream<ArticleId> streamAllIds() {
        return this.articleRepository.streamAllIds();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, Integer> countByWikiIds(@NotNull Set<WikiId> wikiIds) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Map countsByWiki = this.articleRepository.countByWikiIds(wikiIds);
        Iterable $this$associateWith$iv = wikiIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            WikiId wikiId = (WikiId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Integer n = (int)((Number)countsByWiki.getOrDefault(it, 0L)).longValue();
            map.put(t, n);
        }
        return MapsKt.toMap((Map)result$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public ArticleDto update(@NotNull ArticleId articleId, @Nullable String title, @Nullable String content, @Nullable String textContent, @NotNull ProfileId updater, @Nullable ProfileId contactPerson, boolean articleWasMoved) {
        Object object;
        String newTextContent;
        String string;
        String newTitle;
        String string2;
        String string3;
        Article article;
        boolean contentIsValidForUpdate;
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (title != null && StringsKt.isBlank((CharSequence)title)) {
            throw new EmptyArticleTitleException();
        }
        boolean bl = contentIsValidForUpdate = content == null && textContent == null || content != null && textContent != null;
        if (!contentIsValidForUpdate) {
            boolean $i$a$-require-ArticleService$update$22 = false;
            String $i$a$-require-ArticleService$update$22 = "You cannot save content without textContent or vice versa";
            throw new IllegalArgumentException($i$a$-require-ArticleService$update$22.toString());
        }
        if (content != null) {
            ProseMirrorContentParserKt.verifyAllHeadingsHaveUniqueIds((String)content);
        }
        if (!Intrinsics.areEqual((Object)contactPerson, (Object)(article = (Article)this.articleRepository.getReferenceById((Object)articleId)).getContactPerson())) {
            article.setContactPerson(contactPerson);
            this.articleRepository.save((Object)article);
        }
        ArticleVersion oldArticleVersion = this.getLatestArticleVersion(articleId);
        String string4 = title;
        if (string4 != null) {
            String it = string4;
            boolean bl2 = false;
            string3 = StringUtils.normalizeSpace((String)title);
        } else {
            string3 = string2 = null;
        }
        if (string3 == null) {
            string2 = newTitle = oldArticleVersion.getTitle();
        }
        if ((string = content) == null) {
            string = oldArticleVersion.getContent();
        }
        String newContent = string;
        String string5 = newTextContent = !Intrinsics.areEqual((Object)content, (Object)oldArticleVersion.getContent()) && textContent != null ? textContent : oldArticleVersion.getTextContent();
        if (Intrinsics.areEqual((Object)oldArticleVersion.getContent(), (Object)newContent) && Intrinsics.areEqual((Object)oldArticleVersion.getTitle(), (Object)newTitle) && !articleWasMoved) {
            Intrinsics.checkNotNull((Object)article);
            return ArticleDto.Companion.toDto(article, oldArticleVersion, this.clock, this.maxEditingTokenDuration);
        }
        ArticleVersion newArticleVersion = (ArticleVersion)this.articleVersionRepository.save((Object)new ArticleVersion(new ArticleVersionId(), articleId, newTitle, newContent, newTextContent, updater));
        Set oldDriveMediaIds = ProseMirrorContentParserKt.driveMediaIdsFromPMContent((String)oldArticleVersion.getContent());
        Set newDriveMediaIds = ProseMirrorContentParserKt.driveMediaIdsFromPMContent((String)newContent);
        Set driveMediaIdsToSave = SetsKt.minus((Set)newDriveMediaIds, (Iterable)oldDriveMediaIds);
        if (!((Collection)driveMediaIdsToSave).isEmpty()) {
            this.driveService.persistFiles(driveMediaIdsToSave, articleId, updater);
        }
        if (content != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.articleHeadingRepository.deleteAllByArticleId(articleId.getId());
            object = ProseMirrorContentParserKt.getHeadings((String)content);
            boolean $i$f$map = false;
            void var21_23 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void heading;
                ArticleHeadingInfo articleHeadingInfo = (ArticleHeadingInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(new ArticleHeading(heading.getId(), articleId, heading.getText(), heading.getSortOrder()));
            }
            List headings = (List)destination$iv$iv;
            this.articleHeadingRepository.saveAll((Iterable)headings);
        }
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Instant updatedAt = newArticleVersion.getUpdatedAt();
        if (updatedAt == null) {
            object = "Required value was null.";
            throw new IllegalStateException(object.toString());
        }
        this.ancestorService.updateEditedStatusForAncestors(IdUtilsKt.parentIdOf((UUID)article.getParentId(), (IdType)article.getParentType()), updatedAt, newArticleVersion.getModifiedBy());
        Intrinsics.checkNotNull((Object)article);
        Intrinsics.checkNotNull((Object)newArticleVersion);
        return ArticleDto.Companion.toDto(article, newArticleVersion, this.clock, this.maxEditingTokenDuration);
    }

    public static /* synthetic */ ArticleDto update$default(ArticleService articleService, ArticleId articleId, String string, String string2, String string3, ProfileId profileId, ProfileId profileId2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        return articleService.update(articleId, string, string2, string3, profileId, profileId2, bl);
    }

    @Transactional
    public void delete(@NotNull ArticleId articleId, @NotNull DeletionId deletionId, @NotNull ProfileId deletedBy) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Intrinsics.checkNotNullParameter((Object)deletedBy, (String)"deletedBy");
        Article article = (Article)this.articleRepository.getReferenceById((Object)articleId);
        UUID deletedArticleParentId = article.getParentId();
        IdType deletedArticleParentType = article.getParentType();
        this.articleRepository.deleteById((Object)articleId, deletionId);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        this.permissionService.removePermissionsForDeletedArticle(articleId);
        ParentId parentId = IdUtilsKt.parentIdOf((UUID)deletedArticleParentId, (IdType)deletedArticleParentType);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.ancestorService.updateEditedStatusForAncestors(parentId, instant, deletedBy);
    }

    @Transactional
    public void deleteByParentIds(@NotNull Set<? extends ParentId> parentIds, @NotNull DeletionId deletionId) {
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Set deletedArticles = this.articleRepository.deleteAllByParentIds(parentIds, deletionId);
        Iterable $this$forEach$iv = deletedArticles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArticleId it = (ArticleId)element$iv;
            boolean bl = false;
            this.permissionService.removePermissionsForDeletedArticle(it);
        }
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    public void deleteWikiArticles(@NotNull WikiId wikiId, @NotNull DeletionId deletionId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Set deletedArticles = this.articleRepository.deleteAllByWikiId(wikiId, deletionId);
        Iterable $this$forEach$iv = deletedArticles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Article it = (Article)element$iv;
            boolean bl = false;
            this.permissionService.removePermissionsForDeletedArticle(it.getId());
        }
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    public boolean updateEditingToken(@NotNull ArticleDto articleDto, @NotNull ProfileId updater) {
        boolean canUpdateToken;
        Intrinsics.checkNotNullParameter((Object)articleDto, (String)"articleDto");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        boolean bl = canUpdateToken = articleDto.getEditingStartedBy() == null || Intrinsics.areEqual((Object)articleDto.getEditingStartedBy(), (Object)updater);
        if (!canUpdateToken) {
            return false;
        }
        Instant now = Instant.ofEpochMilli(this.clock.millis());
        Article article = (Article)this.articleRepository.getReferenceById((Object)articleDto.getId());
        article.setEditingStartedAt(now);
        article.setEditingStartedBy(updater);
        this.articleRepository.save((Object)article);
        return true;
    }

    @Transactional
    public boolean deleteEditingToken(@NotNull ArticleDto articleDto, @NotNull ProfileId updater) {
        boolean canDeleteToken;
        Intrinsics.checkNotNullParameter((Object)articleDto, (String)"articleDto");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        boolean bl = canDeleteToken = articleDto.getEditingStartedBy() == null || Intrinsics.areEqual((Object)articleDto.getEditingStartedBy(), (Object)updater);
        if (!canDeleteToken) {
            return false;
        }
        Article article = (Article)this.articleRepository.getReferenceById((Object)articleDto.getId());
        article.setEditingStartedAt(null);
        article.setEditingStartedBy(null);
        this.articleRepository.save((Object)article);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void removeDeletedArticles(@NotNull Set<DeletionId> deletionIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(deletionIds, (String)"deletionIds");
        Iterable $this$map$iv = this.articleRepository.findAllByDeletionIds(deletionIds);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Article article = (Article)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set articlesToDelete = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.articleVersionRepository.deleteAllByArticleIds(articlesToDelete);
        this.articleRepository.deleteAllByDeletionIds(deletionIds);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void migrateArticlesHeaders() {
        do {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = new String[]{"id"};
            PageRequest pageRequest = PageRequest.of((int)0, (int)100, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])object));
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            List articlesToMigrateBatch = this.headingMigrationRepository.findByStatusIsPending((Pageable)pageRequest);
            object = articlesToMigrateBatch;
            ArticleVersionRepository articleVersionRepository = this.articleVersionRepository;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ArticleHeadingMigrationStatus articleHeadingMigrationStatus = (ArticleHeadingMigrationStatus)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getArticleId());
            }
            Map versions = articleVersionRepository.findLatestArticleVersionsByArticleIds(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
            for (ArticleHeadingMigrationStatus migration : articlesToMigrateBatch) {
                ArticleVersion version = (ArticleVersion)versions.get(migration.getArticleId());
                if (version == null) {
                    LOG.warn("Could not find article version for article '" + migration.getArticleId() + "'");
                    migration.setStatus(MigrationStatus.FAILED);
                    this.headingMigrationRepository.save((Object)migration);
                    continue;
                }
                ArticleHeadingMigrationStatus updatedMigration = this.migrateArticleHeaders$wiki_service(migration, version);
                this.headingMigrationRepository.save((Object)updatedMigration);
            }
            this.articleHeadingRepository.flush();
            this.headingMigrationRepository.flush();
            this.articleVersionRepository.flush();
        } while (!this.articlesHeadersFullyMigrated());
    }

    public boolean articlesHeadersFullyMigrated() {
        if (!articlesHeadersMigrationFinished) {
            articlesHeadersMigrationFinished = this.headingMigrationRepository.countByStatus(MigrationStatus.PENDING) == 0;
        }
        return articlesHeadersMigrationFinished;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public ArticleHeadingMigrationStatus migrateArticleHeaders$wiki_service(@NotNull ArticleHeadingMigrationStatus toMigrate, @NotNull ArticleVersion articleVersion) {
        Intrinsics.checkNotNullParameter((Object)toMigrate, (String)"toMigrate");
        Intrinsics.checkNotNullParameter((Object)articleVersion, (String)"articleVersion");
        String migratedContent = null;
        List headings = null;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            migratedContent = ProseMirrorContentParserKt.addIdsToHeadings((String)articleVersion.getContent());
            Iterable iterable = ProseMirrorContentParserKt.getHeadings((String)migratedContent);
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void heading;
                ArticleHeadingInfo articleHeadingInfo = (ArticleHeadingInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ArticleHeading(heading.getId(), articleVersion.getArticleId(), heading.getText(), heading.getSortOrder()));
            }
            headings = (List)destination$iv$iv;
        }
        catch (Exception e) {
            LOG.warn("Failed to migrate headings of article version '" + articleVersion.getId() + "'", (Throwable)e);
            toMigrate.setStatus(MigrationStatus.FAILED);
            return toMigrate;
        }
        articleVersion.setContent(migratedContent);
        this.articleHeadingRepository.saveAll((Iterable)headings);
        toMigrate.setStatus(MigrationStatus.MIGRATED);
        return toMigrate;
    }

    private static final ArticleVersionNotFoundException readArticleByVersionId$lambda$3(ArticleVersionId $versionId) {
        Intrinsics.checkNotNullParameter((Object)$versionId, (String)"$versionId");
        return new ArticleVersionNotFoundException($versionId);
    }

    private static final ArticleVersionDto readVersions$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ArticleVersionDto)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(ArticleService $this) {
        return $this.applicationEventPublisher;
    }

    public static final /* synthetic */ EntityManager access$getEntityManager$p(ArticleService $this) {
        return $this.entityManager;
    }
}

