/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.exceptions.ChapterNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.CircularyAncestryException;
import de.justsoftware.wikiservice.business.exceptions.ParentNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.WikiNotFoundException;
import de.justsoftware.wikiservice.business.model.Ancestor;
import de.justsoftware.wikiservice.business.model.AncestorDto;
import de.justsoftware.wikiservice.business.model.ChapterDto;
import de.justsoftware.wikiservice.business.model.ChapterNestingException;
import de.justsoftware.wikiservice.business.model.WikiDto;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.ArticleRepository;
import de.justsoftware.wikiservice.persistence.ChapterRepository;
import de.justsoftware.wikiservice.persistence.WikiRepository;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.Chapter;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import de.justsoftware.wikiservice.util.TransactionUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BA\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0012J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001d\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\"0$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0&H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010(\u001a\u00020\u001dH\u0016J(\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140$2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001d0&H\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020*0&2\u0006\u0010+\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0012J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00170&2\u0006\u0010+\u001a\u00020\"H\u0016J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u0017H\u0012J\u0010\u0010/\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u0010\u00100\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\"\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002020$2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001d0&H\u0012J\"\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\b\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u00108\u001a\u000209H\u0017J\"\u0010:\u001a\u0002052\u0006\u0010;\u001a\u00020<2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u00108\u001a\u000209H\u0017J \u0010=\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u000209H\u0017J&\u0010=\u001a\u00020\u00122\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0&2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u000209H\u0017J8\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002020$2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u000e\b\u0002\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00150BH\u0012J\u000e\u0010C\u001a\u0004\u0018\u00010\u001d*\u000202H\u0012J*\u0010D\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0&0E*\b\u0012\u0004\u0012\u00020\u001d0&H\u0012R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lde/justsoftware/wikiservice/business/AncestorService;", "", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "chapterRepository", "Lde/justsoftware/wikiservice/persistence/ChapterRepository;", "articleRepository", "Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "wikiRepository", "Lde/justsoftware/wikiservice/persistence/WikiRepository;", "maxChapterDepth", "", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/persistence/ChapterRepository;Lde/justsoftware/wikiservice/persistence/ArticleRepository;Lde/justsoftware/wikiservice/persistence/WikiRepository;ILde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;)V", "checkCircularAncestry", "", "parentAncestors", "", "Lde/justsoftware/wikiservice/business/model/AncestorDto;", "movedElement", "Lde/justsoftware/wikiservice/model/AbstractId;", "checkMaxNestingDepth", "parentChaptersNestingDepth", "childrenChaptersNestingDepth", "checkMaxNestingDepthOfNewChapter", "parentId", "Lde/justsoftware/wikiservice/model/ParentId;", "checkValidMove", "toParent", "checkValidMove$wiki_service", "getAncestorWikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "getAncestorWikiIds", "", "parentIds", "", "getAncestors", "firstAncestor", "getDescendantChapters", "Lde/justsoftware/wikiservice/persistence/model/Chapter;", "wikiId", "getDescendants", "getMaxChildrenChaptersNestingDepth", "childrenId", "getNextPositionForParent", "getPreviousPositionForParent", "loadAncestors", "Lde/justsoftware/wikiservice/business/model/Ancestor;", "firstAncestors", "moveArticle", "", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "updater", "Lde/justsoftware/wikiservice/model/ProfileId;", "moveChapter", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "updateEditedStatusForAncestors", "updatedAt", "Ljava/time/Instant;", "updatedBy", "ancestors", "", "getParentId", "groupByType", "Lkotlin/Pair;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nAncestorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AncestorService.kt\nde/justsoftware/wikiservice/business/AncestorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,438:1\n1179#2,2:439\n1253#2,4:441\n1855#2,2:445\n1549#2:447\n1620#2,3:448\n1549#2:451\n1620#2,3:452\n1549#2:455\n1620#2,3:456\n1271#2,2:459\n1285#2,4:461\n1179#2,2:465\n1253#2,4:467\n766#2:476\n857#2,2:477\n1238#2,4:481\n1855#2,2:485\n1549#2:487\n1620#2,3:488\n1549#2:491\n1620#2,3:492\n1549#2:495\n1620#2,3:496\n1549#2:499\n1620#2,3:500\n1855#2,2:503\n1549#2:505\n1620#2,3:506\n1747#2,3:509\n1603#2,9:518\n1855#2:527\n1856#2:529\n1612#2:530\n1603#2,9:537\n1855#2:546\n1856#2:548\n1612#2:549\n1603#2,9:556\n1855#2:565\n1856#2:567\n1612#2:568\n1603#2,9:575\n1855#2:584\n1856#2:586\n1612#2:587\n766#2:588\n857#2,2:589\n1549#2:591\n1620#2,3:592\n1#3:471\n1#3:528\n1#3:547\n1#3:566\n1#3:585\n125#4:472\n152#4,3:473\n76#4:512\n96#4,5:513\n76#4:531\n96#4,5:532\n76#4:550\n96#4,5:551\n76#4:569\n96#4,5:570\n453#5:479\n403#5:480\n*S KotlinDebug\n*F\n+ 1 AncestorService.kt\nde/justsoftware/wikiservice/business/AncestorService\n*L\n56#1:439,2\n56#1:441,4\n61#1:445,2\n67#1:447\n67#1:448,3\n74#1:451\n74#1:452,3\n76#1:455\n76#1:456,3\n86#1:459,2\n86#1:461,4\n119#1:465,2\n119#1:467,4\n124#1:476\n124#1:477,2\n132#1:481,4\n140#1:485,2\n166#1:487\n166#1:488,3\n204#1:491\n204#1:492,3\n209#1:495\n209#1:496,3\n212#1:499\n212#1:500,3\n219#1:503,2\n357#1:505\n357#1:506,3\n387#1:509,3\n397#1:518,9\n397#1:527\n397#1:529\n397#1:530\n402#1:537,9\n402#1:546\n402#1:548\n402#1:549\n412#1:556,9\n412#1:565\n412#1:567\n412#1:568\n417#1:575,9\n417#1:584\n417#1:586\n417#1:587\n430#1:588\n430#1:589,2\n432#1:591\n432#1:592,3\n397#1:528\n402#1:547\n412#1:566\n417#1:585\n123#1:472\n123#1:473,3\n396#1:512\n396#1:513,5\n401#1:531\n401#1:532,5\n411#1:550\n411#1:551,5\n416#1:569\n416#1:570,5\n132#1:479\n132#1:480\n*E\n"})
public class AncestorService {
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final ChapterRepository chapterRepository;
    @NotNull
    private final ArticleRepository articleRepository;
    @NotNull
    private final WikiRepository wikiRepository;
    private final int maxChapterDepth;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public AncestorService(@NotNull PermissionService permissionService, @NotNull ChapterRepository chapterRepository, @NotNull ArticleRepository articleRepository, @NotNull WikiRepository wikiRepository, @Value(value="${service.maxChapterNestingDepth:5}") int maxChapterDepth, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)chapterRepository, (String)"chapterRepository");
        Intrinsics.checkNotNullParameter((Object)articleRepository, (String)"articleRepository");
        Intrinsics.checkNotNullParameter((Object)wikiRepository, (String)"wikiRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.permissionService = permissionService;
        this.chapterRepository = chapterRepository;
        this.articleRepository = articleRepository;
        this.wikiRepository = wikiRepository;
        this.maxChapterDepth = maxChapterDepth;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @NotNull
    public WikiId getAncestorWikiId(@NotNull ParentId parentId) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        WikiId wikiId = (WikiId)this.getAncestorWikiIds(SetsKt.setOf((Object)parentId)).get(parentId);
        if (wikiId == null) {
            throw new WikiNotFoundException((WikiId)parentId);
        }
        return wikiId;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, WikiId> getAncestorWikiIds(@NotNull Set<? extends ParentId> parentIds) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        Map map;
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Pair pair = this.groupByType(parentIds);
        Set chapterIds = (Set)pair.component1();
        Set wikiIds = (Set)pair.component2();
        Iterable $this$associate$iv = ChapterRepository.findByIds$default((ChapterRepository)this.chapterRepository, (Set)chapterIds, null, (int)2, null);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            map = destination$iv$iv;
            Chapter it = (Chapter)element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to((Object)it.getId(), (Object)it.getWikiId());
            map.put(it.getFirst(), it.getSecond());
        }
        Map chapterAncestor = destination$iv$iv;
        Iterable $this$forEach$iv = chapterIds;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ChapterId it = (ChapterId)element$iv2;
            boolean bl = false;
            boolean bl2 = chapterAncestor.containsKey(it);
            if (!_Assertions.ENABLED || bl2) continue;
            boolean bl3 = false;
            throw new ChapterNotFoundException(it);
        }
        Iterable $this$map$iv = wikiIds;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void wikiId;
            map = (WikiId)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)wikiId, (String)"null cannot be cast to non-null type de.justsoftware.wikiservice.model.ParentId");
            object.add(TuplesKt.to((Object)((ParentId)wikiId), (Object)wikiId));
        }
        Map wikiAncestor = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        return MapsKt.plus((Map)wikiAncestor, (Map)chapterAncestor);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<AbstractId> getDescendants(@NotNull WikiId wikiId) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Iterable $this$map$iv = this.chapterRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Chapter chapter = (Chapter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set chapters = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = this.articleRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Article bl = (Article)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getId());
        }
        Set articles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        return SetsKt.plus((Set)chapters, (Iterable)articles);
    }

    @NotNull
    public List<AncestorDto> getAncestors(@NotNull ParentId firstAncestor) {
        Intrinsics.checkNotNullParameter((Object)firstAncestor, (String)"firstAncestor");
        return this.getAncestors(SetsKt.setOf((Object)firstAncestor)).getOrDefault(firstAncestor, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<AncestorDto>> getAncestors(@NotNull Set<? extends ParentId> firstAncestor) {
        Intrinsics.checkNotNullParameter(firstAncestor, (String)"firstAncestor");
        Map loadedAncestors = this.loadAncestors(firstAncestor);
        Iterable $this$associateWith$iv = firstAncestor;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            ParentId parentId = (ParentId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            List list = AncestorService.getAncestors$default((AncestorService)this, (Map)loadedAncestors, (ParentId)it, null, (int)2, null);
            map.put(t, list);
        }
        return result$iv;
    }

    private List<AncestorDto> getAncestors(Map<ParentId, ? extends Ancestor> $this$getAncestors, ParentId parentId, List<AncestorDto> ancestors) {
        ParentId ancestorId = parentId;
        while (ancestorId != null) {
            Ancestor ancestor;
            if ($this$getAncestors.get(ancestorId) == null) {
                throw new ParentNotFoundException(ancestorId);
            }
            ancestors.add(0, new AncestorDto(ancestor.getId(), ancestor.getTitle()));
            ancestorId = this.getParentId(ancestor);
        }
        return ancestors;
    }

    static /* synthetic */ List getAncestors$default(AncestorService ancestorService, Map map, ParentId parentId, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAncestors");
        }
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        return ancestorService.getAncestors(map, parentId, list);
    }

    private ParentId getParentId(Ancestor $this$getParentId) {
        return $this$getParentId instanceof ChapterDto ? ((ChapterDto)$this$getParentId).getParentId() : null;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ParentId, Ancestor> loadAncestors(Set<? extends ParentId> firstAncestors) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object;
        Map.Entry entry;
        Set wikiIds;
        Object object2;
        if (firstAncestors.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map loadedAncestors = new LinkedHashMap();
        Set parentWikiIds = new LinkedHashSet();
        Set nextParentIds = firstAncestors;
        while (!((Collection)nextParentIds).isEmpty()) {
            Set set;
            object2 = this.groupByType(nextParentIds);
            Set chapterIds = (Set)object2.component1();
            wikiIds = (Set)object2.component2();
            parentWikiIds.addAll(wikiIds);
            if (chapterIds.isEmpty()) {
                set = SetsKt.emptySet();
            } else {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                ParentId it;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                void $this$associateTo$iv$iv;
                Map $this$associate$iv;
                Iterable iterable = ChapterRepository.findByIds$default((ChapterRepository)this.chapterRepository, (Set)chapterIds, null, (int)2, null);
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associate$iv), (int)10)), (int)16);
                void var11_14 = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    Chapter it2 = (Chapter)element$iv$iv;
                    boolean bl = false;
                    entry = TuplesKt.to((Object)it2.getId(), (Object)ChapterDto.Companion.toChapterDto(it2));
                    map.put(entry.getFirst(), entry.getSecond());
                }
                Map it3 = $this$associate$iv = destination$iv$iv;
                boolean $i$a$-also-AncestorService$loadAncestors$32 = false;
                loadedAncestors.putAll(it3);
                boolean $i$f$map = false;
                void $i$a$-also-AncestorService$loadAncestors$32 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                    Object element$iv$iv;
                    element$iv$iv = item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl = false;
                    object.add(((ChapterDto)it.getValue()).getParentId());
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Map.Entry element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ParentId)element$iv$iv;
                    boolean bl = false;
                    if (!(!loadedAncestors.containsKey(it))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            }
            nextParentIds = set;
        }
        object2 = this.wikiRepository.findByIds(parentWikiIds);
        object = loadedAncestors;
        boolean $i$f$mapValues = false;
        wikiIds = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry element$iv$iv;
            element$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl2 = false;
            Wiki wiki = (Wiki)entry.getValue();
            WikiDto wikiDto = WikiDto.Companion.toDto(wiki);
            map2.put(k, wikiDto);
        }
        object.putAll(destination$iv$iv);
        return loadedAncestors;
    }

    private Pair<Set<ChapterId>, Set<WikiId>> groupByType(Set<? extends ParentId> $this$groupByType) {
        Set chapterIds = new LinkedHashSet();
        Set wikiIds = new LinkedHashSet();
        Iterable $this$forEach$iv = $this$groupByType;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParentId it = (ParentId)element$iv;
            boolean bl = false;
            ParentId parentId = it;
            if (parentId instanceof WikiId) {
                wikiIds.add(it);
                continue;
            }
            if (parentId instanceof ChapterId) {
                chapterIds.add(it);
                continue;
            }
            throw new IllegalArgumentException("Unsupported parent type: " + it.type());
        }
        return new Pair((Object)chapterIds, (Object)wikiIds);
    }

    @Transactional
    public void updateEditedStatusForAncestors(@NotNull ParentId parentId, @NotNull Instant updatedAt, @NotNull ProfileId updatedBy) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Intrinsics.checkNotNullParameter((Object)updatedBy, (String)"updatedBy");
        this.updateEditedStatusForAncestors(SetsKt.setOf((Object)parentId), updatedAt, updatedBy);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void updateEditedStatusForAncestors(@NotNull Set<? extends ParentId> parentIds, @NotNull Instant updatedAt, @NotNull ProfileId updatedBy) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Intrinsics.checkNotNullParameter((Object)updatedBy, (String)"updatedBy");
        Iterable iterable = CollectionsKt.flatten((Iterable)this.getAncestors(parentIds).values());
        AncestorService ancestorService = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AncestorDto ancestorDto = (AncestorDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Pair pair = ancestorService.groupByType(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Set parentChaptersIds = (Set)pair.component1();
        Set parentWikiIds = (Set)pair.component2();
        WikiId parentWikiId = (WikiId)CollectionsKt.first((Iterable)parentWikiIds);
        this.chapterRepository.setUpdatedStatus(parentChaptersIds, updatedBy, updatedAt);
        this.wikiRepository.setUpdatedStatus(parentWikiId, updatedBy, updatedAt);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public boolean moveChapter(@NotNull ChapterId chapterId, @Nullable ParentId toParent, @NotNull ProfileId updater) {
        List updatedChapters;
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Chapter chapter = (Chapter)this.chapterRepository.getReferenceById((Object)chapterId);
        Intrinsics.checkNotNull((Object)chapter);
        ParentId oldParentId = Chapter.Companion.getParent(chapter);
        if (toParent == null || Intrinsics.areEqual((Object)toParent.getId(), (Object)chapter.getParentId()) && toParent.type() == chapter.getParentType()) {
            return false;
        }
        this.checkValidMove$wiki_service(toParent, (AbstractId)chapter.getId());
        WikiId toWikiId = this.getAncestorWikiId(toParent);
        Set chaptersToUpdate = new LinkedHashSet();
        if (!Intrinsics.areEqual((Object)toWikiId, (Object)chapter.getWikiId())) {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            Collection collection;
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv = this.getDescendantChapters(chapter.getWikiId(), (ParentId)chapterId);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void childChapter;
                void var18_29;
                Chapter chapter2 = (Chapter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void $this$moveChapter_u24lambda_u2415_u24lambda_u2414 = var18_29 = childChapter;
                boolean bl2 = false;
                $this$moveChapter_u24lambda_u2415_u24lambda_u2414.setWikiId(toWikiId);
                collection.add(var18_29);
            }
            updatedChapters = (List)destination$iv$iv;
            chaptersToUpdate.addAll(updatedChapters);
            Iterable $this$map$iv2 = updatedChapters;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Chapter bl = (Chapter)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(it.getId());
            }
            Set parentIds = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)), (Iterable)SetsKt.setOf((Object)chapterId));
            Iterable $this$map$iv3 = CollectionsKt.flatten((Iterable)this.articleRepository.findByParentIds(parentIds).values());
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void article;
                void var20_35;
                Article bl3 = (Article)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                void $this$moveChapter_u24lambda_u2418_u24lambda_u2417 = var20_35 = article;
                boolean bl4 = false;
                $this$moveChapter_u24lambda_u2418_u24lambda_u2417.setWikiId(toWikiId);
                collection.add(var20_35);
            }
            List updatedArticles = (List)destination$iv$iv3;
            if (!((Collection)updatedArticles).isEmpty()) {
                this.articleRepository.saveAll((Iterable)updatedArticles);
                Iterable $this$forEach$iv = updatedArticles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Article it = (Article)element$iv;
                    boolean bl = false;
                    this.permissionService.removePermissionsForDeletedArticle(it.getId());
                    this.permissionService.addPermissionItemForNewArticle(it.getId(), toWikiId);
                }
                this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
            }
            chapter.setWikiId(toWikiId);
            chapter.setRelativePosition(Integer.valueOf(this.getPreviousPositionForParent(toParent)));
        } else {
            chapter.setRelativePosition(Integer.valueOf(this.getNextPositionForParent(toParent)));
        }
        chapter.setParentId(toParent.getId());
        chapter.setParentType(toParent.type());
        chaptersToUpdate.add(chapter);
        updatedChapters = this.chapterRepository.saveAll((Iterable)chaptersToUpdate);
        Intrinsics.checkNotNull((Object)updatedChapters);
        Instant instant = ((Chapter)CollectionsKt.last((List)updatedChapters)).getUpdatedAt();
        if (instant == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Instant updatedAt = instant;
        this.updateEditedStatusForAncestors(oldParentId, updatedAt, updater);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return true;
    }

    @Transactional
    public boolean moveArticle(@NotNull ArticleId articleId, @Nullable ParentId toParent, @NotNull ProfileId updater) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Article article = (Article)this.articleRepository.getReferenceById((Object)articleId);
        Intrinsics.checkNotNull((Object)article);
        ParentId oldParentId = Article.Companion.getParent(article);
        if (toParent == null || Intrinsics.areEqual((Object)toParent.getId(), (Object)article.getParentId()) && toParent.type() == article.getParentType()) {
            return false;
        }
        this.checkValidMove$wiki_service(toParent, (AbstractId)article.getId());
        WikiId $this$moveArticle_u24lambda_u2420 = this.getAncestorWikiId(toParent);
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)$this$moveArticle_u24lambda_u2420, (Object)article.getWikiId())) {
            article.setWikiId($this$moveArticle_u24lambda_u2420);
            article.setRelativePosition(Integer.valueOf(this.getPreviousPositionForParent(toParent)));
            this.permissionService.removePermissionsForDeletedArticle(articleId);
            this.permissionService.addPermissionItemForNewArticle(articleId, (WikiId)toParent);
        } else {
            article.setRelativePosition(Integer.valueOf(this.getNextPositionForParent(toParent)));
        }
        article.setParentId(toParent.getId());
        article.setParentType(toParent.type());
        Article updatedArticle = (Article)this.articleRepository.save((Object)article);
        Instant instant = updatedArticle.getUpdatedAt();
        if (instant == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Instant updatedAt = instant;
        this.updateEditedStatusForAncestors(oldParentId, updatedAt, updater);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return true;
    }

    public void checkValidMove$wiki_service(@NotNull ParentId toParent, @NotNull AbstractId movedElement) {
        Intrinsics.checkNotNullParameter((Object)toParent, (String)"toParent");
        Intrinsics.checkNotNullParameter((Object)movedElement, (String)"movedElement");
        ParentId parentId = toParent;
        if (parentId instanceof ChapterId) {
            if (!this.chapterRepository.existsById((Object)toParent)) {
                throw new ChapterNotFoundException((ChapterId)toParent);
            }
            if (movedElement.type() == IdType.WIKI_CHAPTER) {
                List parentAncestors = this.getAncestors(toParent);
                int parentChaptersNestingDepth = parentAncestors.size() - 1;
                int childrenChaptersNestingDepth = this.getMaxChildrenChaptersNestingDepth(movedElement);
                this.checkMaxNestingDepth(parentChaptersNestingDepth, childrenChaptersNestingDepth);
                this.checkCircularAncestry(parentAncestors, movedElement);
            }
        } else if (parentId instanceof WikiId) {
            if (!this.wikiRepository.existsById((Object)toParent)) {
                throw new WikiNotFoundException((WikiId)toParent);
            }
        } else {
            throw new IllegalArgumentException(toParent.type() + " is not a known parent type");
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getMaxChildrenChaptersNestingDepth(AbstractId childrenId) {
        int n;
        if (childrenId instanceof ParentId) {
            void var2_2;
            int depth = 0;
            Set nextParentIds = SetsKt.setOf((Object)childrenId);
            while (!((Collection)nextParentIds).isEmpty()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map children = ChapterRepository.findByParentIds$default((ChapterRepository)this.chapterRepository, (Set)nextParentIds, null, (int)2, null);
                Iterable iterable = CollectionsKt.flatten((Iterable)children.values());
                boolean $i$f$map = false;
                void var7_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Chapter chapter = (Chapter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ParentId parentId = (ParentId)it.getId();
                    if (parentId == null) {
                        throw new ParentNotFoundException(null, 1, null);
                    }
                    collection.add(parentId);
                }
                nextParentIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                ++depth;
            }
            n = var2_2;
        } else {
            n = 0;
        }
        return n;
    }

    public void checkMaxNestingDepthOfNewChapter(@NotNull ParentId parentId) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        int parentChaptersNestingDepth = this.getAncestors(parentId).size() - 1;
        this.checkMaxNestingDepth(parentChaptersNestingDepth, 1);
    }

    private void checkMaxNestingDepth(int parentChaptersNestingDepth, int childrenChaptersNestingDepth) {
        if (parentChaptersNestingDepth + childrenChaptersNestingDepth > this.maxChapterDepth) {
            throw new ChapterNestingException("Maximum chapter nesting level " + this.maxChapterDepth + " reached");
        }
    }

    private void checkCircularAncestry(List<AncestorDto> parentAncestors, AbstractId movedElement) {
        boolean hasCircularAncestry;
        block4: {
            Iterable $this$any$iv = parentAncestors;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AncestorDto it = (AncestorDto)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)movedElement)) continue;
                    v0 = true;
                    break block4;
                }
                v0 = hasCircularAncestry = false;
            }
        }
        if (hasCircularAncestry) {
            throw new CircularyAncestryException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public int getNextPositionForParent(@NotNull ParentId parentId) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Map map = this.chapterRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap = false;
        void var6_5 = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            list$iv$iv = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        boolean $i$f$mapNotNull22 = false;
        $this$flatMapTo$iv$iv2 = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach22 = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            Chapter it = (Chapter)element$iv$iv;
            boolean bl2 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        int chapterPositionMax = n != null ? n : -1;
        Map $i$f$mapNotNull22 = this.articleRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        Iterator $i$f$forEach22 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while ($i$f$forEach22.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = $i$f$forEach22.next();
            boolean bl = false;
            Iterable list$iv$iv2 = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Article it = (Article)element$iv$iv;
            boolean bl4 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Integer n2 = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
        int articlePositionMax = n2 != null ? n2 : -1;
        return Math.max(chapterPositionMax, articlePositionMax) + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public int getPreviousPositionForParent(@NotNull ParentId parentId) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Map map = this.chapterRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap = false;
        void var6_5 = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            list$iv$iv = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        boolean $i$f$mapNotNull22 = false;
        $this$flatMapTo$iv$iv2 = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach22 = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            Chapter it = (Chapter)element$iv$iv;
            boolean bl2 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Integer n = (Integer)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
        int chapterPositionMin = n != null ? n : 0;
        Map $i$f$mapNotNull22 = this.articleRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        Iterator $i$f$forEach22 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while ($i$f$forEach22.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = $i$f$forEach22.next();
            boolean bl = false;
            Iterable list$iv$iv2 = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Article it = (Article)element$iv$iv;
            boolean bl4 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Integer n2 = (Integer)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv2));
        int articlePositionMin = n2 != null ? n2 : 0;
        return Math.min(chapterPositionMin, articlePositionMin) - 1;
    }

    /*
     * WARNING - void declaration
     */
    private Set<Chapter> getDescendantChapters(WikiId wikiId, ParentId parentId) {
        Set allChapters = this.chapterRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId);
        Set result = new LinkedHashSet();
        Set nextParentIds = null;
        nextParentIds = SetsKt.setOf((Object)parentId.getId());
        while (!((Collection)nextParentIds).isEmpty()) {
            void $this$mapTo$iv$iv;
            Chapter it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = allChapters;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Chapter)element$iv$iv;
                boolean bl = false;
                if (!nextParentIds.contains(it.getParentId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List children = (List)destination$iv$iv;
            result.addAll(children);
            Iterable $this$map$iv = children;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Chapter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId().getId());
            }
            nextParentIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        return result;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(AncestorService $this) {
        return $this.applicationEventPublisher;
    }
}

