/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.SubscriptionApplicationService;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.model.SubscriptionDto;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J*\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;", "", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "(Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/authorization/AuthorizationService;)V", "read", "Lde/justsoftware/wikiservice/business/model/SubscriptionDto;", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "", "Lde/justsoftware/wikiservice/model/WikiId;", "wikiIds", "", "setSubscription", "itemId", "Lde/justsoftware/wikiservice/model/ItemId;", "isSubscribed", "", "wiki-service"})
public class SubscriptionApplicationService {
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final AuthorizationService authorizationService;

    @Autowired
    public SubscriptionApplicationService(@NotNull SubscriptionService subscriptionService, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.subscriptionService = subscriptionService;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.authorizationService = authorizationService;
    }

    @NotNull
    public Map<WikiId, SubscriptionDto> read(@NotNull List<WikiId> wikiIds, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set userRoles = this.authorizationService.getUserRoles(authContext.getUser());
        return this.subscriptionService.readWikis(CollectionsKt.toSet((Iterable)wikiIds), authContext.getUser(), userRoles);
    }

    @NotNull
    public SubscriptionDto read(@NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.chapterService.read(chapterId).getWikiId();
        authContext.checkReadWiki(wikiId);
        return this.subscriptionService.readChapter(chapterId, authContext.getUser());
    }

    @NotNull
    public SubscriptionDto read(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.articleService.read(articleId).getWikiId();
        authContext.checkReadWiki(wikiId);
        return this.subscriptionService.readArticle(articleId, authContext.getUser());
    }

    @NotNull
    public SubscriptionDto setSubscription(@NotNull ItemId itemId, boolean isSubscribed, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        switch (WhenMappings.$EnumSwitchMapping$0[itemId.type().ordinal()]) {
            case 1: {
                authContext.checkReadWiki((WikiId)itemId);
                break;
            }
            case 2: {
                WikiId wikiId = this.chapterService.read((ChapterId)itemId).getWikiId();
                authContext.checkReadWiki(wikiId);
                break;
            }
            case 3: {
                WikiId wikiId = this.articleService.read((ArticleId)itemId).getWikiId();
                authContext.checkReadWiki(wikiId);
                break;
            }
            default: {
                throw new RuntimeException("Cannot subscribe to " + itemId);
            }
        }
        return this.subscriptionService.setSubscription(itemId, authContext.getUser(), isSubscribed);
    }
}

