function rewriteLinks(basePath) {
    'use strict';
    var forEach = Array.prototype.forEach;

    forEach.call(document.getElementsByClassName('userGeneratedHTML'), function (editorElement) {
        forEach.call(editorElement.getElementsByTagName('a'), function (a) {
            if (a.href) {
                rewriteLink(a);
            }
        });
    });

    function rewriteLink(a) {
        if (a.hash && a.host === window.location.host && a.path === window.location.path) {
            if (a.hash.indexOf('#.') !== 0) {
                // internal platform link: fix path
                a.setAttribute('href', basePath + a.hash);
            }
        } else if (a.target !== '_blank') {
            // external link: add target="_blank"
            a.setAttribute('target','_blank');
        }
    }
}

