/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.presentation.client.ui.views;

import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.WaitSpinner;
import de.justsoftware.onx.survey.presentation.client.ui.views.SurveyListView;
import de.justsoftware.onx.survey.presentation.client.ui.views.SurveyTeaserView;
import de.justsoftware.onx.survey.shared.i18n.SurveyConstants;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SurveyListViewImpl
extends Composite
implements SurveyListView {
    private final FlowPanel _container = new FlowPanel();
    private final FlowPanel _teaserList = new FlowPanel();
    private final FlowPanel _pager = new FlowPanel();
    private final FlowPanel _addButtonPanel = new FlowPanel();
    private final Label _noSurveysLabel = new Label();
    private final FlowPanel _waitOverlay = new FlowPanel();
    private final SurveyListView.Presenter _presenter;
    private final IconAnchor _previous = new IconAnchor();
    private final IconAnchor _next = new IconAnchor();

    public SurveyListViewImpl(SurveyListView.Presenter presenter, SurveyConstants surveyConstants) {
        this._presenter = presenter;
        WaitSpinner icon = new WaitSpinner();
        icon.setSize(IconSize.FOUR_TIMES);
        this._waitOverlay.add((Widget)icon);
        this._waitOverlay.addStyleName("wait-overlay");
        this._waitOverlay.setVisible(false);
        this._container.addStyleName("entity-tab-surveys");
        this._container.add((Widget)this._waitOverlay);
        this._container.add((Widget)this._teaserList);
        this._container.add((Widget)this._pager);
        this._noSurveysLabel.setText(surveyConstants.noSurveysAvailable());
        this._container.add((Widget)this._noSurveysLabel);
        this._addButtonPanel.addStyleName("survey-create-button-panel");
        JCButton addButton = new JCButton(surveyConstants.addNewSurvey());
        addButton.setTargetHistoryToken(this._presenter.getCreateNewSurveyTargetHistoryToken());
        this._addButtonPanel.add((Widget)addButton);
        this._addButtonPanel.setVisible(false);
        this._container.add((Widget)this._addButtonPanel);
        this._pager.addStyleName("pager");
        this._previous.setEnabled(false);
        this._previous.setIcon(IconType.CHEVRON_LEFT);
        this._previous.addClickHandler(e -> this._presenter.previousPage());
        this._pager.add((Widget)this._previous);
        this._next.setEnabled(false);
        this._next.setIcon(IconType.CHEVRON_RIGHT);
        this._next.addClickHandler(e -> this._presenter.nextPage());
        this._pager.add((Widget)this._next);
        this.initWidget((Widget)this._container);
    }

    public void addSurvey(SurveyTeaserView teaserView) {
        this._teaserList.add(teaserView.asWidget());
    }

    public void showError(String message) {
        this._teaserList.clear();
        this._teaserList.add((Widget)new Label(message));
    }

    public void setWaitIndicatorVisibility(boolean visible) {
        this._waitOverlay.setVisible(visible);
    }

    public void clear() {
        this._teaserList.clear();
    }

    public void setNextButtonEnabled(boolean enabled) {
        this._next.setActive(enabled);
        this._next.setEnabled(enabled);
    }

    public void setPreviousButtonEnabled(boolean enabled) {
        this._previous.setActive(enabled);
        this._previous.setEnabled(enabled);
    }

    public void setPagerVisible(boolean visible) {
        this._pager.setVisible(visible);
    }

    public void setNoSurveysLabelVisible(boolean visible) {
        this._noSurveysLabel.setVisible(visible);
    }

    public void setAddButtonVisible(boolean visible) {
        this._addButtonPanel.setVisible(visible);
    }
}

