/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.upload;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.freiheit.toro.server.upload.AbstractImageUploadServlet;
import com.freiheit.toro.server.upload.JsonUploadResult;
import com.freiheit.toro.server.upload.UploadResult;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.server.upload.AlbumImageUploadHelper;
import de.justsoftware.onx.server.upload.UploadedImageInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@ParametersAreNonnullByDefault
public class AlbumImageUploadServlet
extends AbstractImageUploadServlet {
    private final AlbumImageUploadHelper _albumImageUploadHelper;

    @Autowired
    @ParametersAreNonnullByDefault
    public AlbumImageUploadServlet(Settings settings, StorageServerHelper storageServerHelper, SessionAuthorizationContextProvider authorizationContextProvider, @Qualifier(value="acceptableImageUploadTypes") Set<String> types, AlbumImageUploadHelper albumImageUploadHelper, I18nService i18nService) {
        super(settings, storageServerHelper, authorizationContextProvider, i18nService, types);
        this._albumImageUploadHelper = albumImageUploadHelper;
    }

    @RequestMapping(value={"/upload/mdlalbum"})
    public ModelAndView handleRequest(MultipartHttpServletRequest request, HttpServletResponse response) throws IOException {
        return super.handleRequest(request, response);
    }

    protected UploadResult saves(List<MultipartFile> files, AuthorizationCheckContextWithUserId authCtx, HashMap<String, String> parameters) {
        try {
            String sAlbumId = parameters.get("albumId");
            AlbumId albumId = sAlbumId == null ? null : new AlbumId(Long.parseLong(sAlbumId));
            String sParentId = parameters.get("parentId");
            String sParentType = parameters.get("parentType");
            GlobalId parentId = sParentId == null || sParentType == null ? null : GlobalId.create((long)Long.parseLong(sParentId), (ItemType)ItemType.valueOf((String)sParentType));
            boolean notifyOthers = "on".equalsIgnoreCase(StringUtils.trimToNull((String)parameters.get("notifyOthers")));
            ImmutableList infos = albumId == null ? this._albumImageUploadHelper.saveImagesToWorkstream(files, authCtx, parentId) : this._albumImageUploadHelper.saveImagesToAlbum(files, authCtx, albumId, notifyOthers);
            JSONObject result = new JSONObject();
            for (UploadedImageInfo i : infos) {
                try {
                    JSONObject image = new JSONObject();
                    AlbumImageId id = i.getId();
                    if (id != null) {
                        image.put("id", (Object)id.toString());
                    }
                    image.put("filename", (Object)i.getFilename());
                    image.put("originalFilename", (Object)i.getOriginalFilename());
                    image.put("width", i.getWidth());
                    image.put("height", i.getHeight());
                    result.append("images", (Object)image);
                }
                catch (JSONException jSONException) {}
            }
            return JsonUploadResult.success((JSONObject)result);
        }
        catch (PermissionDeniedException e) {
            return JsonUploadResult.error((String)((BasicConstants)this._i18nService.createProxy(BasicConstants.class, authCtx.getLocale())).noPermission());
        }
        catch (ServiceException e) {
            return JsonUploadResult.error((String)e.toString());
        }
        catch (InvalidIDException e) {
            return JsonUploadResult.error((String)"Fail! Parent ID provided is not valid.");
        }
    }

    protected UploadResult returnError(HttpServletRequest request, String message) {
        return JsonUploadResult.error((String)message);
    }
}

