/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.HTMLUtil;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.ClientRelativeDateUtil;
import de.justsoftware.onx.common.shared.model.BadgeField;
import de.justsoftware.onx.common.shared.model.BadgeFieldType;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.presentation.client.EntityUtils;
import de.justsoftware.onx.container.presentation.client.ui.EntityLogoCreator;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.drive.presentation.client.DriveClientFactory;
import de.justsoftware.onx.person.presentation.client.ProfileFieldNameTranslator;
import de.justsoftware.onx.searchnew.presentation.client.ui.SuggestTeaserMarkupVisitor;
import de.justsoftware.onx.searchnew.shared.model.ArticleSuggest;
import de.justsoftware.onx.searchnew.shared.model.ChapterSuggest;
import de.justsoftware.onx.searchnew.shared.model.ChatSuggest;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentSuggest;
import de.justsoftware.onx.searchnew.shared.model.EntitySuggest;
import de.justsoftware.onx.searchnew.shared.model.HasExpirationDate;
import de.justsoftware.onx.searchnew.shared.model.NewsChannelSuggest;
import de.justsoftware.onx.searchnew.shared.model.NewsPostSuggest;
import de.justsoftware.onx.searchnew.shared.model.PersonSuggest;
import de.justsoftware.onx.searchnew.shared.model.SearchSuggestModelVisitor;
import de.justsoftware.onx.searchnew.shared.model.WikiSuggest;
import de.justsoftware.onx.searchnew.shared.model.WorkstreamSuggest;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public enum SuggestTeaserMarkupVisitor implements SearchSuggestModelVisitor<String>
{
    INSTANCE;

    private static final SuggestTeaserTemplates TEASER_TEMPLATES;
    private static final Function<EntityInfo, SafeHtml> LINK_TO_ENTITY;
    private static final Function<SafeHtml, String> AS_STRING;

    public String visitEntity(EntitySuggest entity) {
        SafeHtml logo = SuggestTeaserMarkupVisitor.createEntityLogo((EntitySuggest)entity);
        SafeHtml experationIcon = SuggestTeaserMarkupVisitor.createArchivedIcon((HasExpirationDate)entity);
        Date modifyDate = entity.getModifyDate();
        String formatedDate = modifyDate != null ? ClientRelativeDateUtil.INSTANCE.getRelativeTime(modifyDate) : "modify date is null, should not happen, see JUST-15719";
        EntityType entityType = entity.getEntityType();
        String entityTypeName = I18nMediator.getEntityConstantsByEntityType((EntityType)entityType).entity(entityType);
        SafeHtml parentEntities = SuggestTeaserMarkupVisitor.parentEntities((ImmutableList)entity.getLinkedEntities());
        String subtitle = entity.getLinkedEntities().isEmpty() ? I18nMediator.SEARCH_MESSAGES.xModifiedAtY(SafeHtmlUtils.htmlEscape((String)entityTypeName), SafeHtmlUtils.htmlEscape((String)formatedDate)) : I18nMediator.SEARCH_MESSAGES.xInYModifedAtZ(SafeHtmlUtils.htmlEscape((String)entityTypeName), parentEntities.asString(), SafeHtmlUtils.htmlEscape((String)formatedDate));
        String validationMessage = entity.getValidationMessage();
        SafeHtml name = SafeHtmlUtils.fromSafeConstant((String)(EntityUtils.getStartAtNamePrefix((EntityType)((EntityType)entity.getType()), (Date)entity.getStartAt(), (Date)entity.getEndAt()) + HTMLUtil.highlightedHtmlEscape((String)entity.getHtmlHighlightedName()).asString()));
        SafeHtml title = ClientStringUtil.hasText((String)validationMessage) ? TEASER_TEMPLATES.titleWithError(experationIcon, name, SafeHtmlUtils.fromTrustedString((String)subtitle), validationMessage) : TEASER_TEMPLATES.title(experationIcon, name, SafeHtmlUtils.fromTrustedString((String)subtitle));
        return TEASER_TEMPLATES.item("entity", logo, title).asString();
    }

    @Nonnull
    private static SafeHtml createEntityLogo(EntitySuggest entity) {
        Widget logoWidget = EntityLogoCreator.DEFAULT.create(entity, false);
        if (logoWidget != null) {
            logoWidget.addStyleName("suggest-item-logo");
            return SafeHtmlUtils.fromSafeConstant((String)logoWidget.toString());
        }
        return SafeHtmlUtils.fromSafeConstant((String)"");
    }

    @Nonnull
    private static SafeHtml parentEntities(ImmutableList<EntityInfo> linkedEntities) {
        return SafeHtmlUtils.fromTrustedString((String)Joiner.on((String)", ").join((Iterable)FluentIterable.from(linkedEntities).transform(LINK_TO_ENTITY).transform(AS_STRING)));
    }

    @Nonnull
    private static SafeHtml createArchivedIcon(HasExpirationDate teaser) {
        Date archiveDate = teaser.getArchivedDate();
        return archiveDate != null ? TEASER_TEMPLATES.iconWithTooltip(EntityUtils.createArchivedTooltip((Date)archiveDate), "hdd") : SafeHtmlUtils.EMPTY_SAFE_HTML;
    }

    public String visitPerson(PersonSuggest person) {
        SafeHtml logo = TEASER_TEMPLATES.icon(UriUtils.fromTrustedString((String)ImageUrlUtil.getFullSmallUserImageUrl((String)person.getLogo())), person.getName());
        String personName = PersonUtil.getAnnotatedName((String)person.getHtmlHighlightedName(), (boolean)person.isBlocked(), (boolean)person.isActive());
        SafeHtml title = TEASER_TEMPLATES.title(SafeHtmlUtils.EMPTY_SAFE_HTML, HTMLUtil.highlightedHtmlEscape((String)personName));
        SafeHtml addionalData = this.createAdditionalData(person);
        return TEASER_TEMPLATES.itemWithAdditionalData("person", logo, title, addionalData).asString();
    }

    @Nonnull
    private SafeHtml createAdditionalData(PersonSuggest person) {
        StringBuilder builder = new StringBuilder();
        ImmutableList dynamicProfileFields = this.translateBadgeFields(person.getVisibleFields());
        for (BadgeField field : dynamicProfileFields) {
            if (StringUtil.isEmpty((String)field.getName())) continue;
            builder.append(TEASER_TEMPLATES.attribute(field.getName(), SafeHtmlUtils.fromString((String)field.getContent())).asString());
        }
        String personFields = builder.toString();
        return Strings.isNullOrEmpty((String)personFields) ? SafeHtmlUtils.EMPTY_SAFE_HTML : TEASER_TEMPLATES.additionalData(SafeHtmlUtils.fromSafeConstant((String)personFields));
    }

    @Nonnull
    private ImmutableList<BadgeField> translateBadgeFields(ImmutableList<BadgeField> attributes) {
        ImmutableList translatedValues = ProfileFieldNameTranslator.INSTANCE.translateValues(attributes);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BadgeField bf : translatedValues) {
            builder.add((Object)new BadgeField(ProfileFieldNameTranslator.INSTANCE.resolveFieldName(bf), BadgeFieldType.VALUES, bf.getContentList()));
        }
        return builder.build();
    }

    @Nonnull
    public String visitWorkstream(WorkstreamSuggest workstream) {
        SafeHtml logo = TEASER_TEMPLATES.workstreamIcon(workstream.getName());
        SafeHtml title = TEASER_TEMPLATES.title(SafeHtmlUtils.EMPTY_SAFE_HTML, HTMLUtil.highlightedHtmlEscape((String)workstream.getHtmlHighlightedName()));
        return TEASER_TEMPLATES.item("workstream", logo, title).asString();
    }

    public String visitNewsPost(NewsPostSuggest suggest) {
        SafeHtml logo = TEASER_TEMPLATES.workstreamIcon(suggest.getName());
        SafeHtml title = TEASER_TEMPLATES.title(SafeHtmlUtils.EMPTY_SAFE_HTML, HTMLUtil.highlightedHtmlEscape((String)suggest.getHtmlHighlightedName()));
        return TEASER_TEMPLATES.item("workstream", logo, title).asString();
    }

    @CheckForNull
    public String visitNewsChannel(NewsChannelSuggest suggest) {
        SafeHtml logo = TEASER_TEMPLATES.channelIcon(suggest.getName());
        SafeHtml title = TEASER_TEMPLATES.title(SafeHtmlUtils.EMPTY_SAFE_HTML, HTMLUtil.highlightedHtmlEscape((String)suggest.getHtmlHighlightedName()));
        return TEASER_TEMPLATES.item("channel", logo, title).asString();
    }

    public String visitChat(ChatSuggest chat) {
        SafeHtml logo = TEASER_TEMPLATES.chatIcon(chat.getName());
        SafeHtml title = TEASER_TEMPLATES.title(SafeHtmlUtils.EMPTY_SAFE_HTML, HTMLUtil.highlightedHtmlEscape((String)chat.getHtmlHighlightedName()));
        return TEASER_TEMPLATES.item("chat", logo, title).asString();
    }

    public String visitDriveDocument(DriveDocumentSuggest driveDocument) {
        DriveClientFactory driveFactory = ClientFactoryImpl.INSTANCE.driveFactory();
        SafeHtml logo = driveDocument.getDocumentType() == DriveDocumentSearchResultBadgeModel.DocumentType.FILE ? TEASER_TEMPLATES.icon(UriUtils.fromString((String)driveFactory.getIconUrlForMimeType(driveDocument.getMimeType())), driveDocument.getName()) : (driveDocument.getParentId() != null ? TEASER_TEMPLATES.driveFolderIcon(driveDocument.getName()) : TEASER_TEMPLATES.driveShareIcon(driveDocument.getName()));
        SafeHtml expirationIcon = SuggestTeaserMarkupVisitor.createArchivedIcon((HasExpirationDate)driveDocument);
        SafeHtml title = TEASER_TEMPLATES.title(expirationIcon, HTMLUtil.highlightedHtmlEscape((String)driveDocument.getHtmlHighlightedName()));
        return TEASER_TEMPLATES.item("drive-document", logo, title).asString();
    }

    public String visitWiki(WikiSuggest wiki) {
        SafeHtml logo = TEASER_TEMPLATES.wikiIcon(wiki.getName());
        SafeHtml title = TEASER_TEMPLATES.title(SafeHtmlUtils.EMPTY_SAFE_HTML, HTMLUtil.highlightedHtmlEscape((String)wiki.getHtmlHighlightedName()));
        return TEASER_TEMPLATES.item("wiki", logo, title).asString();
    }

    public String visitChapter(ChapterSuggest chapter) {
        SafeHtml logo = TEASER_TEMPLATES.chapterIcon(chapter.getName());
        SafeHtml title = TEASER_TEMPLATES.title(SafeHtmlUtils.EMPTY_SAFE_HTML, HTMLUtil.highlightedHtmlEscape((String)chapter.getHtmlHighlightedName()));
        return TEASER_TEMPLATES.item("chapter", logo, title).asString();
    }

    public String visitArticle(ArticleSuggest article) {
        SafeHtml logo = TEASER_TEMPLATES.articleIcon(article.getName());
        SafeHtml title = TEASER_TEMPLATES.title(SafeHtmlUtils.EMPTY_SAFE_HTML, HTMLUtil.highlightedHtmlEscape((String)article.getHtmlHighlightedName()));
        return TEASER_TEMPLATES.item("article", logo, title).asString();
    }

    static {
        TEASER_TEMPLATES = (SuggestTeaserTemplates)GWT.create(SuggestTeaserTemplates.class);
        LINK_TO_ENTITY = new /* Unavailable Anonymous Inner Class!! */;
        AS_STRING = new /* Unavailable Anonymous Inner Class!! */;
    }
}

