/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.i18n.SearchProviderConstants;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.base.Strings;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.ClientEvent;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.presenter.InfiniteScrollPagingPresenter;
import de.justsoftware.onx.common.presentation.client.ui.InfiniteScrollSearchViewImpl;
import de.justsoftware.onx.common.presentation.client.ui.InfiniteScrollView;
import de.justsoftware.onx.common.presentation.client.ui.PanelPagingWidgetProvider;
import de.justsoftware.onx.container.presentation.client.SearchContextChangedEvent;
import de.justsoftware.onx.searchnew.presentation.client.SearchHandler;
import de.justsoftware.onx.searchnew.presentation.client.SearchProviderResultEvent;
import de.justsoftware.onx.searchnew.presentation.client.SearchTrackingInfo;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterCallback;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchPanelView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultBadgeWidgetFactory;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultHeaderPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultWidget;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntryVisitor;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderCapabilities;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SearchResultWidget
extends Composite {
    private static final int SCROLLTO_LAST_POSITION_TIMEOUT = 100;
    private static final int MAX_TIME_TO_LIVE_MILLIS = 21600000;
    protected final ClientFactory _clientFactory;
    protected SearchParameters _searchParameters;
    private final SimplePanel _searchPanelViewPanel = new SimplePanel();
    private final FlowPanel _contentPanel = new FlowPanel();
    private final boolean _useSearchProvider = HostPropertiesMediator.getHostPropertiesBean().isUseExternalSearchProvider();
    private final InfiniteScrollPagingPresenter<FederatedSearchResultEntry> _scrollPresenter;
    private final EventManager.EventManagerHelper _eventManagerHelper;
    private final boolean _hasParentColumn;
    private final boolean _hasContextSwitch;
    private final InfiniteScrollSearchViewImpl _searchResultView;
    private final String _additionalOverlayStyleName;
    private final SearchResultHeaderPresenter _searchResultHeaderPresenter;
    private IsWidget _noDataWidget;
    private SearchFilterCallback _searchFilterCallback;
    private HandlerRegistration _historyChangeHandler = null;
    private long _lastSearchTime = 0L;
    private SearchResult<FederatedSearchResultEntry> _recentSearchResult = null;

    public SearchResultWidget(ClientFactory clientFactory, SearchParameters parameters, @Nullable SearchFilterCallback searchFilterCallback, @Nullable IsWidget customNoDataView, @Nullable String additionalOverlayStyleName) {
        this(clientFactory, parameters, searchFilterCallback, customNoDataView, true, false, additionalOverlayStyleName);
    }

    public SearchResultWidget(ClientFactory clientFactory, SearchParameters parameters, @Nullable SearchFilterCallback searchFilterCallback, @Nullable IsWidget customNoDataView, boolean hasParentColumn, boolean hasContextSwitch, @Nullable String additionalOverlayStyleName) {
        this._clientFactory = clientFactory;
        this._additionalOverlayStyleName = additionalOverlayStyleName;
        this._eventManagerHelper = new EventManager.EventManagerHelper(clientFactory.eventManager());
        this._searchParameters = parameters;
        this._noDataWidget = customNoDataView;
        this._hasParentColumn = hasParentColumn;
        this._hasContextSwitch = hasContextSwitch;
        this._searchFilterCallback = searchFilterCallback;
        this._searchResultHeaderPresenter = this.createSearchResultHeaderPresenter();
        this._searchResultView = new InfiniteScrollSearchViewImpl(this._searchResultHeaderPresenter.getView());
        this._scrollPresenter = new InfiniteScrollPagingPresenter(clientFactory, (InfiniteScrollView)this._searchResultView, (PanelPagingWidgetProvider)new SearchResultPagingWidgetProvider(this));
        this.initUI();
        this.initWidget((Widget)this._contentPanel);
    }

    protected void onLoad() {
        super.onLoad();
        this._historyChangeHandler = History.addValueChangeHandler(event -> this._clientFactory.eventManager().handleEvent((ClientEvent)SearchContextChangedEvent.INSTANCE));
    }

    private void initUI() {
        this._contentPanel.add((Widget)this._searchPanelViewPanel);
        this._contentPanel.add((Widget)this._searchResultView);
        this._searchResultView.addStyleName("search-result-container");
        this.initSearch();
    }

    protected void initWidget(Widget widget) {
        super.initWidget(widget);
        this.addStyleName("search-result-widget");
    }

    protected void setSearchPanelView(SearchPanelView searchPanelView) {
        this._searchPanelViewPanel.setWidget((IsWidget)searchPanelView);
    }

    @Nonnull
    private SearchResultHeaderPresenter createSearchResultHeaderPresenter() {
        SearchResultHeaderPresenter searchResultHeaderPresenter = new SearchResultHeaderPresenter(this._clientFactory, this._hasParentColumn, this._hasContextSwitch);
        searchResultHeaderPresenter.update(this._searchParameters);
        return searchResultHeaderPresenter;
    }

    public void setSearchFilterCallback(SearchFilterCallback searchFilterCallback) {
        this._searchFilterCallback = searchFilterCallback;
        this.rerenderRecentSearchResult();
    }

    private void initSearch() {
        this._clientFactory.searchFactory().getAndSetForceNewSearch(false);
        this._scrollPresenter.start(this.getNoResultWidget());
        this._lastSearchTime = System.currentTimeMillis();
    }

    @Nonnull
    private IsWidget getNoResultWidget() {
        String text;
        if (this._noDataWidget != null) {
            return this._noDataWidget;
        }
        boolean hasText = this._searchParameters.hasText();
        boolean hasDefaultSearchProvider = this._searchParameters.hasDefaultSearchProvider();
        SearchProviderConstants providerMessages = this._clientFactory.searchFactory().getProviderMessages(this._searchParameters.getSearchProvider());
        String string = text = hasText ? Strings.nullToEmpty((String)this._searchParameters.getText()) : "";
        return hasText ? (hasDefaultSearchProvider ? this.createHtmlMessagePanel(I18nMediator.SEARCH_MESSAGES.noResultWithSearchString(SafeHtmlUtils.htmlEscape((String)text))) : this.createHtmlMessagePanel(providerMessages.noResultsForProvider(this._searchParameters.getSearchProvider(), SafeHtmlUtils.htmlEscape((String)text)))) : (hasDefaultSearchProvider ? this.createHtmlMessagePanel(I18nMediator.SEARCH_MESSAGES.noResultWithoutSearchString()) : this.createHtmlMessagePanel(providerMessages.emptyQueryNotSupported(this._searchParameters.getSearchProvider())));
    }

    @Nonnull
    private IsWidget createHtmlMessagePanel(String escapedHtmlMessage) {
        FlowPanel messagePanel = new FlowPanel();
        messagePanel.add((Widget)new HTML(escapedHtmlMessage));
        if (this._searchParameters.hasFilterOrSubFilter()) {
            messagePanel.add((Widget)new HTML(I18nMediator.SEARCH_MESSAGES.noResultWithFilterOrSubfilter()));
        }
        return messagePanel;
    }

    @CheckForNull
    protected Widget getBadge(SearchResultBadgeWidgetFactory badgeFactory, FederatedSearchResultEntry data, boolean first, boolean last) {
        return (Widget)data.invite((FederatedSearchResultEntryVisitor)new /* Unavailable Anonymous Inner Class!! */);
    }

    @CheckForNull
    protected Widget getBadge(FederatedSearchResultEntry data, boolean first, boolean last, @Nullable SearchTrackingInfo searchTrackingInfo) {
        SearchResultBadgeWidgetFactory badgeFactory = new SearchResultBadgeWidgetFactory(this._clientFactory, this._searchParameters.getSortType() == SortType.EXPIRATION_DATE, this.isDisplayEntityMemberInfo(), this._searchParameters.getText(), this._hasParentColumn, this._hasContextSwitch, searchTrackingInfo, this._additionalOverlayStyleName);
        return this.getBadge(badgeFactory, data, first, last);
    }

    protected boolean isDisplayEntityMemberInfo() {
        return false;
    }

    private void rerenderRecentSearchResult() {
        this.dispatchSearchResultEvent();
        this.updateWidgetStates();
    }

    private void setRecentSearchResult(SearchResult<FederatedSearchResultEntry> result) {
        this._recentSearchResult = result;
        this.rerenderRecentSearchResult();
    }

    private void dispatchSearchResultEvent() {
        if (this._useSearchProvider && this._recentSearchResult != null) {
            this._clientFactory.eventManager().handleEvent((ClientEvent)new SearchProviderResultEvent(this._recentSearchResult));
        }
    }

    private void updateWidgetStates() {
        if (this._recentSearchResult != null) {
            SearchProviderCapabilities cap = this._recentSearchResult.getSearchProvider().getCapabilities();
            this._searchResultHeaderPresenter.setResultCount(this._recentSearchResult.getNumberOfResults());
            if (this._searchFilterCallback == null) {
                return;
            }
            boolean supported = cap.doesSupportSortAndFilters();
            this._searchFilterCallback.setFilterSupported(supported);
            if (supported) {
                this._searchFilterCallback.onSearchResult(this._recentSearchResult);
            }
        }
    }

    public void setNoDataWidget(@Nullable IsWidget widget) {
        this._noDataWidget = widget;
    }

    public void setSearchParameters(SearchParameters searchParameters) {
        long now = System.currentTimeMillis();
        long lastValidTime = now - 21600000L;
        boolean forceNewSearch = this._clientFactory.searchFactory().getAndSetForceNewSearch(false);
        if (forceNewSearch || !SearchHandler.tokenFor((SearchParameters)searchParameters).equals(SearchHandler.tokenFor((SearchParameters)this._searchParameters)) || this._lastSearchTime < lastValidTime) {
            this._searchParameters = searchParameters;
            this.onSearchParametersChanged();
            this._searchResultHeaderPresenter.update(searchParameters);
        } else {
            2 t = new /* Unavailable Anonymous Inner Class!! */;
            t.schedule(100);
        }
    }

    private void onSearchParametersChanged() {
        if (this._searchFilterCallback != null) {
            this._searchFilterCallback.onSearchParametersChanged(this._searchParameters);
        }
        this.initSearch();
    }

    @Nonnull
    public SearchParameters getSearchParameters() {
        return this._searchParameters;
    }

    protected void onUnload() {
        super.onUnload();
        this._eventManagerHelper.onUnloadRemoveHandlersFromManager();
        if (this._historyChangeHandler != null) {
            this._historyChangeHandler.removeHandler();
        }
    }
}

