/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.presentation.client.SearchClientFactory;
import de.justsoftware.onx.searchnew.presentation.client.ui.AbstractSingleSelectionFilterPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.ArchiveSubFilterDataProvider;
import de.justsoftware.onx.searchnew.presentation.client.ui.BlockSubFilterDataProvider;
import de.justsoftware.onx.searchnew.presentation.client.ui.EntityDurationSubFilterDataProvider;
import de.justsoftware.onx.searchnew.presentation.client.ui.EntityDynamicAttributeSubFilterDataProvider;
import de.justsoftware.onx.searchnew.presentation.client.ui.EntitySearchContextFilterDataProvider;
import de.justsoftware.onx.searchnew.presentation.client.ui.ExpansionState;
import de.justsoftware.onx.searchnew.presentation.client.ui.ModificationDateSubFilterDataProvider;
import de.justsoftware.onx.searchnew.presentation.client.ui.MultipleSelectionFilterPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.MySearchContextFilterDataProvider;
import de.justsoftware.onx.searchnew.presentation.client.ui.PersonRoleSubFilterDataProvider;
import de.justsoftware.onx.searchnew.presentation.client.ui.ProfileAttributeSubFilterDataProvider;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterListView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterTogglePresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultSortOrderDataProvider;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchSelectionFilterPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SingleSelectionSearchFacetFilterPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SingleSelectionSortTypeFilterPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.TagSubFilterDataProvider;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.TranslatedProfileAttributeFacet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SearchFilterListPresenter
implements SearchFilterPresenter,
SearchFilterListView.Presenter {
    private static final ExpansionState.Visitor<ExpansionState> TOGGLE_VISITOR = new /* Unavailable Anonymous Inner Class!! */;
    private final List<SearchSelectionFilterPresenter> _subfilters = Lists.newArrayList();
    private final SearchFilterListView _view;
    private SearchParameters _searchParameters;
    private ExpansionState _currentState;
    private final boolean _collapseToRestrictingFilters;
    private final SearchFilterTogglePresenter _searchFilterToggle;

    public SearchFilterListPresenter(SearchParameters searchParameters, ClientFactory clientFactory, ExpansionState initialState, SearchFilterTogglePresenter searchFilterToggle) {
        this._searchParameters = searchParameters;
        this._searchFilterToggle = searchFilterToggle;
        this._collapseToRestrictingFilters = !searchFilterToggle.isEnabled();
        this._view = clientFactory.searchFactory().getSubfilterListView((SearchFilterListView.Presenter)this);
        this.initSearchFilter(clientFactory);
        this.setNewState(initialState);
        this.onSearchParametersChanged(searchParameters);
        this.showFilterList(searchFilterToggle.showFilter());
    }

    private void initSearchFilter(ClientFactory clientFactory) {
        SearchClientFactory searchClientFactory = clientFactory.searchFactory();
        SearchConfigurationProvider searchConfigurationProvider = searchClientFactory.searchConfigurationProvider();
        this.addSingleSelectionSortTypeFilter(searchClientFactory, (AbstractSingleSelectionFilterPresenter.SingleSelectionFilterLinkDataProvider)new SearchResultSortOrderDataProvider());
        if (this.isContextSupported()) {
            this.addSingleSelectionSearchFacetFilter(searchClientFactory, (AbstractSingleSelectionFilterPresenter.SingleSelectionFilterLinkDataProvider)new EntitySearchContextFilterDataProvider(clientFactory.entityFactory(), clientFactory.localizedMessages().searchConstants(), clientFactory.getHostPropertiesBean()));
            this.addSingleSelectionSearchFacetFilter(searchClientFactory, (AbstractSingleSelectionFilterPresenter.SingleSelectionFilterLinkDataProvider)new MySearchContextFilterDataProvider(clientFactory.localizedMessages().searchConstants(), clientFactory.getHostPropertiesBean().isAlwaysShowSearchContextFilter(), clientFactory.getLoginInfo(), clientFactory.clientLogger()));
        }
        this.addSingleSelectionSearchFacetFilter(searchClientFactory, (AbstractSingleSelectionFilterPresenter.SingleSelectionFilterLinkDataProvider)new EntityDurationSubFilterDataProvider());
        this.addSingleSelectionSearchFacetFilter(searchClientFactory, (AbstractSingleSelectionFilterPresenter.SingleSelectionFilterLinkDataProvider)new ArchiveSubFilterDataProvider());
        this.addMultipleSelectionFilter(clientFactory, (MultipleSelectionFilterPresenter.MultiSelectionFilterLinkDataProvider)new PersonRoleSubFilterDataProvider(searchConfigurationProvider));
        this.addSingleSelectionSearchFacetFilter(searchClientFactory, (AbstractSingleSelectionFilterPresenter.SingleSelectionFilterLinkDataProvider)new BlockSubFilterDataProvider());
        this.addEntityDynamicAttributesSubFilter(clientFactory, searchConfigurationProvider);
        this.addProfileAttributesSubFilter(clientFactory, searchConfigurationProvider);
        this.addMultipleSelectionFilter(clientFactory, (MultipleSelectionFilterPresenter.MultiSelectionFilterLinkDataProvider)new TagSubFilterDataProvider(searchConfigurationProvider));
        this.addSingleSelectionSearchFacetFilter(searchClientFactory, (AbstractSingleSelectionFilterPresenter.SingleSelectionFilterLinkDataProvider)new ModificationDateSubFilterDataProvider());
        this._view.allSubfiltersAdded();
    }

    private void addEntityDynamicAttributesSubFilter(ClientFactory clientFactory, SearchConfigurationProvider searchConfigurationProvider) {
        for (EntityType entityType : HostPropertiesMediator.getHostPropertiesBean().getActiveOrderedEntityTypes()) {
            for (DynamicAttributeConfig config : Iterables.filter((Iterable)clientFactory.entityFactory().entityConfig(entityType).getDynamicAttributesConfig(), (Predicate)DynamicAttributeConfig.IS_FACETTING_ENABLED)) {
                this.addMultipleSelectionFilter(clientFactory, (MultipleSelectionFilterPresenter.MultiSelectionFilterLinkDataProvider)new EntityDynamicAttributeSubFilterDataProvider(entityType, config, clientFactory.entityFactory(), searchConfigurationProvider));
            }
        }
    }

    private void addProfileAttributesSubFilter(ClientFactory clientFactory, SearchConfigurationProvider searchConfigurationProvider) {
        ImmutableList profileAttributeFacets = HostPropertiesMediator.getHostPropertiesBean().getProfileAttributeFacets();
        for (TranslatedProfileAttributeFacet tpaf : profileAttributeFacets) {
            this.addMultipleSelectionFilter(clientFactory, (MultipleSelectionFilterPresenter.MultiSelectionFilterLinkDataProvider)new ProfileAttributeSubFilterDataProvider(tpaf, searchConfigurationProvider));
        }
    }

    private void addSingleSelectionSortTypeFilter(SearchClientFactory searchClientFactory, AbstractSingleSelectionFilterPresenter.SingleSelectionFilterLinkDataProvider<SortType> dataProvider) {
        this.addSubFilter((SearchSelectionFilterPresenter)new SingleSelectionSortTypeFilterPresenter(searchClientFactory, dataProvider, this._searchParameters));
    }

    void addSingleSelectionSearchFacetFilter(SearchClientFactory searchClientFactory, AbstractSingleSelectionFilterPresenter.SingleSelectionFilterLinkDataProvider<? extends SearchFacet> dataProvider) {
        this.addSubFilter((SearchSelectionFilterPresenter)new SingleSelectionSearchFacetFilterPresenter(searchClientFactory, dataProvider, this._searchParameters));
    }

    void addMultipleSelectionFilter(ClientFactory clientFactory, MultipleSelectionFilterPresenter.MultiSelectionFilterLinkDataProvider<?> dataProvider) {
        this.addSubFilter((SearchSelectionFilterPresenter)new MultipleSelectionFilterPresenter(clientFactory.searchFactory(), clientFactory.popupHelper(), clientFactory.clientLogger(), dataProvider, this._searchParameters));
    }

    private void addSubFilter(SearchSelectionFilterPresenter subfilter) {
        subfilter.addToParent((HasWidgets.ForIsWidget)this._view);
        this._subfilters.add(subfilter);
    }

    public void onSearchParametersChanged(SearchParameters searchParameters) {
        this._searchParameters = searchParameters;
        for (SearchSelectionFilterPresenter filter : this._subfilters) {
            filter.onSearchParametersChanged(searchParameters);
        }
        this.updateToggleLinkVisibility();
    }

    public void onSearchResult(SearchResult<FederatedSearchResultEntry> result) {
        for (SearchSelectionFilterPresenter presenter : this._subfilters) {
            presenter.onSearchResult(result);
        }
        this.updateToggleLinkVisibility();
    }

    private void updateToggleLinkVisibility() {
        boolean toggleLinkVisible = this.isToggleLinkVisible(this._currentState);
        ExpansionState otherState = (ExpansionState)this._currentState.accept(TOGGLE_VISITOR);
        if (!toggleLinkVisible && this.isToggleLinkVisible(otherState)) {
            this.setNewState(otherState);
            this._view.setToggleLinkVisible(true);
        } else {
            this._view.setToggleLinkVisible(toggleLinkVisible);
        }
    }

    private boolean isToggleLinkVisible(ExpansionState state) {
        if (this._searchFilterToggle.isEnabled()) {
            return false;
        }
        return FluentIterable.from((Iterable)this._subfilters).anyMatch((Predicate)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void addToParent(HasWidgets.ForIsWidget parent) {
        parent.add((IsWidget)this._view);
    }

    public void onToggleExpansion() {
        this.setNewState((ExpansionState)this._currentState.accept(TOGGLE_VISITOR));
    }

    private void setNewState(ExpansionState newState) {
        this._currentState = newState;
        this._view.setToggleLinkState(newState);
        for (SearchSelectionFilterPresenter subfilter : this._subfilters) {
            subfilter.onToggleExpansion(newState, this._collapseToRestrictingFilters);
        }
    }

    @Nonnull
    public ExpansionState getExpansionState() {
        return this._currentState;
    }

    protected boolean isContextSupported() {
        return true;
    }

    public void setFilterSupported(boolean supported) {
        this._view.asWidget().setVisible(supported);
    }

    @Nonnull
    public SearchFilterListView getView() {
        return this._view;
    }

    public void showFilterList(boolean show) {
        this._view.showFilterList(show);
    }
}

