/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import de.justsoftware.onx.common.presentation.client.OrderedCallbackFactory;
import de.justsoftware.onx.common.presentation.client.ui.PopupHelper;
import de.justsoftware.onx.logging.client.ClientLogger;
import de.justsoftware.onx.searchnew.presentation.client.MultiSelectionFilterLink;
import de.justsoftware.onx.searchnew.presentation.client.SearchClientFactory;
import de.justsoftware.onx.searchnew.presentation.client.ui.AbstractSearchSelectionFilterPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.MultipleSelectionFilterPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.MultipleSelectionFilterView;
import de.justsoftware.onx.searchnew.presentation.shared.SearchControllerAsync;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MultipleSelectionFilterPresenter<T>
extends AbstractSearchSelectionFilterPresenter
implements MultipleSelectionFilterView.Presenter<T> {
    private static final int DEFAULT_SEARCHED_SELECTIONS_LIMIT = 8;
    private final MultipleSelectionFilterView<T> _view;
    private final MultiSelectionFilterLinkDataProvider<T> _dataProvider;
    private boolean _dropdownOpen = false;
    private boolean _enabled = true;
    private ImmutableCollection<MultiSelectionFilterLink<T>> _facetLinks = ImmutableList.of();
    private final SearchControllerAsync _searchController;
    private final OrderedCallbackFactory _typeAheadCallbackFactory = new OrderedCallbackFactory();
    private final PopupHelper _popupHelper;
    private final ClientLogger _clientLogger;
    private boolean _isSelectionEmpty = true;
    private final SearchClientFactory _factory;
    private final SearchInSelectionsSupport<T> _searchInSelectionSupport;
    private boolean _inTypeAheadMode;
    private boolean _rebuildFilterLinks;

    public MultipleSelectionFilterPresenter(SearchClientFactory factory, PopupHelper popupHelper, ClientLogger clientLogger, MultiSelectionFilterLinkDataProvider<T> dataProvider, SearchParameters searchParameters) {
        super(dataProvider, searchParameters);
        this._factory = factory;
        this._dataProvider = dataProvider;
        this._popupHelper = popupHelper;
        this._clientLogger = clientLogger;
        this._searchController = factory.controller();
        this._view = factory.getMultipleSelectionSubFilterView((MultipleSelectionFilterView.Presenter)this);
        this._view.setFilterHeader(this._dataProvider.getFilterHeader());
        this._searchInSelectionSupport = this._dataProvider.getSearchInSelectionSupport();
        this._view.setSearchBoxVisible(this._searchInSelectionSupport != null);
        this._view.setClearSearchBoxVisible(false);
        this.onSearchParametersChanged(searchParameters);
    }

    protected MultipleSelectionFilterView<T> getView() {
        return this._view;
    }

    protected void onSearchParametersChanged() {
    }

    public void onSearchResult(SearchResult<FederatedSearchResultEntry> result) {
        this._facetLinks = this._dataProvider.getFilterLinks(this.getSearchParameters(), result);
        ImmutableList currentlySelected = FluentIterable.from((Iterable)this._facetLinks).filter(MultiSelectionFilterLink.IS_SELECTED).toList();
        this._isSelectionEmpty = currentlySelected.isEmpty();
        this.setEnabled(!this._facetLinks.isEmpty());
        if (this._rebuildFilterLinks) {
            this._rebuildFilterLinks = false;
            this.updateFilterLinks();
        }
        if (this._isSelectionEmpty) {
            this._view.setNoFilterSelected();
        } else {
            Ordering selectedFilterOrdering = this._dataProvider.getSelectedFilterOrdering(result);
            if (selectedFilterOrdering != null) {
                this._view.setSelectedFilter((ImmutableCollection)selectedFilterOrdering.immutableSortedCopy((Iterable)currentlySelected));
            } else {
                this._view.setSelectedFilter((ImmutableCollection)currentlySelected);
            }
        }
    }

    private void updateFilterLinks() {
        if (this.inTypeAheadMode()) {
            return;
        }
        ImmutableListMultimap lists = Multimaps.index((Iterable)this._facetLinks, (Function)Functions.forPredicate((Predicate)MultiSelectionFilterLink.IS_SELECTED));
        if (lists.get((Object)Boolean.TRUE).isEmpty()) {
            this.showFilterLinks(lists.get((Object)Boolean.FALSE), ImmutableList.of());
        } else {
            this.showFilterLinks(lists.get((Object)Boolean.TRUE), lists.get((Object)Boolean.FALSE));
        }
    }

    private void showFilterLinks(ImmutableList<MultiSelectionFilterLink<T>> upperList, ImmutableList<MultiSelectionFilterLink<T>> lowerList) {
        this._view.clearDropdown();
        this._view.dropdownAddFilterLinks(upperList, false);
        this._view.dropdownAddClearLink();
        this._view.setClearFilterLinksVisible(!this._isSelectionEmpty || !lowerList.isEmpty());
        if (!lowerList.isEmpty()) {
            this._view.dropdownAddSeparator();
            this._view.dropdownAddFilterLinks(lowerList, false);
        }
    }

    private void setEnabled(boolean enabled) {
        this._enabled = enabled;
        this._view.setFilterEnabled(this._enabled);
        if (!enabled) {
            this.setDropdownOpen(false);
        }
    }

    private void setDropdownOpen(boolean dropdownOpen) {
        this._dropdownOpen = dropdownOpen;
        if (dropdownOpen) {
            this._view.setSearchText("");
            this._view.setClearSearchBoxVisible(false);
            this.updateFilterLinks();
        }
        this._view.setDropdownOpen(dropdownOpen);
        if (dropdownOpen) {
            this._view.setFocusOnSearchBox();
        }
    }

    public void onSelected(T selection) {
        SearchParameters newSearchParameters = this._dataProvider.onSelectionChanged(selection, true, this.getSearchParameters());
        this._view.setClearFilterLinksVisible(true);
        this._factory.newSearchHistoryItem(newSearchParameters);
    }

    public void onDeselected(T selection) {
        SearchParameters newSearchParameters = this._dataProvider.onSelectionChanged(selection, false, this.getSearchParameters());
        this._factory.newSearchHistoryItem(newSearchParameters);
    }

    public void onClearFilterLinks() {
        this._rebuildFilterLinks = true;
        SearchParameters newSearchParameters = this._dataProvider.onSelectionsCleared(this.getSearchParameters());
        this._factory.newSearchHistoryItem(newSearchParameters);
    }

    public void onFilterHeaderClick() {
        if (!this._enabled) {
            return;
        }
        this.setDropdownOpen(!this._dropdownOpen);
    }

    public void onDropdownCloseClick() {
        this.setDropdownOpen(false);
    }

    private boolean inTypeAheadMode() {
        return ClientStringUtil.hasText((String)this._view.getSearchText());
    }

    private void setSelectionSearchResult(ImmutableCollection<MultiSelectionFilterLink<T>> filterLinks) {
        this._view.clearDropdown();
        if (filterLinks.isEmpty()) {
            this._view.dropdownAddNoHits();
        } else {
            this._view.dropdownAddFilterLinks(filterLinks, true);
        }
    }

    public void onSearchTextChanged() {
        if (this._searchInSelectionSupport == null) {
            return;
        }
        boolean wasInTypeAheadMode = this._inTypeAheadMode;
        this._inTypeAheadMode = this.inTypeAheadMode();
        if (!this._inTypeAheadMode) {
            if (wasInTypeAheadMode) {
                this._view.setClearSearchBoxVisible(false);
                this.updateFilterLinks();
            }
            return;
        }
        this._view.setClearSearchBoxVisible(true);
        this._searchInSelectionSupport.accept((SearchInSelectionsSupport.Visitor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onClearSearchText() {
        this._view.setSearchText("");
        this.onSearchTextChanged();
    }
}

