/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.server;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.collect.ImmutableList;
import de.justsoftware.common.clock.Clock;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.mail.business.MailManager;
import de.justsoftware.onx.person.business.FriendsService;
import de.justsoftware.onx.person.presentation.shared.FriendsController;
import de.justsoftware.onx.person.shared.model.PersonBadgeModel;
import de.justsoftware.onx.person.shared.model.PersonBirthdayTeaserModel;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class FriendsControllerImpl
implements FriendsController {
    private static final int DEFAULT_BIRTHDAY_INTERVAL = 7;
    @Autowired
    private FriendsService _friendsService;
    @Autowired
    @Qualifier(value="mailManager")
    private MailManager _mailManager;
    @Autowired
    private Settings _settings;
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private Clock _clock;

    public ListAndCount<PersonTeaserModel> getFriendTeasers(PersonId personId, int offset, int limit) {
        return this._friendsService.getFriendTeasersOfId(personId, offset, limit, (AuthorizationCheckContextWithLocale)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    public ListAndCount<PersonBadgeModel> getFriendBadges(PersonId personId, int offset, int limit) {
        return this._friendsService.getFriendBadgesOfId(personId, offset, limit, (AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    public void removeFriend(PersonId friendId) {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._friendsService.endFriendship(authCtx.getUserId(), friendId);
    }

    public ImmutableList<PersonBirthdayTeaserModel> getFriendsWithUpcomingBirthdays() {
        return this._friendsService.getFriendsBadgesWithUpcomingBirthdays(7, this._settings.getShowBirthdaysOnStartPage(), (AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser(), this._clock.now());
    }

    public void acceptInvitation(PersonId personId) {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        PersonId userId = authCtx.getUserId();
        if (!this._friendsService.hasInvited(personId, userId)) {
            throw new PermissionDeniedException("You are not invited by this person");
        }
        this._friendsService.acceptInvitation(personId, userId);
    }

    public void declineInvitation(PersonId personId) {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._friendsService.declineInvitation(personId, authCtx.getUserId());
    }

    public void invitePerson(PersonId personId, String message) {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authCtx.check((ItemId)personId.asProfileId(), (Action)StaticAction.PERSON_ADD_CONTACT);
        this._friendsService.invitePerson(authCtx.getUserId(), personId, message);
    }
}

