/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.client.ui.presenter;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.searchnew.presentation.client.ClientSearchConfigurationProvider;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterCallback;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterTabsPresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchInputView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchPanelView;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchResultWidget;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacetParameters;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileMyContentPresenter {
    private final ClientFactory _clientFactory;
    private final FlowPanel _view = new FlowPanel();
    private SearchResultWidget _searchResultWidget;
    private SearchInputView.Presenter _searchInputPresenter;
    private SearchFilterTabsPresenter _searchFilterPresenter;
    private boolean _initialized = false;

    public ProfileMyContentPresenter(ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
    }

    private void initView(SearchParameters parameters) {
        this._view.clear();
        SearchPanelView searchPanel = this._clientFactory.searchFactory().createSearchPanelView();
        this._searchInputPresenter = this._clientFactory.searchFactory().createSearchInputPresenter(false, "profile_my_content");
        this._searchInputPresenter.update(parameters);
        this._searchFilterPresenter = new SearchFilterTabsPresenter(this._clientFactory, parameters);
        this._searchResultWidget = this._clientFactory.searchFactory().createSearchResultWidget(parameters, (SearchFilterCallback)this._searchFilterPresenter, null);
        searchPanel.setSearchInput((IsWidget)this._searchInputPresenter.getView());
        searchPanel.setSearchFilter(this._searchFilterPresenter.getView());
        this._view.add(searchPanel.asWidget());
        this._view.add((Widget)this._searchResultWidget);
        this._initialized = true;
    }

    @Nonnull
    private final SearchParameters getDefaultSearchParameterForPerson(PersonId personId) {
        return new SearchParameters(null, (FilterType)StaticFilterType.ALL, SearchContext.MY_CONTENT, (GlobalId)personId.asProfileId(), null, null, null, null, (SearchFacetParameters)StaticSearchFacetParameters.DEFAULT_FACETS, HistoryToken.PROFILE).withDefaultSortTypeAndSubfilter(ClientSearchConfigurationProvider.INSTANCE);
    }

    @Nonnull
    public IsWidget getView(PersonId personId, @Nullable SearchParameters searchParams) {
        SearchParameters parameters;
        SearchParameters searchParameters = parameters = searchParams != null ? searchParams : this.getDefaultSearchParameterForPerson(personId);
        if (!this._initialized) {
            this.initView(parameters);
        } else {
            this.updateSearchParameters(parameters);
        }
        return this._view;
    }

    private void updateSearchParameters(SearchParameters searchParameters) {
        this._searchResultWidget.setSearchParameters(searchParameters);
        this._searchInputPresenter.update(searchParameters);
        this._searchFilterPresenter.onSearchParametersChanged(searchParameters);
    }
}

