/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.presentation.client.ui.presenters;

import com.google.common.collect.ImmutableSet;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ui.PopupHelper;
import de.justsoftware.onx.logging.client.ClientLogger;
import de.justsoftware.onx.multiwiki.presentation.client.MultiWikiComponentFactory;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiViewAsRolePresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.views.MultiWikiViewAsRoleView;
import de.justsoftware.onx.person.presentation.shared.PersonSettingsControllerAsync;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MultiWikiViewAsRolePresenter
implements MultiWikiViewAsRoleView.Presenter {
    private final MultiWikiViewAsRoleView _view;
    private final ViewAsRoleChangeHandler _changeHandler;
    private final PersonSettingsControllerAsync _personSettingsController;
    private String _selectedRole;
    private String _defaultRole;
    private final PopupHelper _popupHelper;
    private final ClientLogger _logger;

    public MultiWikiViewAsRolePresenter(MultiWikiComponentFactory componentFactory, ViewAsRoleChangeHandler changeHandler) {
        this._changeHandler = changeHandler;
        this._personSettingsController = componentFactory.personSettingsController();
        this._popupHelper = componentFactory.popupHelper();
        this._logger = componentFactory.clientLogger();
        this._view = componentFactory.viewAsRoleView((MultiWikiViewAsRoleView.Presenter)this);
    }

    public void init(ImmutableSet<String> roles, @Nullable String defaultRole) {
        this._defaultRole = defaultRole;
        this._view.init(roles);
        this.setSelectedRole(defaultRole);
        this._view.showRolesSelectable(!roles.isEmpty());
    }

    public void showIn(AcceptsOneWidget container) {
        container.setWidget((IsWidget)this._view);
    }

    public void onRoleSelected(String role) {
        this.setSelectedRole(role);
        this._changeHandler.viewAsRole(role);
    }

    private void setSelectedRole(@Nullable String role) {
        this._selectedRole = role;
        this._view.showIsDefaultRole(Objects.equals(this._defaultRole, role));
        this._view.showSelectedRole(role);
    }

    @CheckForNull
    public String getSelectedRole() {
        return this._selectedRole;
    }

    public void setEnabled(boolean enabled) {
        this._view.setEnabled(enabled);
    }

    public void saveCurrentRoleAsDefault() {
        this._personSettingsController.setRoleToViewMultiWiki(this._selectedRole, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

