/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.presentation.client.ui.presenters;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ui.components.AbstractSingleValueInlineEditPresenter;
import de.justsoftware.onx.common.presentation.client.ui.components.InlineEditView;
import de.justsoftware.onx.common.presentation.client.ui.components.SingleValueInlineEditView;
import de.justsoftware.onx.common.presentation.client.ui.editor.EditorClientFactory;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiEditorPresenter;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MultiWikiSectionHeadlinePresenter
extends AbstractSingleValueInlineEditPresenter<String> {
    private final MultiWikiEditorPresenter.EditHandler _editHandler;

    public MultiWikiSectionHeadlinePresenter(EditorClientFactory editorFactory, String initialValue, boolean mayEdit, MultiWikiEditorPresenter.EditHandler editHandler) {
        super(editorFactory, (Object)initialValue, mayEdit);
        this._editHandler = editHandler;
    }

    protected SingleValueInlineEditView<String> initView(EditorClientFactory editorFactory, boolean mayEdit) {
        return mayEdit ? editorFactory.getMultiWikiSectionHeadingView((InlineEditView.Presenter)this) : editorFactory.getReadOnlyView();
    }

    public void edit() {
        if (this._editHandler.onEdit(null)) {
            super.edit();
        }
    }

    public void save() {
        this.blur();
    }

    protected void save(String value) {
    }

    public boolean isDirty() {
        return !Objects.equal((Object)this._savedValue, (Object)this.getValue());
    }

    @Nonnull
    public String getValue() {
        return Strings.nullToEmpty((String)((String)this._view.getValue()));
    }

    public void blur() {
        this.handleChange();
        this._editHandler.onChange();
    }

    private void handleChange() {
        boolean isDirty = this.isDirty();
        this._view.marksAsDirty(isDirty);
        this._view.showLabel();
    }

    public void showIn(AcceptsOneWidget parent) {
        parent.setWidget((IsWidget)this._view);
    }

    public void setHeadline(String headline) {
        if (headline.equals(this._savedValue)) {
            return;
        }
        this._savedValue = headline;
        this._view.setValue((Object)headline);
        this.handleChange();
    }
}

