/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.menu.presentation.client.impl;

import com.freiheit.toro.client.event.EventListener;
import com.freiheit.toro.common.presentation.client.ErrorHandlingAsyncCallback;
import com.freiheit.toro.util.client.LoggingUtil;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.gwt.requestcollect.client.AbstractRequestBundler;
import de.justsoftware.gwt.requestcollect.client.IRequestBundler;
import de.justsoftware.gwt.requestcollect.client.RequestCollector;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.events.PollEvent;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.menu.presentation.client.WorkstreamReadMediator;
import de.justsoftware.onx.menu.presentation.shared.MenuRemoteServiceAsync;
import de.justsoftware.onx.workstream.shared.model.WorkstreamReadClientModel;
import de.justsoftware.onx.workstream.shared.model.WorkstreamReadConfig;
import javax.annotation.Nonnull;

public class WorkstreamReadMediatorImpl
implements WorkstreamReadMediator {
    private final ListMultimap<ItemId, AsyncCallback<Boolean>> _callbacks = ArrayListMultimap.create();
    private final Cache<ItemId, WorkstreamReadClientModel> _existingEntries = CacheBuilder.newBuilder().maximumSize(1000L).build();
    private WorkstreamReadConfig _workstreamReadConfig = WorkstreamReadConfig.ENABLED;
    private final MenuRemoteServiceAsync _remoteService;
    private final AbstractRequestBundler _requestBundler = new /* Unavailable Anonymous Inner Class!! */;
    private int _pollRatio = 1;
    private int _nextPoll = 0;
    private int _lastPoll = 0;
    private final EventListener<PollEvent> _eventListener = new /* Unavailable Anonymous Inner Class!! */;
    private final EventManager _eventManager;

    public WorkstreamReadMediatorImpl(@Nonnull MenuRemoteServiceAsync remoteService, @Nonnull EventManager eventManager) {
        this._remoteService = remoteService;
        this._eventManager = eventManager;
    }

    public void init(WorkstreamReadConfig workstreamReadPollingActivated) {
        LoggingUtil.debug((Object)this, (String)("init WorkstreamReadMediator : " + workstreamReadPollingActivated));
        this._workstreamReadConfig = workstreamReadPollingActivated;
        if (this._workstreamReadConfig.isPollingEnabled()) {
            RequestCollector.INSTANCE.registerBundler((IRequestBundler)this._requestBundler);
            this._eventManager.registerListener(PollEvent.class, this._eventListener);
        }
    }

    public HandlerRegistration register(ItemId id, AsyncCallback<Boolean> callback) {
        this._callbacks.put((Object)id, callback);
        this._requestBundler.call();
        return () -> this._callbacks.remove((Object)id, (Object)callback);
    }

    public void markWorkstreamRead(ItemId id) {
        if (this._workstreamReadConfig.isMarkReadEnabled()) {
            this._remoteService.markWorkstreamRead(id, (AsyncCallback)ErrorHandlingAsyncCallback.emptyCallback());
            this.success(true, (Iterable)this._callbacks.get((Object)id));
        }
    }

    private void success(boolean read, @Nonnull Iterable<AsyncCallback<Boolean>> callbacks) {
        for (AsyncCallback<Boolean> callback : callbacks) {
            try {
                callback.onSuccess((Object)read);
            }
            catch (RuntimeException e) {
                LoggingUtil.error((Object)this, (String)e.toString(), (Throwable)e);
            }
        }
    }
}

