/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.like.presentation.server;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.Charsets;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.like.business.LikeService;
import de.justsoftware.onx.like.shared.i18n.LikeMessages;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

@Service(value="unsubscribeServlet")
public class UnsubscribeServlet
implements Controller,
InitializingBean {
    @Autowired
    private LikeService _likeService;
    @Autowired
    private Settings _settings;
    @Autowired
    private ServerUrlUtil _serverUrlUtil;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private PersonService _personService;
    private Configuration _cfg;

    public void afterPropertiesSet() {
        this._cfg = new Configuration();
        this._cfg.setClassForTemplateLoading(UnsubscribeServlet.class, "");
        this._cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, TemplateException {
        String token = request.getParameter("token");
        PersonId personId = this._likeService.unsubscribeByToken(token);
        LikeMessages likeMessages = (LikeMessages)this._i18nService.createProxy(LikeMessages.class, this.getLocale(personId));
        Template tmpl = this._cfg.getTemplate("unsubscribe.ftl");
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("defaultTitle", this._settings.getDefaultSiteTitle());
        model.put("favIconUrl", this._settings.getFavIconUrl());
        model.put("favIconImageType", this._settings.getFavIconImageType());
        model.put("unsubscribedMessage", personId == null ? likeMessages.unsubscribeLikeBroken() : likeMessages.successfullyUnsubscribed());
        model.put("linkToPlatform", this._serverUrlUtil.getHtmlClientBaseUrl());
        model.put("textToPlatform", likeMessages.toPlatform());
        response.setContentType("text/html");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), Charsets.UTF_8);
        tmpl.process(model, (Writer)writer);
        writer.close();
        return null;
    }

    private String getLocale(PersonId personId) {
        String defaultLanguage = this._settings.defaultLanguage();
        if (personId == null) {
            return defaultLanguage;
        }
        DBPerson p = this._personService.getPersonById(personId);
        if (p == null) {
            return defaultLanguage;
        }
        return p.getLanguageId();
    }
}

