/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.client.validator.Validatable;
import com.freiheit.toro.common.shared.i18n.SearchConstants;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.DataSuggestion;
import de.justsoftware.onx.common.presentation.client.ui.CompositePanelWithValue;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.presentation.client.ui.JCSuggestBox;
import de.justsoftware.onx.common.presentation.client.ui.TextBoxWithDescription;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.presentation.client.OnSuggestionSelectHandler;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.searchnew.presentation.client.PersonSolrSuggestOracle;
import de.justsoftware.onx.searchnew.shared.model.PersonSuggest;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PersonSelectWidget
extends CompositePanelWithValue<PersonSuggest>
implements Validatable {
    private static final SearchConstants SEARCH = I18nMediator.SEARCH;
    private final JCSuggestBox _suggestBox;
    private final TextBoxWithDescription _suggestTextBoxWidget;
    private final InlineFeedbackWidget _inlineFeedbackWidget;
    private boolean _displayErrorInlineWhileValidation = false;
    private final List<OnSuggestionSelectHandler> _selectHandler = new ArrayList();
    private DataSuggestion<PersonSuggest> _typeAheadSelectedPerson;

    public PersonSelectWidget() {
        this((SuggestOracle)new PersonSolrSuggestOracle(), "person-select-suggest-popup");
    }

    public PersonSelectWidget(@Nonnull String suggestPopupCssClass) {
        this((SuggestOracle)new PersonSolrSuggestOracle(), suggestPopupCssClass);
    }

    public PersonSelectWidget(@Nonnull SuggestOracle suggestOracle) {
        this(suggestOracle, null);
    }

    public PersonSelectWidget(@Nonnull SuggestOracle suggestOracle, @Nullable String suggestPopupCssClass) {
        this._inlineFeedbackWidget = new InlineFeedbackWidget();
        this._suggestTextBoxWidget = new TextBoxWithDescription();
        this._suggestBox = new JCSuggestBox(suggestOracle, (ValueBoxBase)this._suggestTextBoxWidget, suggestPopupCssClass);
        this._suggestBox.setStyleName("gwt-TextBox");
        this._suggestBox.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._suggestBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Widget)this._suggestBox);
        this.add((Widget)this._inlineFeedbackWidget);
        this._suggestTextBoxWidget.setDescriptionText(SEARCH.enterUserName());
    }

    protected void setValue(PersonSuggest oldValue, PersonSuggest newValue, boolean fireEvents) {
        this._suggestTextBoxWidget.setValue((Object)"");
        super.setValue((Object)oldValue, (Object)newValue, fireEvents);
    }

    public void clearError() {
        this._inlineFeedbackWidget.hide();
    }

    public void displayErrorMessage(String errorMessage) {
        this._inlineFeedbackWidget.setMessage(errorMessage);
        this._inlineFeedbackWidget.show(InlineFeedbackWidget.InlineType.ERROR);
    }

    public void validate() throws ValidationException {
        this.clearError();
        if (this.getValue() == null && !StringUtil.isBlank((String)this._suggestBox.getValue())) {
            if (this._displayErrorInlineWhileValidation) {
                this.displayErrorMessage("TODO bitte was eingeben");
            }
            throw new ValidationException("TODO bitte was eingeben");
        }
    }

    public void setDisplayErrorInlineWhileValidation(boolean displayErrorInlineWhileValidation) {
        this._displayErrorInlineWhileValidation = displayErrorInlineWhileValidation;
    }

    public boolean isDisplayErrorInlineWhileValidation() {
        return this._displayErrorInlineWhileValidation;
    }

    public String getText() {
        return this._suggestBox.getText();
    }

    public void addOnSuggestionSelectHandler(OnSuggestionSelectHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this._selectHandler.add(handler);
    }

    public void initValue(@Nonnull PersonTeaserModel person) {
        this._suggestBox.setValue(person.getFullName(), false);
        PersonSuggest suggest = new PersonSuggest();
        suggest.setId((SearchableId)((PersonId)person.getId()));
        suggest.setBlocked(person.isBlocked());
        suggest.setActive(person.isActive());
        super.setValue((Object)((PersonSuggest)this.getValue()), (Object)suggest, false);
    }

    public void setWidth(String width) {
        super.setWidth(width);
        this._suggestBox.setWidth(width);
    }

    public void setText(String text) {
        this._suggestBox.setText(text);
    }

    public void setFocus(boolean focused) {
        this._suggestBox.setFocus(focused);
    }

    public void markTextAsSelected() {
        this._suggestTextBoxWidget.selectAll();
    }

    public void setSuggestPopupStyle(@Nonnull String styleName, boolean add) {
        this._suggestBox.setSuggestPopupStyleName(styleName, add);
    }

    static /* synthetic */ void access$001(PersonSelectWidget x0, Object x1, Object x2, boolean x3) {
        super.setValue(x1, x2, x3);
    }

    static /* synthetic */ void access$101(PersonSelectWidget x0, Object x1, Object x2, boolean x3) {
        super.setValue(x1, x2, x3);
    }
}

