/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.form.impl.EditDynamicAttributePresenter;
import de.justsoftware.onx.common.presentation.client.ui.form.impl.Section;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeEditModel;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.DynamicEntityAttributesMessages;
import de.justsoftware.onx.common.shared.model.attributes.EntityDynamicAttributeCalculator;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditDynamicAttributesForm;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityDynamicAttributeClientModel;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolation;
import de.justsoftware.onx.validation.shared.model.JucoValidationNode;
import de.justsoftware.onx.validation.shared.model.JucoValidationPath;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityEditDynamicAttributesForm
extends Composite
implements EditDynamicAttributePresenter.DynamicAttributesChangedHandler {
    private static final EntityEditDynamicAttributesFormUIBinder UI_BINDER = (EntityEditDynamicAttributesFormUIBinder)GWT.create(EntityEditDynamicAttributesFormUIBinder.class);
    @UiField(provided=true)
    final EntityConstants _entityConstants;
    private final ClientFactory _clientFactory;
    private final FlowPanel _inputContainer;
    private final Section _section;
    private final HashMap<DynamicAttributeId, EditDynamicAttributePresenter<EntityDynamicAttributeConfigViewModel>> _presenterMap = Maps.newHashMap();

    public EntityEditDynamicAttributesForm(@Nonnull EntityType entityType, @Nonnull ImmutableList<EntityDynamicAttributeClientModel> currentValues, @Nonnull ClientFactory clientFactory, boolean embeddedInPopup) {
        String personSuggestPopupStyle;
        this._entityConstants = I18nMediator.getEntityConstantsByEntityType((EntityType)entityType);
        this._section = (Section)UI_BINDER.createAndBindUi((Object)this);
        this.initWidget((Widget)this._section);
        this._inputContainer = new FlowPanel();
        this._section.addControlGroupContainer((Widget)this._inputContainer);
        if (embeddedInPopup) {
            this._section.setLegendVisible(false);
            this._section.addStyleName("small");
            personSuggestPopupStyle = "entity-create-person-select-suggest-popup";
        } else {
            personSuggestPopupStyle = null;
        }
        this._clientFactory = clientFactory;
        this._section.setVisible(false);
        ImmutableListMultimap.Builder currentValuesMapBuilder = ImmutableListMultimap.builder();
        for (EntityDynamicAttributeClientModel attr : currentValues) {
            currentValuesMapBuilder.putAll((Object)attr.getAttributeId(), (Iterable)attr.getValues());
        }
        ImmutableListMultimap currentValuesMap = currentValuesMapBuilder.build();
        this._clientFactory.entityFactory().entityConfigController().getDynamicAttributesConfigForEntityType(entityType, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public EntityEditDynamicAttributesForm(@Nonnull EntityType entityType, @Nonnull ClientFactory clientFactory, boolean embeddedInPopup) {
        this(entityType, ImmutableList.of(), clientFactory, embeddedInPopup);
    }

    @Nonnull
    private EditDynamicAttributePresenter<EntityDynamicAttributeConfigViewModel> createEditAttributePresenter(@Nonnull EntityType entityType, @Nonnull DynamicAttributeConfig attr, @Nonnull DynamicEntityAttributesMessages messages, @Nonnull ImmutableListMultimap<DynamicAttributeId, String> currentValuesMap, @Nullable String personSuggestPopupStyle) {
        return new EditDynamicAttributePresenter((EditDynamicAttributePresenter.DynamicAttributePresenterConfig)new EntityDynamicAttributeConfigViewModel(attr, messages, currentValuesMap.get((Object)attr.getId())), this._clientFactory.entityFactory().entityConstants(entityType), (EditDynamicAttributePresenter.DynamicAttributesChangedHandler)this, (EditDynamicAttributePresenter.InputViewProvider)new /* Unavailable Anonymous Inner Class!! */, this._clientFactory.commonClientFactory());
    }

    @Nonnull
    public ImmutableList<DynamicAttributeEditModel> getValues() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : this._presenterMap.entrySet()) {
            EditDynamicAttributePresenter presenter = (EditDynamicAttributePresenter)entry.getValue();
            DynamicAttributeId id = (DynamicAttributeId)entry.getKey();
            if (id == null || presenter == null) continue;
            builder.add((Object)new DynamicAttributeEditModel(id, ImmutableList.copyOf((Collection)presenter.getValue())));
        }
        return builder.build();
    }

    public void handleConstraintViolations(@Nonnull ImmutableSet<JucoConstraintViolation> violations) {
        for (JucoConstraintViolation violation : violations) {
            JucoValidationPath path = violation.getPropertyPath();
            for (JucoValidationNode node : path) {
                DynamicAttributeId errorId;
                EditDynamicAttributePresenter presenter;
                String name = node.getName();
                Integer index = node.getIndex();
                if (index == null || name == null || (presenter = (EditDynamicAttributePresenter)this._presenterMap.get(errorId = new DynamicAttributeId(name))) == null) continue;
                presenter.setErrorMessage(violation.getMessage(), index.intValue());
            }
        }
    }

    public void clearErrorMessages() {
        for (EditDynamicAttributePresenter presenter : this._presenterMap.values()) {
            presenter.setErrorMessage(null);
        }
    }

    public void valuesChanged() {
        EntityDynamicAttributeCalculator calculator = new EntityDynamicAttributeCalculator((Iterable)this.getValues());
        Iterator iterator = this._presenterMap.values().iterator();
        while (iterator.hasNext()) {
            EditDynamicAttributePresenter presenter;
            DynamicAttributeEditModel calculatedValue = calculator.calculateDynamicAttributes(((EntityDynamicAttributeConfigViewModel)(presenter = (EditDynamicAttributePresenter)iterator.next()).getConfig()).getDynamicAttributeConfig());
            presenter.setValues((List)(calculatedValue != null ? calculatedValue.getValues() : ImmutableList.of()));
        }
    }
}

