/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client;

import com.freiheit.toro.common.presentation.client.ErrorHandlingAsyncCallback;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.model.JsPromise;
import de.justsoftware.onx.common.presentation.client.model.Promise;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.presentation.shared.EntityController;
import de.justsoftware.onx.container.presentation.shared.EntityControllerAsync;
import de.justsoftware.onx.container.shared.model.BreadCrumbViewData;
import de.justsoftware.onx.container.shared.model.ComponentPositionConfig;
import de.justsoftware.onx.container.shared.model.DefaultEntityBaseData;
import de.justsoftware.onx.container.shared.model.EntityBadgeWithRole;
import de.justsoftware.onx.container.shared.model.EntityBaseData;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityExtendedData;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityInfoTabPrivacySettings;
import de.justsoftware.onx.container.shared.model.EntityStatistics;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.EntityTeaser;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.UpdateEntityResponse;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import de.justsoftware.onx.hierarchy.shared.model.EntityTreeItemData;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolation;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

public final class EntityMediator
implements EntityControllerAsync {
    private static final EntityMediator INSTANCE = new EntityMediator();
    private static final EventManager EVENT_MANAGER = ClientFactoryImpl.INSTANCE.eventManager();
    private final EntityControllerAsync _service = (EntityControllerAsync)GWT.create(EntityController.class);
    private EntityId _lastChangedEntityId;
    private EntityId _currentEntityId;
    private EntityId _currentLayoutEntityId;
    private EntityDetails _currentEntityCache;

    private EntityMediator() {
        UrlUtil.setRemoteServiceUrl((Object)this._service, (String)"/entity");
    }

    @Nonnull
    public static EntityMediator getInstance() {
        return INSTANCE;
    }

    private <E> AsyncCallback<E> withClearCache(AsyncCallback<E> callback) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void createEntity(EntityBaseData entityBaseData, EntityId parentId, AsyncCallback<EntityId> callback) {
        this._service.createEntity(entityBaseData, parentId, callback);
    }

    public void deleteEntity(EntityId id, AsyncCallback<Void> callback) {
        this._service.deleteEntity(id, callback);
    }

    public void getDetailsById(EntityId id, AsyncCallback<EntityDetails> callback) {
        this._service.getDetailsById(id, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getCurrentEntityCached(@Nonnull AsyncCallback<EntityDetails> callback) {
        if (this._currentEntityCache != null) {
            callback.onSuccess((Object)this._currentEntityCache);
        } else {
            this.getDetailsById(this._currentEntityId, callback);
        }
    }

    @Nonnull
    public Promise<EntityDetails, Throwable> getDetailsById(@Nonnull EntityId id) {
        return JsPromise.create((resolve, reject) -> {
            AsyncCallback callback = JsPromise.createPromiseAsyncCallback((JsPromise.JsExecutorCallbackFunction)resolve, (JsPromise.JsExecutorCallbackFunction)reject);
            if (id.equals((Object)this.getCurrentEntityId())) {
                this.getCurrentEntityCached(callback);
            } else {
                this.getDetailsById(id, callback);
            }
        });
    }

    public void getInfoById(EntityId id, AsyncCallback<EntityInfo> callback) {
        this._service.getInfoById(id, callback);
    }

    public void getInfoMapByIds(ImmutableSet<EntityId> ids, AsyncCallback<ImmutableMap<EntityId, EntityInfo>> callback) {
        this._service.getInfoMapByIds(ids, callback);
    }

    public void updateEntityBaseData(EntityBaseData entityBaseData, boolean notifyMemberDataChange, AsyncCallback<UpdateEntityResponse> callback) {
        this._service.updateEntityBaseData(entityBaseData, notifyMemberDataChange, callback);
    }

    public void updateEntityDescription(EntityId entityId, String description, boolean notifyMemberDataChange, AsyncCallback<UpdateEntityResponse> callback) {
        this._service.updateEntityDescription(entityId, description, notifyMemberDataChange, callback);
    }

    public void setEntityComponentPositions(EntityId entityId, ImmutableList<ComponentPositionConfig> positions, AsyncCallback<Void> callback) {
        this._service.setEntityComponentPositions(entityId, positions, callback);
    }

    public void getBadgesByEntityTypeAndPerson(EntityType type, PersonId personId, int offset, int limit, AsyncCallback<ListAndCount<EntityBadgeWithRole>> callback) {
        this._service.getBadgesByEntityTypeAndPerson(type, personId, offset, limit, callback);
    }

    public EntityId getLastChangedEntityId() {
        return this._lastChangedEntityId;
    }

    public EntityId getCurrentEntityId() {
        return this._currentEntityId;
    }

    public void setCurrentEntityId(@Nullable EntityId currentEntityId) {
        EntityId oldId = this._currentEntityId;
        this._currentEntityId = currentEntityId;
        if (oldId != null && this._currentEntityId != null && !oldId.equals((Object)this._currentEntityId)) {
            this._currentEntityCache = null;
            this._lastChangedEntityId = oldId;
        }
    }

    public void breadcrumb(GlobalId itemId, EntityId currentEntityId, EntityId currentLayoutEntityId, AsyncCallback<BreadCrumbViewData> callback) {
        this._service.breadcrumb(itemId, currentEntityId, currentLayoutEntityId, callback);
    }

    public void deleteIcon(EntityId id, AsyncCallback<Void> callback) {
        this._service.deleteIcon(id, callback);
    }

    public void deleteLogo(EntityId id, AsyncCallback<Void> callback) {
        this._service.deleteLogo(id, callback);
    }

    @ParametersAreNonnullByDefault
    public void deleteSlideshowImage(EntityId id, ErrorHandlingAsyncCallback<Void> callback) {
        this._service.deleteSlideshowImage(id, callback);
    }

    @ParametersAreNonnullByDefault
    public void saveEntityPrivacy(EntityExtendedData privacySettings, AsyncCallback<Void> callback) {
        this._service.saveEntityExtendedData(privacySettings, callback);
    }

    public EntityId getCurrentLayoutEntityId() {
        return this._currentLayoutEntityId;
    }

    public void setCurrentLayoutEntityId(EntityId currentLayoutEntityId) {
        this._currentLayoutEntityId = currentLayoutEntityId;
    }

    public void getInfoForTypes(ImmutableSet<EntityType> types, int offset, int limit, AsyncCallback<ListAndCount<EntityInfo>> callback) {
        this._service.getInfoForTypes(types, offset, limit, callback);
    }

    public void getParentSuggestionsForType(EntityId childId, ImmutableSet<EntityType> parentTypes, ImmutableSet<EntityId> selectedParents, int offset, int numberOfResults, AsyncCallback<ListAndCount<EntityInfo>> callback) {
        this._service.getParentSuggestionsForType(childId, parentTypes, selectedParents, offset, numberOfResults, callback);
    }

    public void checkParentEntityAssigmentAllowed(@Nullable EntityId childEntityId, EntityType childType, EntityId parentEntityId, AsyncCallback<Void> callback) {
        this._service.checkParentEntityAssigmentAllowed(childEntityId, childType, parentEntityId, callback);
    }

    public void getDirectChildEntityTree(EntityId parentId, ImmutableSet<EntityType> typesForTree, AsyncCallback<ImmutableList<EntityTreeItemData>> callback) {
        this._service.getDirectChildEntityTree(parentId, typesForTree, callback);
    }

    public void getEntityTreeWithParentNodeByEntityId(EntityId id, ImmutableSet<EntityType> treeEntityTypes, AsyncCallback<ImmutableList<EntityTreeItemData>> callback) {
        this._service.getEntityTreeWithParentNodeByEntityId(id, treeEntityTypes, callback);
    }

    public void getPrivacySelectedAuthorityNames(EntityId id, DBPrivacyType type, AsyncCallback<ImmutableSet<String>> callback) {
        this._service.getPrivacySelectedAuthorityNames(id, type, callback);
    }

    public void defaultNewEntity(EntityId parentId, EntityType entityType, String defaultName, Date defaultDate, AsyncCallback<DefaultEntityBaseData> callback) {
        this._service.defaultNewEntity(parentId, entityType, defaultName, defaultDate, callback);
    }

    public void validateEntityBaseData(EntityBaseData baseData, AsyncCallback<ImmutableSet<JucoConstraintViolation>> callback) {
        this._service.validateEntityBaseData(baseData, callback);
    }

    @Deprecated
    public void getPersonTeaserModelsForDynamicAttributes(ImmutableSet<PersonId> ids, AsyncCallback<Map<PersonId, PersonTeaserModel>> callback) {
        this._service.getPersonTeaserModelsForDynamicAttributes(ids, callback);
    }

    public void getAdminInheritanceParentsByEntityId(EntityId id, boolean includeOwnEntity, AsyncCallback<ImmutableList<EntityInfo>> callback) {
        this._service.getAdminInheritanceParentsByEntityId(id, includeOwnEntity, callback);
    }

    public void getMemberInheritanceParentsByEntityId(EntityId id, boolean includeOwnEntity, AsyncCallback<ImmutableList<EntityInfo>> callback) {
        this._service.getMemberInheritanceParentsByEntityId(id, includeOwnEntity, callback);
    }

    public void getAllowedEntitySearchActions(EntityId entityId, AsyncCallback<ImmutableSet<Action>> callback) {
        this._service.getAllowedEntitySearchActions(entityId, callback);
    }

    public void deleteSlideshowImage(EntityId id, AsyncCallback<Void> callback) {
        this._service.deleteSlideshowImage(id, callback);
    }

    public void saveEntityExtendedData(EntityExtendedData privacySettings, AsyncCallback<Void> callback) {
        this._service.saveEntityExtendedData(privacySettings, callback);
    }

    public void getAllowedEntitySearchActions(ImmutableSet<EntityId> entities, AsyncCallback<HashMap<EntityId, ImmutableSet<Action>>> cb) {
        this._service.getAllowedEntitySearchActions(entities, cb);
    }

    public void updateEntityTitle(EntityId entityId, String newTitle, AsyncCallback<Void> callback) {
        this._service.updateEntityTitle(entityId, newTitle, this.withClearCache(callback));
    }

    public void getTeaser(EntityId entityId, AsyncCallback<EntityTeaser> callback) {
        this._service.getTeaser(entityId, callback);
    }

    public void getTeaser(ImmutableSet<EntityId> entityIds, AsyncCallback<HashMap<EntityId, EntityTeaser>> callback) {
        this._service.getTeaser(entityIds, callback);
    }

    public void getStatisticsById(EntityId entityId, AsyncCallback<EntityStatistics> callback) {
        this._service.getStatisticsById(entityId, callback);
    }

    public void getEntityInfoTabPrivacySettings(EntityId entityId, AsyncCallback<EntityInfoTabPrivacySettings> callback) {
        this._service.getEntityInfoTabPrivacySettings(entityId, callback);
    }

    public void getEntityAnchors(EntityId entityId, AsyncCallback<ImmutableSet<String>> callback) {
        this._service.getEntityAnchors(entityId, callback);
    }

    public void getEntityAnchors(ImmutableSet<EntityId> entities, AsyncCallback<HashMap<EntityId, ImmutableSet<String>>> callback) {
        this._service.getEntityAnchors(entities, callback);
    }

    public void getTabForHash(EntityId entityId, String hash, AsyncCallback<EntityTab> callback) {
        this._service.getTabForHash(entityId, hash, callback);
    }
}

