/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.teasers;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.EntityMemberRoleNameFunction;
import de.justsoftware.onx.common.presentation.client.ui.teasers.EntityLineWithRoleTeaserWidget;
import de.justsoftware.onx.common.shared.model.ComponentModel;
import de.justsoftware.onx.common.shared.util.Optionals;
import de.justsoftware.onx.components.presentation.client.ui.AnchorPanel;
import de.justsoftware.onx.container.presentation.client.EntityUtils;
import de.justsoftware.onx.container.presentation.client.ui.EntityIconCreator;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.shared.model.ComponentWidth;
import de.justsoftware.onx.container.shared.model.EntityBadgeWithRole;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityLineWithRoleTeaserWidget
extends Composite {
    private static final EntityLineWithRoleTeaserWidgetUIBinder UI_BINDER = (EntityLineWithRoleTeaserWidgetUIBinder)GWT.create(EntityLineWithRoleTeaserWidgetUIBinder.class);
    @UiField(provided=true)
    Panel _imagePanel;
    @UiField
    SimplePanel _name;
    @UiField
    Label _role;

    public EntityLineWithRoleTeaserWidget(@Nonnull EntityInfo teaser, boolean first, boolean last) {
        this(teaser, first, last, ImmutableSet.of(), null);
    }

    public EntityLineWithRoleTeaserWidget(@Nonnull EntityBadgeWithRole data, boolean first, boolean last, @Nullable ComponentModel componentModel) {
        this((EntityInfo)data.getBadge(), first, last, (ImmutableSet)data.getRoles(), componentModel);
    }

    private EntityLineWithRoleTeaserWidget(@Nonnull EntityInfo teaser, boolean first, boolean last, @Nonnull ImmutableSet<EntityMemberRole> roles, @Nullable ComponentModel componentModel) {
        this.initEntityInfo(teaser, first, last, roles, componentModel);
        this.initEntityName(teaser);
    }

    private void initEntityInfo(@Nonnull EntityInfo teaser, boolean first, boolean last, @Nonnull ImmutableSet<EntityMemberRole> roles, @Nullable ComponentModel componentModel) {
        Widget icon = EntityIconCreator.DEFAULT.create(teaser);
        if (teaser.isVisible()) {
            AnchorPanel imageAnchor = new AnchorPanel();
            imageAnchor.setTargetHistoryToken(EntityOverviewHandler.token((EntityId)((EntityId)teaser.getId())));
            this._imagePanel = imageAnchor;
        } else {
            this._imagePanel = new FlowPanel();
        }
        this._imagePanel.add(icon);
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this.initStyles(first, last);
        if (componentModel != null && componentModel.getPositionConfig().getWidth() != ComponentWidth.NARROW) {
            this.addStyleName("badge-with-roles");
            this._role.setText(Joiner.on((String)", ").skipNulls().join((Iterable)FluentIterable.from(roles).transform((Function)new EntityMemberRoleNameFunction((EntityType)teaser.getType())).transform(Optionals.orNullFunction())));
        }
    }

    private void initStyles(boolean first, boolean last) {
        if (first) {
            this.getWidget().addStyleName("first");
        }
        if (last) {
            this.getWidget().addStyleName("last");
        }
        if (first && last) {
            this.getWidget().addStyleName("only");
        }
    }

    private void initEntityName(@Nonnull EntityInfo teaser) {
        this._name.setWidget(EntityUtils.createEntityNameLinkOrLabel((EntityInfo)teaser, (EntityUtils.EntityLinkOptions)EntityUtils.EntityLinkOptions.create()));
    }
}

