/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.teasers;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.InlineHyperlink;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.InlineCheckBox;
import de.justsoftware.onx.common.presentation.client.ui.teasers.EntityInheritMemberTeaserWidget;
import de.justsoftware.onx.common.shared.model.ParentEntityConfig;
import de.justsoftware.onx.container.presentation.client.EntityParent;
import de.justsoftware.onx.container.presentation.client.EntityUtils;
import de.justsoftware.onx.container.presentation.client.presenter.InheritsParentListOverlayPresenter;
import de.justsoftware.onx.container.presentation.client.ui.EntityLogoCreator;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityInheritMemberTeaserWidget
extends Composite {
    private static final EntityInheritMemberTeaserWidgetUIBinder UI_BINDER = (EntityInheritMemberTeaserWidgetUIBinder)GWT.create(EntityInheritMemberTeaserWidgetUIBinder.class);
    @UiField
    InlineCheckBox _inheritAdmins;
    @UiField
    InlineCheckBox _inheritMembers;
    @UiField(provided=true)
    final Widget _logo;
    @UiField
    SimplePanel _name;
    @UiField
    Label _type;
    @UiField
    DivElement _inheritMembersDiv;
    @UiField
    DivElement _inheritAdminsDiv;
    private boolean _initialized = false;
    private EntityParent _entityParent = null;
    private EntityType _childType = null;

    public EntityInheritMemberTeaserWidget(@Nonnull EntityInfo teaser) {
        Widget logo = EntityLogoCreator.DEFAULT.create(teaser, false);
        if (logo != null) {
            logo.addStyleName("logo");
            this._logo = logo;
        } else {
            this._logo = new InlineLabel();
            this._logo.setVisible(false);
        }
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        if (logo == null) {
            this._logo.removeFromParent();
        }
        EntityType type = (EntityType)teaser.getType();
        String name = EntityUtils.getStartAtNamePrefix((EntityInfo)teaser) + teaser.getName();
        if (teaser.isVisible()) {
            this._name.setWidget((Widget)new InlineHyperlink(name, EntityOverviewHandler.token((EntityId)((EntityId)teaser.getId()))));
        } else {
            this._name.setWidget((Widget)new InlineLabel(name));
        }
        this._type.setText(I18nMediator.getEntityConstantsByEntityType((EntityType)type).entity(type));
    }

    public void setEntityParent(@Nonnull EntityParent entityParent, @Nullable EntityType childType, boolean reloadState, @Nullable ParentEntityConfig config) {
        this._entityParent = entityParent;
        this._childType = childType;
        this._inheritAdminsDiv.getStyle().setVisibility(config != null && config.isInheritsAdminEnabled() ? Style.Visibility.VISIBLE : Style.Visibility.HIDDEN);
        this._inheritMembersDiv.getStyle().setVisibility(config != null && config.isInheritsMemberEnabled() ? Style.Visibility.VISIBLE : Style.Visibility.HIDDEN);
        if (!this._initialized || reloadState) {
            this._initialized = true;
            this._inheritAdmins.setValue(Boolean.valueOf(entityParent.isInheritAdmins()));
            this._inheritMembers.setValue(Boolean.valueOf(entityParent.isInheritMembers()));
        }
    }

    @UiHandler(value={"_inheritAdmins"})
    void onInheritAdminValueChange(@Nonnull ValueChangeEvent<Boolean> event) {
        if (this._entityParent != null) {
            this._entityParent.setInheritAdmins(Boolean.TRUE.equals(event.getValue()));
        }
    }

    @UiHandler(value={"_inheritMembers"})
    void onInheritMemberValueChange(@Nonnull ValueChangeEvent<Boolean> event) {
        if (this._entityParent != null) {
            this._entityParent.setInheritMembers(Boolean.TRUE.equals(event.getValue()));
        }
    }

    @UiHandler(value={"_showInheritedMembersAnchor"})
    void onClickShowInheritMembers(@Nonnull ClickEvent event) {
        Object source = event.getSource();
        if (source instanceof Widget && this._entityParent != null && this._childType != null) {
            new InheritsParentListOverlayPresenter.EntityMemberInheritsParentListOverlayPresenter().togglePopup((EntityId)this._entityParent.getParentEntity().getId(), this._childType, (Widget)source);
        }
    }

    @UiHandler(value={"_showInheritedAdminsAnchor"})
    void onClickShowInheritAdmins(@Nonnull ClickEvent event) {
        Object source = event.getSource();
        if (source instanceof Widget && this._entityParent != null && this._childType != null) {
            new InheritsParentListOverlayPresenter.EntityAdminInheritsParentListOverlayPresenter().togglePopup((EntityId)this._entityParent.getParentEntity().getId(), this._childType, (Widget)source);
        }
    }
}

