/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.overlay;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.freiheit.toro.util.client.LoggingUtil;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.album.presentation.client.ui.AlbumOverviewHandler;
import de.justsoftware.onx.album.shared.model.Album;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImage;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.PageTitleServiceImpl;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.InPlaceEditLabel;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.common.presentation.client.ui.WaitSpinner;
import de.justsoftware.onx.common.presentation.client.ui.components.MediaCaption;
import de.justsoftware.onx.common.presentation.client.ui.overlay.ContentDetailsWidget;
import de.justsoftware.onx.common.presentation.client.ui.overlay.ContentOverlay;
import de.justsoftware.onx.common.presentation.client.ui.overlay.ContentOverlayDescriptor;
import de.justsoftware.onx.common.presentation.client.ui.overlay.EditableContentDetailsTypeSpecificWidget;
import de.justsoftware.onx.common.presentation.client.ui.overlay.LoadContentOverlayAsyncCallback;
import de.justsoftware.onx.common.presentation.shared.model.ContentOverlayObject;
import de.justsoftware.onx.common.presentation.shared.model.ContentOverlayParent;
import de.justsoftware.onx.common.shared.model.JCMediaContent;
import de.justsoftware.onx.common.shared.model.JCMediaContentId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.presentation.client.ui.EntityLogoCreator;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.presentation.client.ui.ReactProfileComponent;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemIdVisitor;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ContentOverlay
extends Composite {
    private static final ContentOverlayUiBinder UIBINDER = (ContentOverlayUiBinder)GWT.create(ContentOverlayUiBinder.class);
    @UiField
    SimplePanel _contentInner;
    @UiField
    Label _title;
    @UiField
    Label _position;
    @UiField
    HTMLPanel _contentMeasurePanel;
    @UiField
    SimplePanel _parentItemPanel;
    @UiField
    SimplePanel _itemDetailsPanel;
    @UiField
    JCIconOnlyAnchor _pagerLeft;
    @UiField
    JCIconOnlyAnchor _pagerRight;
    @UiField
    JCIconOnlyAnchor _closeIcon;
    private String _lastToken;
    private ContentOverlayParent _handleDeeplink = null;
    private final EventManager _eventManager;
    private final ClientFactory _clientFactory;
    private final PageTitleServiceImpl.PageTitleResetCallback _titleResetCallback;
    private HandlerRegistration _escapeKeyHandlerRegistration = null;
    private ContentOverlayParent _parent;
    private JCMediaContentId _previous;
    private JCMediaContentId _next;

    public ContentOverlay(@Nullable String lastToken, @Nonnull ClientFactory clientFactory, @Nonnull PageTitleServiceImpl.PageTitleResetCallback titleResetCallback) {
        this._lastToken = lastToken;
        this._clientFactory = clientFactory;
        this._eventManager = this._clientFactory.eventManager();
        this._titleResetCallback = titleResetCallback;
        this.initWidget((Widget)UIBINDER.createAndBindUi((Object)this));
        this._closeIcon.setTitle(I18nMediator.BASIC_CONSTANTS.close());
        this._contentMeasurePanel.addDomHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, ClickEvent.getType());
    }

    @UiHandler(value={"_closeIcon"})
    public void closeOverlay(@Nullable ClickEvent event) {
        this.closeOverlay();
    }

    private void addLoadingIcons() {
        this.setParentWidget((Widget)new WaitSpinner(IconSize.TWO_TIMES));
        this.setDetailsWidget((Widget)new WaitSpinner(IconSize.TWO_TIMES));
        this.setContentWidget((Widget)new WaitSpinner(IconSize.FOUR_TIMES));
    }

    public void closeOverlay() {
        if (this.isAttached()) {
            this.hide();
            this._clientFactory.historyManager().ignoreNextHistoryChange();
            this._titleResetCallback.reset();
            String lastToken = StringUtil.isBlank((String)this._lastToken) ? "!" : this._lastToken;
            LoggingUtil.info((Object)this, (String)("HistoryManager: closed overlay, going to: " + lastToken));
            History.newItem((String)lastToken);
        }
    }

    private void setParentItemInfoWidget(@Nonnull GlobalId parentId) {
        parentId.accept((ItemIdVisitor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setParentId(@Nonnull GlobalId itemId, @Nonnull GlobalId parentId) {
        this.setParentItemInfoWidget(parentId);
        if (this._handleDeeplink != null) {
            this._handleDeeplink.accept((ContentOverlayParent.Visitor)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void setParentWidget(@Nonnull Widget parentWidget) {
        this._parentItemPanel.setWidget(parentWidget);
    }

    private void setDetailsWidget(@Nonnull Widget detailsWidget) {
        this._itemDetailsPanel.setWidget(detailsWidget);
    }

    protected void setContentDetailsWidget(@Nonnull ContentDetailsWidget<?> detailsWidget) {
        this.setDetailsWidget(detailsWidget);
    }

    public void setContentWidget(@Nonnull Widget contentWidget) {
        this._contentInner.setWidget(contentWidget);
    }

    public int getContentWidth() {
        return this._contentMeasurePanel.getOffsetWidth();
    }

    public int getContentHeight() {
        return this._contentMeasurePanel.getOffsetHeight();
    }

    public <I extends JCMediaContentId, T extends JCMediaContent<I>> void show(@Nonnull I itemId, @Nonnull ContentOverlayParent contentOverlayParent, @Nonnull ContentOverlayDescriptor<I, T> overlay, boolean handleDeeplink) {
        if (handleDeeplink) {
            this.handleDeeplink(contentOverlayParent);
        }
        this.addLoadingIcons();
        if (!this.isAttached()) {
            RootPanel.get().add((Widget)this);
        }
        RootPanel.getBodyElement().addClassName("overflowHidden");
        overlay.load(itemId, contentOverlayParent, new LoadContentOverlayAsyncCallback(this, contentOverlayParent, overlay));
    }

    public void hide() {
        if (this.isAttached()) {
            this._contentInner.getWidget().setVisible(false);
            this.removeFromParent();
        }
        RootPanel.getBodyElement().removeClassName("overflowHidden");
    }

    @Nonnull
    public <T extends JCMediaContent<?>> ContentDetailsWidget<T> createDetailsWidget(@Nonnull T content, @Nonnull InPlaceEditLabel title, @Nonnull ContentDetailsWidget.OnSave onSave, @Nonnull EditableContentDetailsTypeSpecificWidget editableContent, @Nonnull Widget info) {
        ContentDetailsWidget detailsWidget = new ContentDetailsWidget(content, title, onSave, editableContent, info, this._clientFactory);
        this.setContentDetailsWidget(detailsWidget);
        return detailsWidget;
    }

    public void updateTitle(@Nullable String title) {
        String text = StringUtil.isBlank((String)title) ? "" : title;
        this._title.setText(text);
        this._title.setTitle(text);
    }

    public void updatePager(@Nonnull ContentOverlayObject<?> result, @Nonnull ContentOverlayParent contentOverlayParent) {
        this._parent = contentOverlayParent;
        this._previous = result.getPrev();
        this._next = result.getNext();
        this.updatePager(this._previous, this._pagerLeft);
        this.updatePager(this._next, this._pagerRight);
        int totalCount = result.getTotalCount();
        this._position.setText(totalCount > 1 ? I18nMediator.BASIC_MESSAGES.positionXOfY(result.getPosition() + 1, totalCount) : "");
    }

    private void updatePager(@Nullable JCMediaContentId otherId, @Nonnull JCIconOnlyAnchor pager) {
        boolean visible = otherId != null;
        pager.setVisible(visible);
        if (visible) {
            pager.setTargetHistoryToken((String)this._parent.accept((ContentOverlayParent.Visitor)new TokenVisitor(otherId)));
        }
    }

    private void handleDeeplink(@Nonnull ContentOverlayParent contentOverlayParent) {
        if (this._lastToken == null) {
            this._handleDeeplink = contentOverlayParent;
        }
    }

    @CheckForNull
    private Void createOverlayParentToken(@Nonnull GlobalId parentId) {
        this._handleDeeplink = null;
        String historyToken = (String)parentId.accept((ItemIdVisitor)new /* Unavailable Anonymous Inner Class!! */);
        if (!StringUtil.isBlank((String)historyToken)) {
            ClientFactoryImpl.INSTANCE.historyManager().onHistoryChanged(historyToken);
            this._lastToken = historyToken;
        }
        return null;
    }

    private void setEntityParentWidget(@Nonnull EntityInfo entity) {
        MediaCaption caption = new MediaCaption();
        caption.setCaption((Widget)new Hyperlink(entity.getName(), EntityOverviewHandler.token((EntityId)((EntityId)entity.getId()))));
        Widget icon = EntityLogoCreator.DEFAULT.create(entity, false);
        if (icon != null) {
            caption.setIcon(icon);
        }
        this.setParentWidget((Widget)caption);
    }

    private void setProfileParentWidget(@Nonnull PersonTeaserModel result) {
        MediaCaption caption = new MediaCaption();
        caption.setCaption((Widget)new Hyperlink(result.getFullName(), ReactProfileComponent.token((PersonId)((PersonId)result.getId()))));
        caption.setIcon((Widget)new Image(ImageUrlUtil.getFullSmallUserImageUrl((String)result.getLogo())));
        this.setParentWidget((Widget)caption);
    }

    private void setAlbumParentWidget(@Nonnull Album result) {
        MediaCaption caption = new MediaCaption();
        caption.setCaption((Widget)new Hyperlink(result.getTitle(), AlbumOverviewHandler.token((AlbumId)result.getId())));
        caption.addSubcaption((Widget)new Label(result.getDescription()));
        AlbumImage albumImage = result.getAlbumImage();
        String filename = albumImage == null ? null : albumImage.getFilename();
        caption.setIcon((Widget)new Image(ImageUrlUtil.getFullAlbumImageUrl((ImageSize)ImageSize.SMALL, (String)filename)));
        this.setParentWidget((Widget)caption);
    }

    protected void onLoad() {
        super.onLoad();
        this._escapeKeyHandlerRegistration = Event.addNativePreviewHandler((Event.NativePreviewHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void onUnload() {
        super.onUnload();
        if (this._escapeKeyHandlerRegistration != null) {
            this._escapeKeyHandlerRegistration.removeHandler();
            this._escapeKeyHandlerRegistration = null;
        }
    }
}

