/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.TextAreaView;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class JustEditor
extends Composite
implements TextAreaView {
    private String _content = "";
    private String _placeholder = "";
    private boolean _focus = false;
    private boolean _readOnly = false;
    private JavaScriptObject _editorInstance = null;
    private final HTMLPanel _container;
    private TextAreaView.Presenter _presenter;

    public JustEditor() {
        this(TextAreaView.Presenter.NOP);
    }

    public JustEditor(TextAreaView.Presenter presenter) {
        this._presenter = presenter;
        this._container = new HTMLPanel("");
        this.initWidget((Widget)this._container);
    }

    public void setPresenter(TextAreaView.Presenter presenter) {
        this._presenter = presenter;
    }

    private void onChange(String content) {
        this._content = content;
        this._presenter.onUpdate();
    }

    private void onBlur(String content) {
        this._content = content;
        this._presenter.onBlur();
    }

    public void onFocus() {
        this._presenter.onFocus();
    }

    public void setFocus(boolean focus) {
        this._focus = focus;
        if (focus && this._editorInstance != null) {
            this.nativeFocus(this._editorInstance);
        }
    }

    public void setEnabled(boolean enabled) {
        this._readOnly = !enabled;
        this.update();
    }

    private native void nativeFocus(JavaScriptObject var1);

    @Nonnull
    public String getContent() {
        return this._content;
    }

    public void setContent(String content) {
        this._content = content;
        this.update();
    }

    public void setPlaceholder(String placeholder) {
        this._placeholder = placeholder;
        this.update();
    }

    protected void onLoad() {
        this._editorInstance = this.initEditor((Element)this.getElement(), this.getOptions());
        this.setFocus(this._focus);
    }

    public void onUnload() {
        if (this._editorInstance != null) {
            this.removeApp(this._editorInstance);
            this._editorInstance = null;
        }
    }

    private void update() {
        if (this._editorInstance != null) {
            this.nativeUpdate(this._editorInstance, (Element)this.getElement(), this.getOptions());
        }
    }

    private native void nativeUpdate(JavaScriptObject var1, Element var2, JavaScriptObject var3);

    @Nonnull
    private native JavaScriptObject getOptions();

    private native void removeApp(JavaScriptObject var1);

    @Nonnull
    private native JavaScriptObject initEditor(Element var1, @Nullable JavaScriptObject var2);
}

