/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.event.dom.client.ClickHandler;
import de.justsoftware.onx.common.shared.util.StringUtil;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class IconAndTooltip {
    private final IconType _icon;
    private final String _tooltip;

    public IconAndTooltip(IconType icon, @Nullable String tooltip) {
        this._icon = icon;
        this._tooltip = tooltip;
    }

    @Nonnull
    public IconType getIcon() {
        return this._icon;
    }

    @CheckForNull
    public String getTooltip() {
        return this._tooltip;
    }

    @Nonnull
    public Icon createIcon() {
        Icon icon = new Icon(this._icon);
        if (!StringUtil.isBlank((String)this._tooltip)) {
            icon.setTitle(this._tooltip);
        }
        return icon;
    }

    @Nonnull
    public IconAnchor createIconAnchor(String targetHistoryToken, @Nullable ClickHandler clickHandler) {
        IconAnchor icon = new IconAnchor();
        icon.setIcon(this._icon);
        icon.setTargetHistoryToken(targetHistoryToken);
        if (!StringUtil.isBlank((String)this._tooltip)) {
            icon.setTitle(this._tooltip);
        }
        if (clickHandler != null) {
            icon.addClickHandler(clickHandler);
        }
        return icon;
    }
}

