/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.presenter;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.InfiniteScrollView;
import de.justsoftware.onx.common.presentation.client.ui.PanelPagingWidgetProvider;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class InfiniteScrollPagingPresenter<T> {
    private final InfiniteScrollView _view;
    private final PanelPagingWidgetProvider<T> _dataProvider;
    private final int _chunkSize = 40;
    private final ClientFactory _clientFactory;
    private int _offset = 0;
    private IsWidget _noDataWidget = null;
    private boolean _loading = false;
    private boolean _noMoreResults = false;
    private int _scrollPosition = -1;

    public InfiniteScrollPagingPresenter(ClientFactory clientFactory, InfiniteScrollView scrollView, PanelPagingWidgetProvider<T> dataProvider) {
        this._clientFactory = clientFactory;
        this._view = scrollView;
        this._dataProvider = dataProvider;
        this._view.addScrollHandler(event -> this.loadMoreIfBottomReached());
        this.init();
    }

    public void restoreScrollPosition() {
        if (this._scrollPosition > -1) {
            this._view.setVerticalScrollPosition(this._scrollPosition);
        }
    }

    @Nonnull
    public InfiniteScrollView getView() {
        return this._view;
    }

    public void start(@Nullable IsWidget noDataWidget) {
        this._view.reset();
        this._offset = 0;
        this._loading = false;
        this._noMoreResults = false;
        this._noDataWidget = noDataWidget;
        this._scrollPosition = -1;
        this.loadMoreIfBottomReached();
    }

    public void showMessage(String message) {
        this._view.showLoadingView(false);
        this._view.showMessages(new String[]{message});
    }

    private void init() {
        this.start(null);
    }

    private void loadMore() {
        this._loading = true;
        this._view.showLoadingView(true);
        this._dataProvider.getListAndCount(this._offset, 40, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadMoreIfBottomReached() {
        this._scrollPosition = this._view.getVerticalScrollPosition();
        if (this._loading || this._noMoreResults) {
            return;
        }
        int contentHeight = this._view.getWidget().getOffsetHeight();
        int containerHeight = this._view.asWidget().getOffsetHeight();
        int hiddenBottom = contentHeight - this._view.getVerticalScrollPosition() - containerHeight;
        if (hiddenBottom < 200) {
            this.loadMore();
        }
    }

    private void showNoDataWidget() {
        if (this._noDataWidget != null) {
            this._view.showNoDataWidget(this._noDataWidget);
        }
    }

    private void showData(ListAndCount<T> data) {
        for (Object entry : data) {
            this._view.addRow(this._dataProvider.createItemWidget(entry, 0, false, false));
        }
    }
}

