/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.comments.presentation.client.ui;

import com.freiheit.toro.client.event.EventListener;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.user.client.ui.MessageComposerPresenter;
import de.justsoftware.gwt.user.client.ui.MessageComposerView;
import de.justsoftware.gwt.user.client.ui.MessageComposerWidgetView;
import de.justsoftware.onx.comments.presentation.client.CommentsMediator;
import de.justsoftware.onx.comments.presentation.client.events.CommentsChangedEvent;
import de.justsoftware.onx.comments.presentation.client.ui.CommentListWidget;
import de.justsoftware.onx.comments.shared.model.GenericComment;
import de.justsoftware.onx.comments.shared.model.HasComments;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.WaitSpinner;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import javax.annotation.Nonnull;

public class CommentListWidget
extends Composite {
    private static final CommentListWidgetUiBinder NORMAL_BINDER = (CommentListWidgetUiBinder)GWT.create(CommentListWidgetUiBinder.class);
    private static final CommentListWidgetNewestFirstUiBinder NEWEST_FIRST_BINDER = (CommentListWidgetNewestFirstUiBinder)GWT.create(CommentListWidgetNewestFirstUiBinder.class);
    @UiField
    HTMLPanel _container;
    @UiField
    FlowPanel _comments;
    @UiField
    SimplePanel _composerPanel;
    @UiField
    DivElement _errors;
    @UiField
    DivElement _moreCommentsContainer;
    @UiField
    Anchor _moreCommentsLink;
    @UiField
    WaitSpinner _waitIcon;
    private MessageComposerPresenter<?> _composer = null;
    private final boolean _newestFirst;
    private final int _maxCommentsShown;
    private final EventManager.EventManagerHelper _eventManagerHelper;
    private String _customInfoDescription;
    private int _commentsCurrentlyShown = 0;
    private HasComments _parent;
    private final ClientFactory _clientFactory;
    private String _customInfo;

    public CommentListWidget(int maxCommentsShown, boolean newestFirst, @Nonnull ClientFactory clientFactory) {
        this._maxCommentsShown = maxCommentsShown;
        this._newestFirst = newestFirst;
        this._clientFactory = clientFactory;
        this._eventManagerHelper = new EventManager.EventManagerHelper(this._clientFactory.eventManager());
        CommentListWidgetNewestFirstUiBinder binder = newestFirst ? NEWEST_FIRST_BINDER : NORMAL_BINDER;
        this.initWidget((Widget)binder.createAndBindUi((Object)this));
    }

    private void addComment(@Nonnull GenericComment comment, boolean atTop) {
        1 presenter = new /* Unavailable Anonymous Inner Class!! */;
        if (atTop) {
            this._comments.insert(presenter.getView(), 0);
        } else {
            this._comments.add(presenter.getView());
        }
    }

    private void fetchComments(@Nonnull HasComments parent, int limit, ListUpdateMode updateAction) {
        this._parent = parent;
        CommentsMediator.getInstance().getCommentsByParentId(parent.getCommentParentId(), limit, this._newestFirst, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void displayError(String message) {
        this._errors.getStyle().setDisplay(Style.Display.BLOCK);
        this._errors.setInnerText(message);
    }

    public void setWidth(String width) {
        this._container.setWidth(width);
    }

    public void fillGUI(@Nonnull ListAndCount<GenericComment> comments, ListUpdateMode updateAction, @Nonnull HasComments parent) {
        this._parent = parent;
        this._comments.clear();
        switch (6.$SwitchMap$de$justsoftware$onx$comments$presentation$client$ui$CommentListWidget$ListUpdateMode[updateAction.ordinal()]) {
            case 1: {
                this.setCommentsCurrentlyShown(comments.size());
                break;
            }
            case 2: {
                this.setCommentsCurrentlyShown(comments.getMaxCount());
            }
        }
        this._moreCommentsContainer.getStyle().setDisplay(Style.Display.NONE);
        this._errors.getStyle().setDisplay(Style.Display.NONE);
        if (parent.mayComment()) {
            this.createCommentComposer();
        } else {
            this._composer = null;
            this._composerPanel.setWidget(null);
        }
        for (GenericComment comment : comments) {
            this.addComment(comment, false);
        }
        if (comments.size() < comments.getMaxCount()) {
            this._moreCommentsLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            int furtherComments = comments.getMaxCount() - comments.size();
            this._moreCommentsLink.setText(I18nMediator.COMMENTS_MESSAGES.showFurtherComments(furtherComments));
            this._moreCommentsContainer.getStyle().setDisplay(Style.Display.BLOCK);
        }
        this._waitIcon.setVisible(false);
    }

    public void fillGUI(HasComments parent) {
        this.fetchComments(parent, this._maxCommentsShown, ListUpdateMode.SHOW_INIT_OR_EXTEND);
    }

    public void setCustomInfoDescription(String description) {
        this._customInfoDescription = description;
    }

    public void setCustomInfo(String customInfo) {
        this._customInfo = customInfo;
    }

    public void setFocus(boolean focused) {
        if (this._composer != null) {
            this._composer.setFocus(focused);
        }
    }

    private void createCommentComposer() {
        MessageComposerWidgetView composerView = this._clientFactory.commonClientFactory().messageComposerView(I18nMediator.COMMENTS.writeAComment());
        this._composer = new MessageComposerPresenter(this._clientFactory, (MessageComposerPresenter.ParentPresenter)new /* Unavailable Anonymous Inner Class!! */, (MessageComposerView)composerView);
        this._composer.setAutoHideSubmitPanel(true);
        this._composer.setForbiddenTexts(ImmutableSet.of((Object)""));
        this._composer.setSubmitButtonText(I18nMediator.COMMENTS.comment());
        this._composerPanel.setWidget((IsWidget)composerView);
    }

    protected void onLoad() {
        super.onLoad();
        this._eventManagerHelper.registerListener(CommentsChangedEvent.class, (EventListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void onUnload() {
        super.onUnload();
        this._eventManagerHelper.onUnloadRemoveHandlersFromManager();
    }

    private void increaseCommentsCurrentlyShown() {
        ++this._commentsCurrentlyShown;
    }

    private void decreaseCommentsCurrentlyShown() {
        --this._commentsCurrentlyShown;
    }

    private int getCommentsCurrentlyShown() {
        return this._commentsCurrentlyShown;
    }

    private void setCommentsCurrentlyShown(int commentsShown) {
        this._commentsCurrentlyShown = commentsShown;
    }

    public void clear() {
        this._commentsCurrentlyShown = 0;
        this._comments.clear();
    }
}

