/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.account.presentation.server;

import com.freiheit.toro.account.presentation.client.LoginController;
import com.freiheit.toro.account.shared.model.LoginInfoBean;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.FrontendLoginService;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.presentation.server.JucoLocaleResolver;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.Actions;
import de.justsoftware.onx.common.shared.model.action.DynamicActionCreator;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.PersonSettingService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import org.gwtwidgets.server.spring.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginControllerImpl
implements LoginController {
    private static final ImmutableSet<Action> CHECK_ACTIONS = ImmutableSet.of((Object)StaticAction.ADMIN_MODIFY_DEFAULT_DESIGN, (Object)StaticAction.SEARCH_FILTER_BY_BLOCK_STATUS);
    @Autowired
    private PersonService _personService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private EntityConfigService _entityConfigService;
    @Autowired
    private JucoLocaleResolver _localeResolver;
    private final FrontendLoginService _frontendLoginService;
    private final PersonSettingService _personSettingService;

    @Autowired
    public LoginControllerImpl(FrontendLoginService frontendLoginService, PersonSettingService personSettingService) {
        this._frontendLoginService = frontendLoginService;
        this._personSettingService = personSettingService;
    }

    public void logout() {
        this._frontendLoginService.logout(ServletUtils.getRequest(), ServletUtils.getResponse());
    }

    public void setLanguage(String locale) throws ServiceException {
        this._localeResolver.setLanguage(ServletUtils.getRequest(), ServletUtils.getResponse(), locale);
    }

    public LoginInfoBean checkForSession() throws ServiceException {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        PersonId userId = auth.getUserId();
        LoginInfoBean loginInfo = new LoginInfoBean();
        DBPerson person = this._personService.getPersonByIdNotNull(userId);
        loginInfo.setPerson(this._profileTeaserService.getPersonTeaserModelByDBPerson(person, (AuthorizationCheckContextWithLocale)auth));
        loginInfo.setMay(this.getCheckedActions(auth));
        loginInfo.setPersonSettings(this._personSettingService.getSettings(userId));
        return loginInfo;
    }

    private ImmutableSet<Action> getCheckedActions(AuthorizationContext auth) {
        return auth.may(ImmutableSet.builder().addAll((Iterable)Actions.createEntityTypeBasedAction((DynamicActionCreator)DynamicActionCreator.ENTITY_CREATE, (Iterable)this._entityConfigService.getOrderedEntityTypes())).addAll((Iterable)CHECK_ACTIONS).build());
    }

    public void loggedOutFromAllMobileDevices(PersonId personId) throws ServiceException {
        this._frontendLoginService.loggedOutFromAllMobileDevices(personId, (AuthorizationCheckContext)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
    }
}

