/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.search.business;

import de.justsoftware.search.authorization.AuthorizationContext;
import de.justsoftware.search.business.PermissionService;
import de.justsoftware.search.business.SearchService;
import de.justsoftware.search.business.model.SearchResult;
import de.justsoftware.search.business.model.SearchResultParentDto;
import de.justsoftware.search.business.model.SolrSearchResult;
import de.justsoftware.search.business.model.SolrSearchResultDto;
import de.justsoftware.search.business.model.SortBy;
import de.justsoftware.search.business.model.SortDirection;
import de.justsoftware.search.model.JustSocialSolrCoreSearchFields;
import de.justsoftware.search.shared.model.JustApp;
import de.justsoftware.search.shared.model.ProfileId;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.TenantId;
import de.justsoftware.search.util.CollectionUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006Ji\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0019\b\u0002\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\b\u001cH\u0012J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0017H\u0012JH\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\bH\u0012Jo\u0010'\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0019\b\u0002\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\b\u001cH\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/justsoftware/search/business/SearchService;", "", "solrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "permissionService", "Lde/justsoftware/search/business/PermissionService;", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/search/business/PermissionService;)V", "buildSolrQuery", "Lorg/apache/solr/client/solrj/SolrQuery;", "query", "", "apps", "", "Lde/justsoftware/search/shared/model/JustApp;", "sortBy", "Lde/justsoftware/search/business/model/SortBy;", "sortDirection", "Lde/justsoftware/search/business/model/SortDirection;", "profileId", "Lde/justsoftware/search/shared/model/ProfileId;", "tenantId", "Lde/justsoftware/search/shared/model/TenantId;", "offset", "", "count", "configure", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "buildSolrQueryForNames", "search", "Lde/justsoftware/search/business/model/SearchResult;", "Lde/justsoftware/search/business/model/SolrSearchResultDto;", "authContext", "Lde/justsoftware/search/authorization/AuthorizationContext;", "app", "send", "Lorg/apache/solr/client/solrj/response/QueryResponse;", "solrQuery", "sendSolrQuery", "Companion", "search-service"})
@SourceDebugExtension(value={"SMAP\nSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchService.kt\nde/justsoftware/search/business/SearchService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 CollectionUtils.kt\nde/justsoftware/search/util/CollectionUtilsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 LoggerUtils.kt\nde/justsoftware/search/util/LoggerUtilsKt\n*L\n1#1,189:1\n1194#2,2:190\n1222#2,4:192\n1855#2:196\n1238#2,4:206\n1238#2,4:212\n1856#2:216\n1611#2:218\n1855#2:219\n1856#2:222\n1612#2:223\n1179#2,2:224\n1253#2,4:226\n2634#2:230\n1549#2:232\n1620#2,3:233\n478#3,7:197\n468#3:204\n414#3:205\n453#3:210\n403#3:211\n10#4:217\n1#5:220\n1#5:221\n1#5:231\n8#6:236\n7#6,3:237\n*S KotlinDebug\n*F\n+ 1 SearchService.kt\nde/justsoftware/search/business/SearchService\n*L\n82#1:190,2\n82#1:192,4\n84#1:196\n92#1:206,4\n95#1:212,4\n84#1:216\n104#1:218\n104#1:219\n104#1:222\n104#1:223\n111#1:224,2\n111#1:226,4\n116#1:230\n124#1:232\n124#1:233,3\n90#1:197,7\n92#1:204\n92#1:205\n95#1:210\n95#1:211\n104#1:217\n104#1:221\n116#1:231\n176#1:236\n176#1:237,3\n*E\n"})
public class SearchService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SolrClient solrClient;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String REQUESTED_FIELDS;
    @NotNull
    private static final String REQUESTED_FIELDS_FOR_PARENT_INFO;

    public SearchService(@Qualifier(value="justSocialCoreLeaderSolrClient") @NotNull SolrClient solrClient, @NotNull PermissionService permissionService) {
        Intrinsics.checkNotNullParameter((Object)solrClient, (String)"solrClient");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        this.solrClient = solrClient;
        this.permissionService = permissionService;
    }

    @NotNull
    public SearchResult<SolrSearchResultDto> search(@NotNull AuthorizationContext authContext, @NotNull String query, int offset, int count, @Nullable JustApp app, @NotNull SortBy sortBy, @NotNull SortDirection sortDirection) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sortBy, (String)"sortBy");
        Intrinsics.checkNotNullParameter((Object)sortDirection, (String)"sortDirection");
        JustApp justApp = app;
        List list = justApp != null ? CollectionsKt.listOf((Object)justApp) : CollectionsKt.emptyList();
        ProfileId profileId = authContext.getProfileId();
        TenantId tenantId = authContext.getTenantId();
        return SearchService.sendSolrQuery$default((SearchService)this, (String)query, (List)list, (SortBy)sortBy, (SortDirection)sortDirection, (ProfileId)profileId, (TenantId)tenantId, (int)offset, (int)count, null, (int)256, null);
    }

    /*
     * WARNING - void declaration
     */
    private SearchResult<SolrSearchResultDto> sendSolrQuery(String query, List<? extends JustApp> apps, SortBy sortBy, SortDirection sortDirection, ProfileId profileId, TenantId tenantId, int offset, int count, Function1<? super SolrQuery, Unit> configure) {
        Collection<SolrSearchResultDto> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SolrSearchResult result;
        Iterable $this$associateTo$iv$iv;
        void $this$associate$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        QueryResponse searchQueryResponse = this.send(this.buildSolrQuery(query, apps, sortBy, sortDirection, profileId, tenantId, offset, count, configure));
        List list = searchQueryResponse.getBeans(SolrSearchResult.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBeans(...)");
        Iterable iterable = list;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var15_17 = $this$associateBy$iv;
        String[] destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object element$iv$iv2 = iterator.next();
            SolrSearchResult solrSearchResult = (SolrSearchResult)element$iv$iv2;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv2);
        }
        Map searchResults = destination$iv$iv;
        SolrDocumentList solrDocumentList = searchQueryResponse.getResults();
        if (solrDocumentList != null) {
            Iterable $this$forEach$iv = (Iterable)solrDocumentList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                Map.Entry it$iv$iv;
                Map.Entry it;
                Map map;
                void $this$mapKeysTo$iv$iv;
                Map $this$mapKeys$iv;
                Map $this$filterKeys$iv;
                SolrDocument response = (SolrDocument)element$iv;
                boolean bl = false;
                SolrSearchResult res = (SolrSearchResult)searchResults.get(response.get((Object)"id"));
                Object type = response.get((Object)"type");
                if (res == null || type == null) continue;
                String prefix = "dynamic_unsearchable_" + type + "_";
                Intrinsics.checkNotNull((Object)response);
                Map map2 = (Map)response;
                SolrSearchResult solrSearchResult = res;
                boolean $i$f$filterKeys = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
                    String it2 = (String)entry.getKey();
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it2);
                    if (!StringsKt.startsWith$default((String)it2, (String)prefix, (boolean)false, (int)2, null)) continue;
                    result$iv.put(entry.getKey(), entry.getValue());
                }
                $this$filterKeys$iv = result$iv;
                boolean $i$f$mapKeys = false;
                result$iv = $this$mapKeys$iv;
                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                boolean bl2 = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                boolean $i$f$associateByTo2 = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    map = destination$iv$iv2;
                    boolean bl3 = false;
                    Object k = it.getKey();
                    Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                    String[] stringArray = new String[]{prefix};
                    String key = (String)StringsKt.split$default((CharSequence)((CharSequence)k), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    String string = key;
                    Map map3 = map;
                    boolean bl4 = false;
                    Object v = it$iv$iv.getValue();
                    map3.put(string, v);
                }
                $this$mapKeys$iv = destination$iv$iv2;
                boolean $i$f$mapValues = false;
                $this$mapKeysTo$iv$iv = $this$mapValues$iv;
                Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean bl3 = false;
                $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo3 = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    String string;
                    void it3;
                    void it$iv$iv2;
                    it = (Map.Entry)element$iv$iv$iv;
                    Map map4 = destination$iv$iv3;
                    boolean bl5 = false;
                    it$iv$iv = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv2.getKey();
                    map = map4;
                    boolean bl6 = false;
                    if (it3.getValue() instanceof List) {
                        Object v = it3.getValue();
                        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
                        string = String.valueOf(((List)v).get(0));
                    } else {
                        string = it3.getValue().toString();
                    }
                    String string2 = string;
                    map.put(k, string2);
                }
                solrSearchResult.setAdditionalData(destination$iv$iv3);
            }
        }
        Iterable $this$mapNotNullToSet$iv = searchResults.values();
        boolean $i$f$mapNotNullToSet232 = false;
        $this$associateByTo$iv$iv = $this$mapNotNullToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo232 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            String it$iv$iv;
            CharSequence charSequence;
            element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            SolrSearchResult it = (SolrSearchResult)element$iv$iv;
            boolean bl7 = false;
            CharSequence charSequence2 = it.getParentId();
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl4 = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            if ((String)charSequence == null) continue;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set parentIds = (Set)destination$iv$iv;
        destination$iv$iv = new String[]{CollectionsKt.joinToString$default((Iterable)parentIds, (CharSequence)" OR ", null, null, (int)0, null, (Function1)((Function1)sendSolrQuery.parentInfo.1.INSTANCE), (int)30, null)};
        SolrQuery solrQuery = this.buildSolrQueryForNames(count).addFilterQuery(destination$iv$iv).setHighlight(false);
        Intrinsics.checkNotNullExpressionValue((Object)solrQuery, (String)"setHighlight(...)");
        Iterable $i$f$mapNotNullToSet232 = this.send(solrQuery).getBeans(SolrSearchResult.class);
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapNotNullToSet232, (String)"getBeans(...)");
        $i$f$mapNotNullToSet232 = $i$f$mapNotNullToSet232;
        boolean $i$f$associate = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void $i$f$mapNotNullTo232 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv3 : $this$associateTo$iv$iv) {
            element$iv$iv = destination$iv$iv3;
            SolrSearchResult it = (SolrSearchResult)element$iv$iv3;
            boolean bl = false;
            it = TuplesKt.to((Object)it.getId(), (Object)new SearchResultParentDto(it.getId(), it.getName(), SearchType.valueOf((String)it.getType())));
            element$iv$iv.put((Object)it.getFirst(), (Object)it.getSecond());
        }
        Map parentInfo2 = destination$iv$iv3;
        Map map = searchQueryResponse.getHighlighting();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map highlighting = map;
        Iterable $this$onEach$iv = searchResults.values();
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = $this$associateTo$iv$iv = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            result = (SolrSearchResult)element$iv;
            boolean bl10 = false;
            Map map5 = (Map)highlighting.get(result.getId());
            if (map5 == null) {
                map5 = MapsKt.emptyMap();
            }
            result.setHighlightedFields(map5);
        }
        $this$onEach$iv = searchResults.values();
        long l = searchQueryResponse.getResults().getNumFound();
        long l2 = searchQueryResponse.getResults().getStart() + (long)searchResults.values().size();
        boolean $i$f$map = false;
        $this$associateTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            result = (SolrSearchResult)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl11 = false;
            collection.add(SolrSearchResultDto.Companion.toDto((SolrSearchResult)it, (SearchResultParentDto)parentInfo2.get(it.getParentId())));
        }
        collection = (List)destination$iv$iv4;
        List list2 = collection;
        long l3 = l;
        long l4 = l2;
        return new SearchResult(l4, l3, list2);
    }

    static /* synthetic */ SearchResult sendSolrQuery$default(SearchService searchService, String string, List list, SortBy sortBy, SortDirection sortDirection, ProfileId profileId, TenantId tenantId, int n, int n2, Function1 function1, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendSolrQuery");
        }
        if ((n3 & 0x100) != 0) {
            function1 = (Function1)sendSolrQuery.1.INSTANCE;
        }
        return searchService.sendSolrQuery(string, list, sortBy, sortDirection, profileId, tenantId, n, n2, function1);
    }

    private SolrQuery buildSolrQuery(String query, List<? extends JustApp> apps, SortBy sortBy, SortDirection sortDirection, ProfileId profileId, TenantId tenantId, int offset, int count, Function1<? super SolrQuery, Unit> configure) {
        SolrQuery solrQuery;
        SolrQuery $this$buildSolrQuery_u24lambda_u2410 = solrQuery = new SolrQuery();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)query)) {
            $this$buildSolrQuery_u24lambda_u2410.setQuery(query);
        }
        $this$buildSolrQuery_u24lambda_u2410.setHighlight(true);
        String[] stringArray = new String[]{sortBy.getSortField() + " " + (sortDirection == SortDirection.ASC ? "asc" : "desc")};
        $this$buildSolrQuery_u24lambda_u2410.add("sort", stringArray);
        stringArray = new String[]{String.valueOf(offset)};
        $this$buildSolrQuery_u24lambda_u2410.set("start", stringArray);
        stringArray = new String[]{String.valueOf(count)};
        $this$buildSolrQuery_u24lambda_u2410.set("rows", stringArray);
        stringArray = new String[]{REQUESTED_FIELDS};
        $this$buildSolrQuery_u24lambda_u2410.set("fl", stringArray);
        stringArray = new String[]{CollectionsKt.joinToString$default((Iterable)apps, (CharSequence)" OR ", null, null, (int)0, null, (Function1)((Function1)buildSolrQuery.2.1.INSTANCE), (int)30, null)};
        $this$buildSolrQuery_u24lambda_u2410.addFilterQuery(stringArray);
        String searchRoles = CollectionsKt.joinToString$default((Iterable)this.permissionService.getSearchRoles(profileId), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        String[] stringArray2 = new String[]{searchRoles};
        $this$buildSolrQuery_u24lambda_u2410.add("justRoles", stringArray2);
        stringArray2 = new String[]{tenantId.toCanonicalId()};
        $this$buildSolrQuery_u24lambda_u2410.add("tenantId", stringArray2);
        $this$buildSolrQuery_u24lambda_u2410.setRequestHandler("justSearch");
        configure.invoke((Object)$this$buildSolrQuery_u24lambda_u2410);
        return solrQuery;
    }

    static /* synthetic */ SolrQuery buildSolrQuery$default(SearchService searchService, String string, List list, SortBy sortBy, SortDirection sortDirection, ProfileId profileId, TenantId tenantId, int n, int n2, Function1 function1, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildSolrQuery");
        }
        if ((n3 & 0x100) != 0) {
            function1 = (Function1)buildSolrQuery.1.INSTANCE;
        }
        return searchService.buildSolrQuery(string, list, sortBy, sortDirection, profileId, tenantId, n, n2, function1);
    }

    private SolrQuery buildSolrQueryForNames(int count) {
        SolrQuery solrQuery;
        SolrQuery $this$buildSolrQueryForNames_u24lambda_u2411 = solrQuery = new SolrQuery();
        boolean bl = false;
        String[] stringArray = new String[]{REQUESTED_FIELDS_FOR_PARENT_INFO};
        $this$buildSolrQueryForNames_u24lambda_u2411.set("fl", stringArray);
        stringArray = new String[]{String.valueOf(count)};
        $this$buildSolrQueryForNames_u24lambda_u2411.set("rows", stringArray);
        return solrQuery;
    }

    private QueryResponse send(SolrQuery solrQuery) {
        QueryResponse queryResponse;
        try {
            queryResponse = this.solrClient.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            Intrinsics.checkNotNull((Object)queryResponse);
        }
        catch (Exception e) {
            LOG.error("Error occurred while executing query " + solrQuery, (Throwable)e);
            throw e;
        }
        return queryResponse;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        JustSocialSolrCoreSearchFields $this$REQUESTED_FIELDS_u24lambda_u2412 = JustSocialSolrCoreSearchFields.INSTANCE;
        boolean bl = false;
        REQUESTED_FIELDS = "id, type, just_app_id, modify_date, name, parent_id, dynamic_unsearchable_*";
        JustSocialSolrCoreSearchFields $this$REQUESTED_FIELDS_FOR_PARENT_INFO_u24lambda_u2413 = JustSocialSolrCoreSearchFields.INSTANCE;
        boolean bl2 = false;
        REQUESTED_FIELDS_FOR_PARENT_INFO = "id, name, type";
    }
}

