/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr.config;

import com.google.common.base.Charsets;
import de.justsoftware.searchltr.config.ZookeeperService;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.SetDataBuilder;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0017\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0012J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/searchltr/config/ZookeeperService;", "", "zookeeperClient", "Lorg/apache/curator/framework/CuratorFramework;", "(Lorg/apache/curator/framework/CuratorFramework;)V", "deleteNode", "", "node", "", "getZookeeperString", "path", "resetConfig", "storeInZookeeper", "data", "storeModelName", "storeName", "storeUpcomingFeatureStoreName", "Companion", "search-ltr"})
@SourceDebugExtension(value={"SMAP\nZookeeperService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZookeeperService.kt\nde/justsoftware/searchltr/config/ZookeeperService\n+ 2 LoggerUtils.kt\nde/justsoftware/searchltr/util/LoggerUtilsKt\n*L\n1#1,86:1\n9#2:87\n8#2,3:88\n*S KotlinDebug\n*F\n+ 1 ZookeeperService.kt\nde/justsoftware/searchltr/config/ZookeeperService\n*L\n80#1:87\n80#1:88,3\n*E\n"})
public class ZookeeperService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final CuratorFramework zookeeperClient;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String UPCOMING_FEATURES_STORE_NAME_PATH = "/just/config/just/search/ltr/upcomingFeaturesStoreName";
    @NotNull
    private static final String MODEL_NAME_PATH = "/just/config/just/search/ltr/modelName";

    public ZookeeperService(@NotNull CuratorFramework zookeeperClient) {
        Intrinsics.checkNotNullParameter((Object)zookeeperClient, (String)"zookeeperClient");
        this.zookeeperClient = zookeeperClient;
    }

    public void storeUpcomingFeatureStoreName(@NotNull String storeName) {
        Intrinsics.checkNotNullParameter((Object)storeName, (String)"storeName");
        this.storeInZookeeper(UPCOMING_FEATURES_STORE_NAME_PATH, storeName);
    }

    public void storeModelName(@NotNull String storeName) {
        Intrinsics.checkNotNullParameter((Object)storeName, (String)"storeName");
        this.storeInZookeeper(MODEL_NAME_PATH, storeName);
    }

    public void resetConfig() {
        this.deleteNode(UPCOMING_FEATURES_STORE_NAME_PATH);
        this.deleteNode(MODEL_NAME_PATH);
    }

    public void deleteNode(@NotNull String node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        try {
            ((ChildrenDeletable)this.zookeeperClient.delete().guaranteed()).deletingChildrenIfNeeded().forPath(node);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.info("Node " + node + " does not exist. Skip deleting node.");
        }
    }

    @Nullable
    public String getZookeeperString(@NotNull String path) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            Object object2 = this.zookeeperClient.getData().forPath(path);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"forPath(...)");
            object = (byte[])object2;
            Charset charset = Charsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            object = new String((byte[])object, charset2);
        }
        catch (Exception e) {
            object = null;
        }
        return object;
    }

    private void storeInZookeeper(String path, String data) {
        Object object = this.zookeeperClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"withMode(...)");
        ACLBackgroundPathAndBytesable createBuilder = (ACLBackgroundPathAndBytesable)object;
        try {
            String string = data;
            Charset charset = Charsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            createBuilder.forPath(path, byArray);
            LOG.info("Successfully created Zookeeper path: " + path);
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                SetDataBuilder setDataBuilder = this.zookeeperClient.setData();
                Intrinsics.checkNotNullExpressionValue((Object)setDataBuilder, (String)"setData(...)");
                SetDataBuilder updateBuilder = setDataBuilder;
                String string = data;
                Charset charset = Charsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                updateBuilder.forPath(path, byArray);
                LOG.info("Successfully updated Zookeeper path: " + path);
            }
            catch (Exception e1) {
                LOG.warn("Failed to update path in Zookeeper: " + path + " ", (Throwable)e1);
                throw e1;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to create path in Zookeeper: " + path + " ", (Throwable)e);
            throw e;
        }
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

