/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.graphql;

import com.netflix.graphql.dgs.exceptions.DefaultDataFetcherExceptionHandler;
import com.netflix.graphql.types.errors.ErrorDetail;
import com.netflix.graphql.types.errors.TypedGraphQLError;
import de.justsoftware.news.auth.exceptions.NotAuthorizedException;
import de.justsoftware.news.auth.exceptions.NotFoundException;
import de.justsoftware.news.domain.error.NewsException;
import de.justsoftware.news.domain.post.error.PostAlreadyUpdatedException;
import de.justsoftware.news.graphql.ApiError;
import de.justsoftware.news.graphql.ErrorHandler;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0012J\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/news/graphql/ErrorHandler;", "Lgraphql/execution/DataFetcherExceptionHandler;", "<init>", "()V", "defaultHandler", "Lcom/netflix/graphql/dgs/exceptions/DefaultDataFetcherExceptionHandler;", "getApiError", "Lde/justsoftware/news/graphql/ApiError;", "exception", "Lde/justsoftware/news/domain/error/NewsException;", "handleException", "Ljava/util/concurrent/CompletableFuture;", "Lgraphql/execution/DataFetcherExceptionHandlerResult;", "handlerParameters", "Lgraphql/execution/DataFetcherExceptionHandlerParameters;", "Companion", "news-service"})
public class ErrorHandler
implements DataFetcherExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DefaultDataFetcherExceptionHandler defaultHandler = new DefaultDataFetcherExceptionHandler();
    @NotNull
    private static final Logger log;

    private ApiError getApiError(NewsException exception) {
        return exception instanceof PostAlreadyUpdatedException ? ApiError.POST_ALREADY_UPDATED_ERROR : ApiError.GENERAL_ERROR;
    }

    @Nullable
    public CompletableFuture<DataFetcherExceptionHandlerResult> handleException(@NotNull DataFetcherExceptionHandlerParameters handlerParameters) {
        CompletableFuture<DataFetcherExceptionHandlerResult> completableFuture;
        TypedGraphQLError customError;
        Intrinsics.checkNotNullParameter((Object)handlerParameters, (String)"handlerParameters");
        Throwable exception = handlerParameters.getException();
        log.error("Exception while executing data fetcher for " + handlerParameters.getPath() + ": " + exception.getMessage(), exception);
        Throwable throwable = exception;
        TypedGraphQLError typedGraphQLError = throwable instanceof IllegalArgumentException ? TypedGraphQLError.newBadRequestBuilder().path(handlerParameters.getPath()).message("Bad Request").errorDetail((ErrorDetail)ErrorDetail.Common.INVALID_ARGUMENT).origin(exception.getClass().getSimpleName() + ": " + ((IllegalArgumentException)exception).getMessage()).build() : (throwable instanceof NotAuthorizedException ? TypedGraphQLError.newPermissionDeniedBuilder().path(handlerParameters.getPath()).origin(((NotAuthorizedException)exception).getMessage()).message("Not authorized").build() : (throwable instanceof NotFoundException ? TypedGraphQLError.newNotFoundBuilder().origin(((NotFoundException)exception).getMessage()).path(handlerParameters.getPath()).build() : (throwable instanceof NewsException ? TypedGraphQLError.newConflictBuilder().message(((NewsException)exception).getMessage()).path(handlerParameters.getPath()).extensions(MapsKt.mapOf((Pair)new Pair((Object)"apiError", (Object)this.getApiError((NewsException)exception)))).build() : (customError = throwable instanceof RuntimeException ? TypedGraphQLError.newInternalErrorBuilder().message("Internal Server Error").origin(((RuntimeException)exception).getMessage()).path(handlerParameters.getPath()).build() : null))));
        if (customError == null) {
            completableFuture = CompletableFuture.completedFuture(this.defaultHandler.handleException(handlerParameters).get());
        } else {
            log.error("Exception while executing data fetcher for " + handlerParameters.getPath() + ": " + exception.getMessage(), exception);
            completableFuture = CompletableFuture.completedFuture(DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)customError).build());
        }
        return completableFuture;
    }

    static {
        Logger logger = LoggerFactory.getLogger(ErrorHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

