/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.poll;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.poll.PollAnswer;
import de.justsoftware.news.domain.poll.PollAnswerRepo;
import de.justsoftware.news.domain.poll.PollPrivacy;
import de.justsoftware.news.domain.poll.PollRepo;
import de.justsoftware.news.domain.poll.PollService$findAnswersByPollId$;
import de.justsoftware.news.domain.poll.PollVote;
import de.justsoftware.news.domain.poll.PollVoteRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PollAnswerId;
import de.justsoftware.news.id.PollId;
import de.justsoftware.news.id.PollVoteId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.util.Unauthorized;
import io.micrometer.observation.annotation.Observed;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Observed
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000fH\u0017J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00112\u0006\u0010\u001e\u001a\u00020\u0012H\u0017J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0012H\u0017J2\u0010!\u001a\u0016\u0012\u0004\u0012\u00020\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120%2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/justsoftware/news/domain/poll/PollService;", "", "pollRepo", "Lde/justsoftware/news/domain/poll/PollRepo;", "pollAnswerRepo", "Lde/justsoftware/news/domain/poll/PollAnswerRepo;", "pollVoteRepo", "Lde/justsoftware/news/domain/poll/PollVoteRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "<init>", "(Lde/justsoftware/news/domain/poll/PollRepo;Lde/justsoftware/news/domain/poll/PollAnswerRepo;Lde/justsoftware/news/domain/poll/PollVoteRepo;Lde/justsoftware/news/domain/post/PostRepo;)V", "vote", "Lde/justsoftware/news/domain/poll/Poll;", "pollId", "Lde/justsoftware/news/id/PollId;", "yesAnswers", "", "Lde/justsoftware/news/id/PollAnswerId;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "getById", "id", "findPollByPostId", "postId", "Lde/justsoftware/news/id/PostId;", "findAnswersByPollId", "Lde/justsoftware/news/domain/poll/PollAnswer;", "findVotesByAnswerId", "Lde/justsoftware/news/domain/poll/PollVote;", "pollAnswerId", "voteCountByAnswerId", "", "findVotesToAnswerIds", "", "", "pollAnswerIds", "", "news-service"})
@SourceDebugExtension(value={"SMAP\nPollService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PollService.kt\nde/justsoftware/news/domain/poll/PollService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1863#2,2:104\n1053#2:106\n1557#2:107\n1628#2,3:108\n1557#2:111\n1628#2,3:112\n1202#2,2:115\n1230#2,4:117\n1279#2,2:121\n1293#2,2:123\n774#2:126\n865#2,2:127\n1296#2:129\n1#3:125\n*S KotlinDebug\n*F\n+ 1 PollService.kt\nde/justsoftware/news/domain/poll/PollService\n*L\n39#1:104,2\n60#1:106\n77#1:107\n77#1:108,3\n78#1:111\n78#1:112,3\n78#1:115,2\n78#1:117,4\n80#1:121,2\n80#1:123,2\n99#1:126\n99#1:127,2\n80#1:129\n*E\n"})
public class PollService {
    @NotNull
    private final PollRepo pollRepo;
    @NotNull
    private final PollAnswerRepo pollAnswerRepo;
    @NotNull
    private final PollVoteRepo pollVoteRepo;
    @NotNull
    private final PostRepo postRepo;

    public PollService(@NotNull PollRepo pollRepo, @NotNull PollAnswerRepo pollAnswerRepo, @NotNull PollVoteRepo pollVoteRepo, @NotNull PostRepo postRepo) {
        Intrinsics.checkNotNullParameter((Object)pollRepo, (String)"pollRepo");
        Intrinsics.checkNotNullParameter((Object)pollAnswerRepo, (String)"pollAnswerRepo");
        Intrinsics.checkNotNullParameter((Object)pollVoteRepo, (String)"pollVoteRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        this.pollRepo = pollRepo;
        this.pollAnswerRepo = pollAnswerRepo;
        this.pollVoteRepo = pollVoteRepo;
        this.postRepo = postRepo;
    }

    @Transactional
    @NotNull
    public Poll vote(@NotNull PollId pollId, @NotNull List<PollAnswerId> yesAnswers, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter(yesAnswers, (String)"yesAnswers");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Poll poll = this.pollRepo.getById(pollId);
        Post post = this.postRepo.getByIdAndDeletedFalse(poll.getPostId());
        authContext.checkPostAction(post.getId(), PostAction.VOTE);
        this.pollVoteRepo.deleteAllByPollIdAndProfileId(poll.getId(), authContext.getUser());
        Instant voteDate = Instant.now();
        Iterable $this$forEach$iv = yesAnswers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PollAnswerId it = (PollAnswerId)element$iv;
            boolean bl = false;
            PollVoteId pollVoteId = PollVoteId.Companion.random();
            PollId pollId2 = poll.getId();
            ProfileId profileId = authContext.getUser();
            Intrinsics.checkNotNull((Object)voteDate);
            this.pollVoteRepo.insert(pollVoteId, pollId2, it, profileId, voteDate);
        }
        return poll;
    }

    @Unauthorized
    @NotNull
    public Poll getById(@NotNull PollId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.pollRepo.getById(id);
    }

    @Unauthorized
    @Nullable
    public Poll findPollByPostId(@NotNull PostId postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return this.pollRepo.findByPostId(postId);
    }

    @Unauthorized
    @NotNull
    public List<PollAnswer> findAnswersByPollId(@NotNull PollId pollId) {
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Iterable $this$sortedBy$iv = this.pollAnswerRepo.findAllByPollId(pollId);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new findAnswersByPollId$$inlined$sortedBy$1()));
    }

    @Unauthorized
    @NotNull
    public List<PollVote> findVotesByAnswerId(@NotNull PollAnswerId pollAnswerId) {
        Intrinsics.checkNotNullParameter((Object)pollAnswerId, (String)"pollAnswerId");
        return this.pollVoteRepo.findByAnswerId(pollAnswerId);
    }

    @Unauthorized
    public int voteCountByAnswerId(@NotNull PollAnswerId pollAnswerId) {
        Intrinsics.checkNotNullParameter((Object)pollAnswerId, (String)"pollAnswerId");
        return this.pollVoteRepo.countByAnswerId(pollAnswerId);
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<PollAnswerId, Set<PollVote>> findVotesToAnswerIds(@NotNull Collection<PollAnswerId> pollAnswerIds, @NotNull AuthorizationContext authContext) {
        void $this$associateByTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Iterable answersForBatch;
        Intrinsics.checkNotNullParameter(pollAnswerIds, (String)"pollAnswerIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set uniqueAnswerIds = CollectionsKt.toSet((Iterable)pollAnswerIds);
        Set votesForBatch = this.pollVoteRepo.findByAnswerIdIn(uniqueAnswerIds);
        Iterable iterable = this.pollAnswerRepo.findAllById((Iterable)pollAnswerIds);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"findAllById(...)");
        Iterable iterable2 = answersForBatch = iterable;
        Object object = this.pollRepo;
        boolean $i$f$map22 = false;
        void var10_11 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            PollAnswer pollAnswer = (PollAnswer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPollId());
        }
        Iterable iterable3 = object.findAllById((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"findAllById(...)");
        Set pollsForBatch = CollectionsKt.toSet((Iterable)iterable3);
        Iterable $i$f$map22 = pollsForBatch;
        object = this.postRepo;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Poll bl = (Poll)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getPostId());
        }
        Iterable iterable4 = object.findAllById((Iterable)((List)destination$iv$iv2));
        Intrinsics.checkNotNullExpressionValue((Object)iterable4, (String)"findAllById(...)");
        Iterable $this$associateBy$iv = iterable4;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$mapTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            Post it = (Post)element$iv$iv2;
            object = destination$iv$iv2;
            boolean bl3 = false;
            object.put(it.getId(), element$iv$iv2);
        }
        Object postsForBatch = destination$iv$iv2;
        Iterable $this$associateWith$iv = uniqueAnswerIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Set set;
            Poll poll;
            Object object2;
            Object object3;
            void pollAnswerId;
            Object object42;
            block14: {
                Object v3;
                Object it;
                block13: {
                    Object element$iv$iv2;
                    element$iv$iv2 = (PollAnswerId)element$iv$iv;
                    collection = element$iv$iv;
                    object = result$iv;
                    boolean bl = false;
                    Iterable bl3 = answersForBatch;
                    for (Object object42 : bl3) {
                        it = (PollAnswer)object42;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)pollAnswerId)) continue;
                        v3 = object42;
                        break block13;
                    }
                    v3 = null;
                }
                PollAnswer pollAnswer = v3;
                PollId pollId = pollAnswer != null ? pollAnswer.getPollId() : null;
                object3 = pollsForBatch;
                object42 = object3.iterator();
                while (object42.hasNext()) {
                    it = object42.next();
                    Poll it2 = (Poll)it;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getId(), (Object)pollId)) continue;
                    object2 = it;
                    break block14;
                }
                object2 = null;
            }
            if ((Poll)object2 == null) {
                throw new IllegalStateException("Missing poll for answer: '" + (PollAnswerId)pollAnswerId + "'.");
            }
            if (poll.getPrivacy() == PollPrivacy.ANONYMOUS) {
                set = null;
            } else {
                Object v = postsForBatch.get(poll.getPostId());
                if (v == null) {
                    object3 = "Required value was null.";
                    throw new IllegalArgumentException(object3.toString());
                }
                Post post = (Post)v;
                if (poll.getPrivacy() == PollPrivacy.MANAGERS_ONLY && !Intrinsics.areEqual((Object)authContext.getUser(), (Object)post.getAuthorId()) && !authContext.mayManage((ItemId)post.getChannelId())) {
                    set = null;
                } else {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = votesForBatch;
                    boolean $i$f$filter = false;
                    object42 = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                        PollVote it = (PollVote)element$iv$iv3;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getAnswerId(), (Object)pollAnswerId)) continue;
                        destination$iv$iv3.add(element$iv$iv3);
                    }
                    set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
                }
            }
            Set set2 = set;
            object.put(collection, set2);
        }
        return result$iv;
    }
}

