/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.maintenance;

import de.justsoftware.news.connector.search.SearchConnector;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.kafka.search.KafkaSearchProducer;
import de.justsoftware.news.util.Unauthorized;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0010\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/news/domain/maintenance/MaintenanceService;", "", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "searchConnector", "Lde/justsoftware/news/connector/search/SearchConnector;", "kafkaSearchProducer", "Lde/justsoftware/news/kafka/search/KafkaSearchProducer;", "<init>", "(Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/connector/search/SearchConnector;Lde/justsoftware/news/kafka/search/KafkaSearchProducer;)V", "reIndexSearchForTenant", "", "tenantId", "Lde/justsoftware/news/id/TenantId;", "reIndexSearchForAllTenants", "news-service"})
public class MaintenanceService {
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final SearchConnector searchConnector;
    @NotNull
    private final KafkaSearchProducer kafkaSearchProducer;

    public MaintenanceService(@NotNull ChannelRepo channelRepo, @NotNull PostRepo postRepo, @NotNull SearchConnector searchConnector, @NotNull KafkaSearchProducer kafkaSearchProducer) {
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)searchConnector, (String)"searchConnector");
        Intrinsics.checkNotNullParameter((Object)kafkaSearchProducer, (String)"kafkaSearchProducer");
        this.channelRepo = channelRepo;
        this.postRepo = postRepo;
        this.searchConnector = searchConnector;
        this.kafkaSearchProducer = kafkaSearchProducer;
    }

    @Unauthorized
    public void reIndexSearchForTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.searchConnector.deleteAllForTenant(tenantId);
        this.kafkaSearchProducer.reindex(tenantId);
        List channelIds = this.channelRepo.getIdsByTenant(tenantId);
        if (channelIds.isEmpty()) {
            return;
        }
        Set postIds = this.postRepo.findPostIdsByChannelIds(CollectionsKt.toSet((Iterable)channelIds));
        this.kafkaSearchProducer.addToSearchIndexQueue(CollectionsKt.toSet((Iterable)channelIds));
        this.kafkaSearchProducer.addToSearchIndexQueue(CollectionsKt.toSet((Iterable)postIds));
    }

    @Unauthorized
    public void reIndexSearchForAllTenants() {
        this.searchConnector.deleteAll();
        KafkaSearchProducer.reindex$default((KafkaSearchProducer)this.kafkaSearchProducer, null, (int)1, null);
        List channelIds = this.channelRepo.getAllNotDeletedIds();
        if (channelIds.isEmpty()) {
            return;
        }
        Set postIds = this.postRepo.findPostIdsByChannelIds(CollectionsKt.toSet((Iterable)channelIds));
        this.kafkaSearchProducer.addToSearchIndexQueue(CollectionsKt.toSet((Iterable)channelIds));
        this.kafkaSearchProducer.addToSearchIndexQueue(CollectionsKt.toSet((Iterable)postIds));
    }
}

