/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.config;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.config.Config;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.TenantId;
import io.micrometer.observation.annotation.Observed;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Observed
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/justsoftware/news/domain/config/ConfigService;", "", "commentsDisabled", "", "<init>", "(Z)V", "getConfig", "Lde/justsoftware/news/domain/config/Config;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "news-service"})
public class ConfigService {
    private final boolean commentsDisabled;

    public ConfigService(@Value(value="${just.news.comments.disabled.default}") boolean commentsDisabled) {
        this.commentsDisabled = commentsDisabled;
    }

    @NotNull
    public Config getConfig(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = authContext.getTenantId();
        authContext.checkRead((ItemId)tenantId);
        boolean isSuperAdmin = authContext.isSuperAdmin();
        return new Config(tenantId, authContext.mayCreateChannel(), isSuperAdmin, this.commentsDisabled);
    }
}

