/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.permission;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.news.auth.exceptions.NotAuthorizedException;
import de.justsoftware.news.connector.permission.PermissionConnector;
import de.justsoftware.news.connector.permission.PermissionConnectorKt;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import io.micrometer.observation.annotation.Observed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Observed
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000e0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000e0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u001f\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010!\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\n0\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\nH\u0016J*\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020'0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u000b\u001a\u00020\fH\u0012J*\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020'0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u000b\u001a\u00020\fH\u0012J*\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020'0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u000b\u001a\u00020\fH\u0012J:\u0010*\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020'0\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010,\u001a\u00020-H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lde/justsoftware/news/connector/permission/PermissionConnector;", "", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "<init>", "(Lde/justsoftware/permission/client/rest/PermissionRequestConnector;)V", "filterUsersRoles", "", "Lde/justsoftware/permission/client/model/Role;", "itemRoles", "", "userId", "Lde/justsoftware/news/id/UserId;", "mayRead", "", "item", "Lde/justsoftware/news/id/ItemId;", "", "items", "mayManage", "mayManageAll", "mayWriteAppNews", "tenantId", "Lde/justsoftware/news/id/TenantId;", "isSuperAdmin", "checkRead", "", "itemId", "checkReadAll", "itemIds", "checkWrite", "checkWriteAll", "checkManage", "checkManageAll", "checkAppWriterNews", "checkSuperAdmin", "getRolesWhoRead", "", "mayReadResults", "Lde/justsoftware/permission/client/model/AuthorizationResult;", "mayWriteResults", "mayManageResults", "checkItemResults", "permissionResults", "roleToCheck", "Lde/justsoftware/news/connector/permission/PermissionConnector$Companion$RoleToCheck;", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nPermissionConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionConnector.kt\nde/justsoftware/news/connector/permission/PermissionConnector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,177:1\n462#2:178\n412#2:179\n462#2:184\n412#2:185\n477#2:216\n423#2:217\n462#2:222\n412#2:223\n477#2:232\n423#2:233\n462#2:238\n412#2:239\n477#2:248\n423#2:249\n462#2:254\n412#2:255\n1246#3,4:180\n1246#3,4:186\n1734#3,3:193\n1734#3,3:196\n1557#3:199\n1628#3,3:200\n1187#3,2:203\n1261#3,2:205\n1557#3:207\n1628#3,3:208\n1264#3:211\n1557#3:212\n1628#3,3:213\n1246#3,4:218\n1246#3,4:224\n1557#3:228\n1628#3,3:229\n1246#3,4:234\n1246#3,4:240\n1557#3:244\n1628#3,3:245\n1246#3,4:250\n1246#3,4:256\n1863#3,2:260\n168#4,3:190\n*S KotlinDebug\n*F\n+ 1 PermissionConnector.kt\nde/justsoftware/news/connector/permission/PermissionConnector\n*L\n47#1:178\n47#1:179\n52#1:184\n52#1:185\n126#1:216\n126#1:217\n127#1:222\n127#1:223\n135#1:232\n135#1:233\n136#1:238\n136#1:239\n144#1:248\n144#1:249\n145#1:254\n145#1:255\n47#1:180,4\n52#1:186,4\n61#1:193,3\n70#1:196,3\n114#1:199\n114#1:200,3\n117#1:203,2\n117#1:205,2\n117#1:207\n117#1:208,3\n117#1:211\n123#1:212\n123#1:213,3\n126#1:218,4\n127#1:224,4\n132#1:228\n132#1:229,3\n135#1:234,4\n136#1:240,4\n141#1:244\n141#1:245,3\n144#1:250,4\n145#1:256,4\n157#1:260,2\n55#1:190,3\n*E\n"})
public class PermissionConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;
    @NotNull
    private static final Logger log;

    public PermissionConnector(@NotNull PermissionRequestConnector permissionRequestConnector) {
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        this.permissionRequestConnector = permissionRequestConnector;
    }

    @NotNull
    public Set<Role> filterUsersRoles(@NotNull Collection<Role> itemRoles, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter(itemRoles, (String)"itemRoles");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        ImmutableSet immutableSet = this.permissionRequestConnector.filterRoles((Iterable)CollectionsKt.toSet((Iterable)itemRoles), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString())));
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"filterRoles(...)");
        return (Set)immutableSet;
    }

    public boolean mayRead(@NotNull ItemId item, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return (Boolean)CollectionsKt.first((Iterable)this.mayRead((Collection)CollectionsKt.listOf((Object)item), userId).values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ItemId, Boolean> mayRead(@NotNull Collection<? extends ItemId> items, @NotNull UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Map $this$mapValues$iv = this.mayReadResults(items, userId);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Boolean bl3 = it.getValue() == AuthorizationResult.OK;
            map3.put(k, bl3);
        }
        return destination$iv$iv;
    }

    public boolean mayManage(@NotNull ItemId item, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return (Boolean)CollectionsKt.first((Iterable)this.mayManage((Collection)CollectionsKt.listOf((Object)item), userId).values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ItemId, Boolean> mayManage(@NotNull Collection<? extends ItemId> items, @NotNull UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Map $this$mapValues$iv = this.mayManageResults(items, userId);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Boolean bl3 = it.getValue() == AuthorizationResult.OK;
            map3.put(k, bl3);
        }
        return destination$iv$iv;
    }

    public boolean mayManageAll(@NotNull Collection<? extends ItemId> items, @NotNull UserId userId) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Map $this$all$iv = this.mayManageResults(items, userId);
            boolean $i$f$all = false;
            if ($this$all$iv.isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (it.getValue() == AuthorizationResult.OK) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean mayWriteAppNews(@NotNull TenantId tenantId, @NotNull UserId userId) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Collection collection = this.permissionRequestConnector.hasRoles((Iterable)SetsKt.setOf((Object)Role.write((String)("APP,news_" + tenantId.getValue()))), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString()))).values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    AuthorizationResult it = (AuthorizationResult)element$iv;
                    boolean bl2 = false;
                    if (it == AuthorizationResult.OK) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean isSuperAdmin(@NotNull UserId userId) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Collection collection = this.permissionRequestConnector.hasRoles((Iterable)SetsKt.setOf((Object)Role.SUPERADMIN), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString()))).values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    AuthorizationResult it = (AuthorizationResult)element$iv;
                    boolean bl2 = false;
                    if (it == AuthorizationResult.OK) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public void checkRead(@NotNull ItemId itemId, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.checkReadAll((Collection)SetsKt.setOf((Object)itemId), userId);
    }

    public void checkReadAll(@NotNull Collection<? extends ItemId> itemIds, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Map permissionResults = this.mayReadResults(itemIds, userId);
        this.checkItemResults(itemIds, permissionResults, userId, Companion.RoleToCheck.READ);
    }

    public void checkWrite(@NotNull ItemId itemId, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.checkWriteAll((Collection)SetsKt.setOf((Object)itemId), userId);
    }

    public void checkWriteAll(@NotNull Collection<? extends ItemId> itemIds, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Map permissionResults = this.mayWriteResults(itemIds, userId);
        this.checkItemResults(itemIds, permissionResults, userId, Companion.RoleToCheck.WRITE);
    }

    public void checkManage(@NotNull ItemId itemId, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.checkManageAll((Collection)SetsKt.setOf((Object)itemId), userId);
    }

    public void checkManageAll(@NotNull Collection<? extends ItemId> itemIds, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Map permissionResults = this.mayManageResults(itemIds, userId);
        this.checkItemResults(itemIds, permissionResults, userId, Companion.RoleToCheck.MANAGE);
    }

    public void checkAppWriterNews(@NotNull TenantId tenantId, @NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (!this.mayWriteAppNews(tenantId, userId)) {
            throw new NotAuthorizedException("User '" + userId.toTypedString() + "' is not authorized to WRITE APP NEWS!");
        }
    }

    public void checkSuperAdmin(@NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (!this.isSuperAdmin(userId)) {
            throw new NotAuthorizedException("User '" + userId.toTypedString() + "' is not SUPERADMIN!");
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ItemId, Collection<String>> getRolesWhoRead(@NotNull Collection<? extends ItemId> itemIds) {
        void $this$associateTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Iterable iterable = CollectionsKt.toSet((Iterable)itemIds);
        PermissionRequestConnector permissionRequestConnector = this.permissionRequestConnector;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (ItemId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toTypedString());
        }
        Set set = permissionRequestConnector.visibility((Iterable)((List)destination$iv$iv)).asMap().entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-entries>(...)");
        Iterable $this$associate$iv = set;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$mapTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            object = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            ItemId itemId = ItemId.Companion.fromString((String)k);
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            Iterable iterable2 = (Iterable)v;
            ItemId itemId2 = itemId;
            boolean $i$f$map2 = false;
            void var16_20 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void role;
                Role role2 = (Role)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(role.asString());
            }
            Pair pair = TuplesKt.to((Object)itemId2, (Object)((List)destination$iv$iv2));
            object.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ItemId, AuthorizationResult> mayReadResults(Collection<? extends ItemId> items, UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Map $this$mapKeysTo$iv$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.toSet((Iterable)items);
        Object object2 = this.permissionRequestConnector;
        boolean $i$f$map22 = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemId itemId = (ItemId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.read((String)it.toTypedString()));
        }
        ImmutableMap immutableMap = object2.hasRoles((Iterable)((List)destination$iv$iv), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString())));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"hasRoles(...)");
        Map $this$mapKeys$iv = (Map)immutableMap;
        boolean $i$f$mapKeys = false;
        Map $i$f$map22 = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Object it2;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl2 = false;
            Object k = it2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = PermissionConnectorKt.toItemId((Role)((Role)k));
            Object object3 = object2;
            boolean bl3 = false;
            it2 = it$iv$iv.getValue();
            object3.put(object, it2);
        }
        Map $this$mapValues$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry it2 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            object = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object2 = map;
            boolean bl4 = false;
            AuthorizationResult authorizationResult = (AuthorizationResult)it.getValue();
            object2.put(collection, authorizationResult);
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ItemId, AuthorizationResult> mayWriteResults(Collection<? extends ItemId> items, UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Map $this$mapKeysTo$iv$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.toSet((Iterable)items);
        Object object2 = this.permissionRequestConnector;
        boolean $i$f$map22 = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemId itemId = (ItemId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.write((String)it.toTypedString()));
        }
        ImmutableMap immutableMap = object2.hasRoles((Iterable)((List)destination$iv$iv), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString())));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"hasRoles(...)");
        Map $this$mapKeys$iv = (Map)immutableMap;
        boolean $i$f$mapKeys = false;
        Map $i$f$map22 = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Object it2;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl2 = false;
            Object k = it2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = PermissionConnectorKt.toItemId((Role)((Role)k));
            Object object3 = object2;
            boolean bl3 = false;
            it2 = it$iv$iv.getValue();
            object3.put(object, it2);
        }
        Map $this$mapValues$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry it2 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            object = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object2 = map;
            boolean bl4 = false;
            AuthorizationResult authorizationResult = (AuthorizationResult)it.getValue();
            object2.put(collection, authorizationResult);
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ItemId, AuthorizationResult> mayManageResults(Collection<? extends ItemId> items, UserId userId) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Map $this$mapKeysTo$iv$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.toSet((Iterable)items);
        Object object2 = this.permissionRequestConnector;
        boolean $i$f$map22 = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemId itemId = (ItemId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.manage((String)it.toTypedString()));
        }
        ImmutableMap immutableMap = object2.hasRoles((Iterable)((List)destination$iv$iv), (Iterable)SetsKt.setOf((Object)Role.create((String)userId.toTypedString())));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"hasRoles(...)");
        Map $this$mapKeys$iv = (Map)immutableMap;
        boolean $i$f$mapKeys = false;
        Map $i$f$map22 = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Object it2;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl2 = false;
            Object k = it2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = PermissionConnectorKt.toItemId((Role)((Role)k));
            Object object3 = object2;
            boolean bl3 = false;
            it2 = it$iv$iv.getValue();
            object3.put(object, it2);
        }
        Map $this$mapValues$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry it2 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            object = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object2 = map;
            boolean bl4 = false;
            AuthorizationResult authorizationResult = (AuthorizationResult)it.getValue();
            object2.put(collection, authorizationResult);
        }
        return destination$iv$iv2;
    }

    private void checkItemResults(Collection<? extends ItemId> itemIds, Map<ItemId, ? extends AuthorizationResult> permissionResults, UserId userId, Companion.RoleToCheck roleToCheck) {
        List notAllowed = new ArrayList();
        List notFound = new ArrayList();
        Iterable $this$forEach$iv = itemIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemId it = (ItemId)element$iv;
            boolean bl = false;
            AuthorizationResult authorizationResult = permissionResults.get(it);
            switch (authorizationResult == null ? -1 : WhenMappings.$EnumSwitchMapping$0[authorizationResult.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    notFound.add(it);
                    break;
                }
                case 3: {
                    notAllowed.add(it);
                    break;
                }
                default: {
                    notAllowed.add(it);
                }
            }
        }
        if (!((Collection)notAllowed).isEmpty()) {
            log.warn("User: '" + userId.toTypedString() + "' is not authorized to " + roleToCheck + " items: '" + notAllowed + "'.");
        }
        if (!((Collection)notFound).isEmpty()) {
            log.error("Items not known to permission: '" + notFound + "'.");
        }
        if (!((Collection)notAllowed).isEmpty() || !((Collection)notFound).isEmpty()) {
            throw new NotAuthorizedException("User: '" + userId.toTypedString() + "' is not authorized.");
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(PermissionConnector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

